// =================================================================================================
// ADOBE SYSTEMS INCORPORATED
// Copyright 2011 Adobe Systems Incorporated
// All Rights Reserved
//
// NOTICE:  Adobe permits you to use, modify, and distribute this file in accordance with the terms
// of the Adobe license agreement accompanying it.
// =================================================================================================

package com.adobe.xmp.schema.model;

import java.io.Serializable;
import java.util.List;


/**
 * Describes a single XMP namespace.
 * Contains a list of properties that are part of the schema.
 */
public interface SchemaDescription extends Serializable
{
	/**
	 * @return Returns the schema namespace.
	 */
	String getNamespaceURI();
	
	/**
	 * @return Returns the default label.
	 */
	String getLabel();
	
	/**
	 * @param label Sets the default label
	 */
	void setLabel(String label);
	
	/**
	 * @return Returns the default description.
	 */
	String getDescription();
	
	/**
	 * @param description Sets the default description
	 */
	void setDescription(String description);
	
	/**
	 * Adds a property to the schema. The namespaceURI of the property is set to the 
	 * schema's namespace even if it had a different value before.
	 * @param property an PropertyDescription
	 */
	void addProperty(PropertyDescription property);
	
	/**
	 * @param localName the local name of a property
	 * @return Returns a property or null if not existing.
	 */
	PropertyDescription getProperty(String localName);
	
	/**
	 * @return Returns a list of all properties contained in the schema.
	 */
	List<PropertyDescription> getProperties();
	
	/**
	 * Removes a property from the schema namespace.
	 * @param localName the local name of the property to remove
	 */
	void removeProperty(String localName);

	/**
	 * @param schemaVisitor a visitor that implements the <code>SchemaVisitor</code>-interface
	 * @throws XMPSchemaException Handles visitor exceptions
	 */
	void accept(SchemaVisitor schemaVisitor) throws XMPSchemaException;
}
