package com.day.cq.analytics.sitecatalyst.util;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.day.cq.analytics.sitecatalyst.impl.servlets.SitecatalystServlet;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Map;

public class AnalyticsConfig {

    private String companyId;
    private String apiKey;
    private String token = null;

    private static final Logger log = LoggerFactory.getLogger(AnalyticsConfig.class);

    public AnalyticsConfig(Map config, TokenProviderProxy tokenProviderProxy)
    {
        companyId = PropertiesUtil.toString(config.get(SitecatalystServlet.PN_COMPANYID), "");
        String imsConfigId = PropertiesUtil.toString(config.get(SitecatalystServlet.IMS_CONFIG_ID), "");
        apiKey = tokenProviderProxy.getApikey(imsConfigId);
        try {
            token = tokenProviderProxy.getAccessToken(imsConfigId);
        } catch (Exception e) {
            log.error("Cannot get the access token for {}", imsConfigId);
        }
    }

    @Nonnull
    public String getCompanyId() {
        return companyId;
    }

    @Nonnull
    public String getApikey() {
        return apiKey;
    }

    @Nullable
    public String getAccessToken()  {
        return token;
    }

}

