/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.commons.servlets;

import org.apache.commons.collections.Predicate;
import org.apache.felix.scr.annotations.sling.SlingServlet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestPathInfo;
import org.apache.sling.api.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.servlet.ServletException;
import java.io.IOException;

/**
 * Forwards to the resource considering the resource search path ("/apps", "/libs", etc.).
 * If a suffix is provided a resource of the name of the requested resource will be searched
 * inside the paths provided by the suffix. If the suffix contains a period after the last
 * slash the part behind this period will be ignored.<br>
 * @deprecated use  {@link com.day.cq.commons.predicates.servlets.OverlayServlet} instead
 * <br>
 * Sample without suffix:<br>
 * Request: /libs/x/y/z.overlay.infinity.json<br>
 * The request will be forwarded to the first resource found in the following order
 * (taking "/apps" and "/libs" as given resource search paths):<br>
 * /apps/x/y/z.infinity.json<br>
 * /libs/x/y/z.infinity.json<br>
 * <br>
 * Sample with suffix:<br>
 * Request: /libs/x/y/z.overlay.infinity.json/a/b.json<br>
 * The request will be forwarded to the first resource found in the following order
 * (taking "/apps" and "/libs" as given resource search paths):<br>
 * /apps/x/y/a/b/z.infinity.json<br>
 * /libs/x/y/a/b/z.infinity.json<br>
 * /apps/x/y/a/z.infinity.json<br>
 * /libs/x/y/a/z.infinity.json<br>
 * /apps/x/y/z.infinity.json<br>
 * /libs/x/y/z.infinity.json<br>
 */
@SlingServlet(
        selectors = OverlayServlet.OVERLAY,
        resourceTypes = "sling/servlet/default",
        methods = "GET",
        metatype = false
)
@Deprecated
public class OverlayServlet extends AbstractPredicateServlet {

    private static final long serialVersionUID = 2266516903915391606L;

    /**
     * selector value
     */
    public static final String OVERLAY = "overlay";

    private final Logger log = LoggerFactory.getLogger(OverlayServlet.class);

    /**
     * {@inheritDoc}
     * @deprecated
     */
    @Override
    @Deprecated
    protected void doGet(SlingHttpServletRequest req,
                         SlingHttpServletResponse resp,
                         Predicate predicate)
            throws ServletException, IOException {
        log.warn("OverlayServlet GET method has been deprecated. Please use com.day.cq.commons.predicates.servlets.OverlayServlet GET method instead.");
        // request: /libs/x/y/z.overlay.json/a/b.json
        String path = req.getResource().getPath();

        // remove resource search path ("/libs" or "/apps")
        // path: x/y/z
        path = path.substring(path.indexOf("/", 1) + 1);

        Resource r = null;
        RequestPathInfo info = req.getRequestPathInfo();
        String suffix = info.getSuffix();

        if (suffix != null) {
            // name: z
            String name = path.substring(path.lastIndexOf("/") + 1);

            // basePath: x/y
            String basePath = path.substring(0, path.lastIndexOf("/"));

            // s: /a/b
            String s = suffix;
            if (s.lastIndexOf(".") > s.lastIndexOf("/")) {
                // assuming suffix has an extension: /a/b.json >> a/b
                s = s.substring(0, s.lastIndexOf("."));
            }
            while(s.indexOf("/") != -1) {
                r = req.getResourceResolver().getResource(basePath + s + "/" + name);
                if (r != null) {
                    break;
                }
                s = s.substring(0, s.lastIndexOf("/"));
            }
        }

        if (r == null) {
            // no suffix or final fallback
            r = req.getResourceResolver().getResource(path);
        }

        if (r != null) {
            String sel = info.getSelectorString();
            // remove "overlay" selector
            if (sel.equals(OVERLAY)) sel = "";
            else sel = "." + sel.substring(sel.indexOf(".") + 1);

            String ext = info.getExtension();
            if (ext == null) ext = "";
            else ext = "." + ext;

            String url = r.getPath() + sel + ext;
            req.getRequestDispatcher(url).forward(req, resp);
        }
    }

}