/******************************************************************************
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2024 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 ******************************************************************************/

package com.day.cq.dam.commons.metadata;

import com.adobe.xmp.schema.model.SchemaDescription;
import com.adobe.xmp.schema.service.SchemaCache;

import java.util.HashMap;
import java.util.Map;

/**
 * This is copied from {@link com.adobe.xmp.schema.service.defaults.DefaultSchemaCache}.java, which is not exported from
 * the schema service bundle.
 */
class DamSchemaCache implements SchemaCache {
    /**
     * Map namespace --> schema description
     */
    private final Map<String, SchemaDescription> cache = new HashMap<>();


    /**
     * @see com.adobe.xmp.schema.service.SchemaCache#get(String)
     */
    public SchemaDescription get(String namespaceURI) {
        return cache.get(namespaceURI);
    }


    /**
     * Updated schemas for an existing namespace replace the existing ones.
     *
     * @see com.adobe.xmp.schema.service.SchemaCache#put(String, com.adobe.xmp.schema.model.SchemaDescription)
     */
    public void put(String namespaceURI, SchemaDescription schemaDescription) {
        if (namespaceURI != null && !namespaceURI.isEmpty()) {
            cache.put(namespaceURI, schemaDescription);
        }
    }
}
