/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2016 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.dam.scene7.api;

import java.util.List;

import org.apache.sling.api.resource.Resource;

import org.osgi.annotation.versioning.ProviderType;

import com.day.cq.dam.scene7.api.model.Scene7Asset;

/**
 *
 * This API bridges some of the functionality from the Scene7 bundle for usage in the S7dam bundle.
 *
 */
@ProviderType
public interface Scene7AEMBridge {

    /**
     *
     * @param assetHandle asset metadata property imported from IPS during asset ingestion
     * @param ipsCompanySharedDirectory directory in AEM that maps to the company in IPS that is to be queried
     * @return ArrayList containing all members assets of the set whose handle is being queried against
     */
    List<Scene7Asset> getAllMembersOfBatchSetByAssetHandle(String assetHandle, Resource ipsCompanySharedDirectory);

    /**
     *
     * @param asset AEM Asset which has been ingested by IPS and has appropriate IPS metadata on it
     * @return ArrayList containing all sets that contain asset
     */
    List<Scene7Asset> getAllBatchSetsContainingAsset(Resource asset);

    /**
     *
     * @param resource AEM resource that has relevant IPS ingestion metadata. If not, we recursively look at the resource's
     *                 directory structure to see if any of the parent folders have the necessary metadata
     * @return S7Config object derived from IPS ingestion metadata
     * @deprecated Warning: this method leaks ResourceResolver! Use {@link S7ConfigResolver} service instead!
     */
    @Deprecated
    S7Config getS7configFromResource(Resource resource);

    /**
     *
     * @param assetHandles IPS ingestion metadata used to query IPS for these assets
     * @param ipsCompanySharedDirectory directory in AEM that maps to the company in IPS that is to be queried
     * @return ArrayList containing Scene7 object representations of the assets as they exist in IPS
     */
    List<Scene7Asset> getAssetsByHandles(String[] assetHandles, Resource ipsCompanySharedDirectory);

    /**
     *
     * @param resource AEM resource that ingest into S7
     * @return Asset's publish URL
     */
    String getS7AssetPublishUrl(Resource resource);

    /**
     *
     * @param resource AEM resource that ingest into S7
     * @return Asset's preview URL
     */
    String getS7AssetPreviewUrl(Resource resource);

}
