/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.dam.scene7.api;

import java.net.URL;

import org.jetbrains.annotations.Nullable;
import org.osgi.annotation.versioning.ProviderType;

/**
 * This class provides the abstractization for a Scene7 endpoint.
 */
@ProviderType
@NotNullApi
public class Scene7Endpoint implements Comparable<Scene7Endpoint> {
    public static final int DEFAULT_PORT = 80;

    private final URL apiURL;
    private final URL ipsURL;
    private final URL spsURL;
    private final URL viewerSdkURL;
    private final String apiVersion;
    private final String region;
    private final String description;
    private final URL defaultSecurePreviewURL;

    /**
     * Initializes a default {@code Scene7Endpoint}.
     * 
     * @param apiURL
     * @param ipsURL
     * @param apiVersion
     * @param region
     * @param description
     * @param defaultSecurePreviewURL
     */
    public Scene7Endpoint(final URL apiURL, final URL ipsURL, final URL spsURL,
                          final String apiVersion, final String region,
                          final String description, @Nullable final URL defaultSecurePreviewURL) {
        this.apiURL = apiURL;
        this.ipsURL = ipsURL;
        this.spsURL = spsURL;
        this.viewerSdkURL = null;
        this.apiVersion = apiVersion;
        this.region = region;
        this.description = description;
        this.defaultSecurePreviewURL = defaultSecurePreviewURL;
    }

    /**
     * Initializes a default {@code Scene7Endpoint}.
     * 
     * @param apiURL
     * @param ipsURL
     * @param spsURL
     * @param viewerSdkURL
     * @param apiVersion
     * @param region
     * @param description
     * @param defaultSecurePreviewURL
     */
    public Scene7Endpoint(final URL apiURL, final URL ipsURL, final URL spsURL, final URL viewerSdkURL,
            final String apiVersion, final String region,
            final String description, @Nullable final URL defaultSecurePreviewURL) {
        this.apiURL = apiURL;
        this.ipsURL = ipsURL;
        this.spsURL = spsURL;
        this.viewerSdkURL = viewerSdkURL;
        this.apiVersion = apiVersion;
        this.region = region;
        this.description = description;
        this.defaultSecurePreviewURL = defaultSecurePreviewURL;
    }

    /**
     * Initializes a default {@code Scene7Endpoint}.
     * 
     * @param apiURL
     * @param ipsURL
     * @param spsURL
     * @param viewerSdkURL
     * @param apiVersion
     * @param region
     * @param description
     */
    @Deprecated
    public Scene7Endpoint(final URL apiURL, final URL ipsURL, final URL spsURL,
            final URL viewerSdkURL, final String apiVersion,
            final String region, final String description) {
        this(apiURL, ipsURL, spsURL, viewerSdkURL, apiVersion, region,
                description, null);
    }

    /**
     * Initializes a default {@code Scene7Endpoint}.
     * 
     * @param apiURL
     * @param ipsURL
     * @param apiVersion
     * @param region
     * @param description
     */
    @Deprecated
    public Scene7Endpoint(final URL apiURL, final URL ipsURL, final URL spsURL,
            final String apiVersion, final String region,
            final String description) {
        this(apiURL, ipsURL, spsURL, apiVersion, region, description, null);
    }

    @Override
    public String toString() {
        final StringBuilder sb = new StringBuilder();
        sb.append("Region: ").append(region);
        sb.append("; Description: ").append(description);
        sb.append("; API URL: ").append(apiURL);
        sb.append("; IPS URL: ").append(ipsURL);
        sb.append("; SPS URL: ").append(spsURL);
        sb.append("; Viewer SDK URL: ").append(viewerSdkURL != null ? viewerSdkURL : "");
        sb.append("; API Version: ").append(apiVersion);
        sb.append("; Default Secure Preview URL: ").append(defaultSecurePreviewURL != null ? defaultSecurePreviewURL : "");
        return sb.toString();
    }

    public URL getApiURL() {
        return apiURL;
    }

    public URL getIpsURL() {
        return ipsURL;
    }

    public URL getSpsURL() {
        return spsURL;
    }

    @Nullable
    public URL getViewerSdkURL() {
        return viewerSdkURL;
    }

    public String getApiVersion() {
        return apiVersion;
    }

    public String getRegion() {
        return region;
    }

    public String getDescription() {
        return description;
    }

    @Nullable
    public URL getDefaultSecurePreviewURL() {
        return defaultSecurePreviewURL;
    }

    @Override
    public int compareTo(Scene7Endpoint o) {
        return this.description.compareTo(o.description);
    }

    @Override
    public boolean equals(Object obj) {
        return (obj instanceof Scene7Endpoint)
                && (this.description.equals(((Scene7Endpoint) obj).description));
    }

    @Override
    public int hashCode() {
        return this.description.hashCode();
    }
}
