/*************************************************************************
* ADOBE CONFIDENTIAL
* ___________________
*
*  Copyright Dec 14, 2017 Adobe Systems Incorporated
*  All Rights Reserved.
*
* NOTICE:  All information contained herein is, and remains
* the property of Adobe Systems Incorporated and its suppliers,
* if any.  The intellectual and technical concepts contained
* herein are proprietary to Adobe Systems Incorporated and its
* suppliers and are protected by all applicable intellectual property
* laws, including trade secret and copyright laws.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from Adobe Systems Incorporated.
**************************************************************************/

package com.day.cq.dam.scene7.api.model;


public class IpsApiException extends RuntimeException {

    private static final long serialVersionUID = -7445252449047486682L;
    int code;
    String reason;
    String ipsApiMethodName;
    private static final int CODE_INTERNAL = -1;
    private static final int CODE_EXTERNAL = -2;

    // ips faults
    public IpsApiException(int code, String reason, String ipsApiMethodName) {
        super("IPS API fault code=" + String.valueOf(code) + ": " + reason);
        this.code = code;
        this.reason = reason;
        this.ipsApiMethodName = ipsApiMethodName;
    }

    // internal faults e.g. no config
    public IpsApiException(String message) {
        super(message);
        this.code = CODE_INTERNAL;
        this.reason = message;
        this.ipsApiMethodName = "-";
    }

    // other exceptions e.g. IOException
    public IpsApiException(Throwable cause) {
        super(cause);
        this.code = CODE_EXTERNAL;
        this.reason = "Caused by exception: " + cause.getMessage();
        this.ipsApiMethodName = "-";
    }

    /**
     * @return the code
     */
    public int getCode() {
        return code;
    }

    /**
     * @return the reason
     */
    public String getReason() {
        return reason;
    }

    /**
     * @return the IPS API method where fault occurred
     */
    public String getIpsApiMethodName() {
        return ipsApiMethodName;
    }

}
