/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.mcm.api;

import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;

import com.day.cq.mcm.util.NormalizedResource;
import com.day.cq.wcm.api.Page;

/**
 * Helps with the implementation of a {@link Touchpoint}. Assumes that
 * the passed {@link Resource} is a {@link Page} and the resource that
 * represents the {@link Touchpoint}.
 */
public abstract class TouchpointAdapter implements Touchpoint {
	
	private NormalizedResource normalizedResource;

	public TouchpointAdapter() {
		super();
	}
	
	public void init(Resource r) {
		if (r==null) throw new NullPointerException("Passed null as Resource r.");
		this.normalizedResource = new NormalizedResource();
		this.normalizedResource.setResource(r);
	}
	
	public Page getPage() {
		return normalizedResource.getResource().adaptTo(Page.class);
	}
	
	public String getTitle() {
		return getProperties().get("jcr:title", String.class);
	}
	
	public ValueMap getProperties() {
		return normalizedResource.getContentVals();
	}
}
