/*
 * Copyright 1997-2011 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.notification.api;

import java.util.List;

/**
 * <code>ChannelProvider</code>...
 */
public interface ChannelProvider {
    /**
     * Retrieves all channels currently registered within the system.
     *
     * @return A {@link List} of channels.
     */
    List<Channel> getChannels();

    /**
     * Retrieves the channels defined within a {@link Subscription}.
     *
     * @param subscription The subscription for which to get the channels.
     *
     * @return A {@link List} of channels.
     */
    List<Channel> getChannels(Subscription subscription);

    /**
     * Retrieves the channel defined in the given {@link ChannelConfig}
     *
     * @param channelConfig The channel configuration for which to the the channel
     *
     * @return A channel.
     */
    Channel getChannel(ChannelConfig channelConfig);
}
