/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.day.cq.personalization;

import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;

import com.day.cq.wcm.api.Page;

public class TeaserUtils {

    /**
     * Returns a image for the teaser, based on the following logic:<ul>
     *     <li>check for page image</li>
     *     <li>check for first par image component</li>
     *     <li>check for first par textimage component</li>
     *     <li>fallback, return page template thumbnail</li>
     * </ul>
     * @param teaser Teaser page
     * @return A URL to the image.
     */
    public static String getImage(Page teaser) {
        return getImage(null, teaser);
    }

    /**
     * Returns a image for the teaser, based on the following logic:<ul>
     *     <li>check for page image</li>
     *     <li>check for first par image component</li>
     *     <li>check for first par textimage component</li>
     *     <li>fallback, return page template thumbnail</li>
     * </ul>
     * 
     * @param request SlingHttpServletRequest used for resource mapping
     * @param teaser Teaser page
     * @return A URL to the image.
     */
    public static String getImage(SlingHttpServletRequest request, Page teaser) {
        if( teaser != null ) {
            ResourceResolver resourceResolver = teaser.adaptTo(Resource.class).getResourceResolver();

            String teaserPath = (request == null) ? resourceResolver.map(teaser.getPath()) : resourceResolver.map(request, teaser.getPath());
            Resource imgRes = resourceResolver.getResource(teaserPath + "/jcr:content/image");
            if( imgRes != null) {
                ValueMap properties = imgRes.adaptTo(ValueMap.class);
                if( properties.get("fileReference", String.class) != null) {
                    //page image
                    return teaserPath + ".img.png";
                }

                imgRes = resourceResolver.getResource(imgRes.getPath() + "/file/jcr:content");
                if( imgRes != null) {
                    //page image
                    return teaserPath + ".img.png";
                }
            }

            imgRes = resourceResolver.getResource(teaser.getPath() + "/jcr:content/par/image");
            if (imgRes != null) {
                //first par image
                return (request == null)
                        ? resourceResolver.map(imgRes.getPath()) + ".img.png"
                        : resourceResolver.map(request, imgRes.getPath()) + ".img.png";
            }

            imgRes = resourceResolver.getResource(teaser.getPath() + "/jcr:content/par/textimage/image");
            if (imgRes != null) {
                //first textimage image
                return (request == null)
                        ? resourceResolver.map(imgRes.getPath()) + ".img.png"
                        : resourceResolver.map(request, imgRes.getPath()) + ".img.png";
            }

            //fallback, template image
            return teaserPath + ".thumb.png";
        }
        return null;
    }
}
