/*
 * Copyright 1997-2010 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */

package com.day.cq.reporting;

/**
 * This interface must be implemented by all classes that are used for value extraction.
 */
public interface ValueExtractor {

    /**
     * Extracts a value from the given base object according to the specified extraction
     * definition.
     *
     * @param extractDef additional information required for extraction
     *                   (implementation-specific)
     * @param baseObj The basic object to extract the value from (implementation-specific)
     * @return The extracted value
     */
    CellValue extractValue(ExtractorDef extractDef, Object baseObj);

    /**
     * Sets a parameter string if one is available.
     *
     * @param parameterStr The parameter string
     */
    void setParameter(String parameterStr);

}
