/* Copyright 1997-2006 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.retriever;

import java.io.IOException;

import javax.jcr.RepositoryException;

import org.xml.sax.Attributes;

/** Storage interface for the retriever module, allows the client of the RetrieverService
 *  to store downloaded resources in any suitable way. 
 */ 
public interface RetrieverStorage {
    
    /** Store the content that was retrieved and processed */
    void storeContent(String content) throws IOException, RepositoryException;
    
    /** Download the resource if the storage wants to do that, and if downloaded
     *  return the URI of the downloaded resource. The idea in not downloading
     *  all resources is that large images, for example, might be better left
     *  as absolute URIs in the content when sending large quantities of mail, to
     *  keep the mailing bandwidth low.
     *  
     *  @param elementName the html element that contains the URI
     *  @param attributeName the html attribute that contains the URI
     *  @param resourceUri the attribute value (absolute URL)
     *  @param attributes the rest of the element's attributes
     */  
    String maybeDownloadResource(String elementName, String attributeName, 
            String resourceUri, Attributes attributes) throws IOException, RepositoryException;
}
