/*
 * Copyright 1997-2010 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.rewriter.pipeline;

import com.day.cq.rewriter.linkchecker.Link;
import com.day.cq.rewriter.linkchecker.LinkCheckerSettings;

/**
 * The <code>RequestLinkChecker</code> interface defines an optional
 * service which is used to perform custom link checking by
 * the link checker transformer.
 * @since 5.4
 */
public interface RequestLinkChecker {

    /**
     * This method checks if the passed url is a valid internal or external link.
     * If this method is not able to check the link it may return <code>null</code>.
     * In this case the default link checker checks the link.
     * @param href url to validate
     * @param settings linkchecker settings. see {@link LinkCheckerSettings}
     * @return the link information for this url or <code>null</code>
     *
     */
    Link getLink(String href, LinkCheckerSettings settings);
}
