/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.wcm.api;

import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.commons.json.JSONObject;
import org.apache.sling.commons.json.JSONException;

/**
 * A <code>PageInfoProvider</code> is used to provide status information
 * for a resource, usually a page or an aggregate root node.
 */
public interface PageInfoProvider {

    /**
     * Updates the info.
     *
     * @param request the servlet request
     * @param info the json info
     * @param resource the resource to retrieve the info for
     * @throws JSONException if an error occurrs.
     */
    void updatePageInfo(SlingHttpServletRequest request, JSONObject info,
                     Resource resource) throws JSONException;

}