/************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2024 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 *************************************************************************
 */
package com.day.cq.wcm.api;

import java.util.function.Predicate;

import javax.jcr.Node;
import javax.jcr.RepositoryException;

import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.day.cq.commons.jcr.JcrConstants;
import com.day.cq.commons.predicates.NodePredicate;

/**
 * Predicate used to filter Template nodes.
 */

@Component(
        service = Predicate.class,
        property = {
                "service.vendor=Adobe Systems Incorporated",
                "predicate.name=page"
        })
public class PageNodePredicate implements NodePredicate {

    /**
     * default logger
     */
    private final Logger log = LoggerFactory.getLogger(PageNodePredicate.class);

    /**
     * {@inheritDoc}
     *
     * @return <code>true</code> if node is an nt:folder containing templates or cq:Template node.
     */
    @Override
    public boolean test(Node node) {
        try {
            String primaryName = node.getPrimaryNodeType().getName();

            if (primaryName.equals("cq:Page")) {
                return true;
            }
            if (primaryName.equals(JcrConstants.NT_FOLDER) || primaryName.equals("sling:Folder") || primaryName.equals("sling:OrderedFolder")) {
                return node.hasNodes();
            }
        } catch (RepositoryException e) {
            log.warn("RepositoryException in PageNodePredicate.test()", e);
        }
        return false;
    }
}
