/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.wcm.core.utils;

import com.adobe.granite.security.user.util.AuthorizableUtil;
import com.adobe.granite.xss.XSSAPI;
import com.day.cq.commons.JSONWriterUtil;
import com.day.cq.commons.predicates.servlets.AbstractListServlet;
import com.day.cq.replication.ReplicationQueue;
import com.day.cq.replication.ReplicationStatus;
import java.util.Calendar;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;

public class PageInfoUtils {

    public static JSONObject getReplicationStateObject(Resource resource, XSSAPI xssAPI) throws JSONException {
        ReplicationStatus replicationStatus = resource.adaptTo(ReplicationStatus.class);
        if (replicationStatus != null) {
            int maxQueuePos = -1;
            // Get pending information
            for (ReplicationQueue.Entry e : replicationStatus.getPending()) {
                if (e.getQueuePosition() > maxQueuePos) {
                    maxQueuePos = e.getQueuePosition();
                }
            }
            return getReplicationStateObject(resource, xssAPI, maxQueuePos);
        } else {
            return null;
        }
    }

    private static void writeKey(JSONObject object, String key, Object value) throws JSONException {
        object.put(key, value);
    }

    private static void writeOptionalKey(JSONObject object, String key, Object value) throws JSONException {
        if (value != null) {
            writeKey(object, key, value);
        }
    }

    private static void writeOptionalDateKey(JSONObject object, String key, Calendar value) throws JSONException {
        if (value != null) {
            writeKey(object, key, value.getTimeInMillis());
        }
    }

    public static JSONObject getReplicationStateObject(Resource resource, XSSAPI xssAPI, Integer maxQueuePos) throws JSONException {
        ReplicationStatus replicationStatus = resource.adaptTo(ReplicationStatus.class);
        if (replicationStatus != null) {
            JSONObject replication = new JSONObject();

            writeKey(replication, AbstractListServlet.ListItem.REPLICATION_NUM_QUEUED, maxQueuePos + 1);

            writeOptionalDateKey(replication, AbstractListServlet.ListItem.REPLICATION_PUBLISHED, replicationStatus.getLastPublished());

            String lastPublishedBy = AuthorizableUtil.getFormattedName(resource.getResourceResolver(), replicationStatus.getLastPublishedBy());
            writeKey(replication, AbstractListServlet.ListItem.REPLICATION_PUBLISHED_BY, lastPublishedBy);
            writeKey(replication, AbstractListServlet.ListItem.REPLICATION_PUBLISHED_BY + JSONWriterUtil.KEY_SUFFIX_XSS, lastPublishedBy != null ? xssAPI.filterHTML(lastPublishedBy) : null);

            if (replicationStatus.getLastReplicationAction() != null) {
                writeOptionalKey(replication, AbstractListServlet.ListItem.REPLICATION_ACTION, replicationStatus.getLastReplicationAction().name());
            }

            return replication;
        }

        return null;
    }
}
