/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.wcm.msm.api;

import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.io.JSONWriter;

import com.day.cq.commons.JSONItem;
import com.day.cq.wcm.api.WCMException;

/**
 * Represent an Action to be performed upon a Roll-out from a Source to a Target.
 * Actions are created by a {@link com.day.cq.wcm.msm.api.LiveActionFactory LiveActionFactory}
 * that provide instances of LiveActions set-up with given configuration.
 * <br>
 * LiveActions are called during the process of roll-out which on acts on Resources
 * A LiveAction must therefore act within the boundary of the given Resource
 *
 * @see LiveActionFactory
 * @see com.day.cq.wcm.msm.api.RolloutManager
 */
public interface LiveAction extends JSONItem {

    /**
      * Returns name of current action. Name is used to persist action in the repository.
      * @return action name
      */
     public String getName();

    /**
     * Executes action. Is called by the {@link com.day.cq.wcm.msm.api.RolloutManager RolloutManager}.<br>
     * Callers should assert that the method is not called on {@link com.day.cq.wcm.msm.api.LiveRelationship LiveRelationships}
     * that are inactive.
     *
     * @param source The Resource to roll-out. This may bee <code>null</code>
     * @param target The Resource to receive modification. This may bee <code>null</code>
     * @param relation LiveRelationship between the two given Resources
     * @param autoSave Save modifications
     * @param isResetRollout True if rollout is run in reset mode
     * @throws WCMException if an error occurs
     * @see RolloutManager#rollout(com.day.cq.wcm.msm.api.RolloutManager.RolloutParams) 
     */
    public void execute(Resource source, Resource target, LiveRelationship relation, boolean autoSave, boolean isResetRollout) throws WCMException;


    //------------------------------------------------< deprecated >------------
    /**
     * Executes action. Is called by the Rollout Manager.
     * @see ActionManager#executeAction(org.apache.sling.api.resource.ResourceResolver, LiveRelationship, ActionConfig, boolean)
     * @param resolver resource resolver
     * @param relation live relationship concerned by action.
     * @param config action config
     * @param autoSave Save modifications
     * @throws WCMException if an error occurs
     * @deprecated since 5.5 use {@link #execute(org.apache.sling.api.resource.Resource, org.apache.sling.api.resource.Resource, LiveRelationship, boolean, boolean)}
     *             instead.
     */
    @Deprecated
    public void execute(ResourceResolver resolver, LiveRelationship relation, ActionConfig config, boolean autoSave) throws WCMException;

    /**
     * Executes action. Is called by the Rollout Manager.
     * @see ActionManager#executeAction(org.apache.sling.api.resource.ResourceResolver, LiveRelationship, ActionConfig, boolean, boolean)
     * @param resolver resource resolver
     * @param relation live relationship concerned by action.
     * @param config action config
     * @param autoSave Save modifications
     * @param isResetRollout True if rollout is run in reset mode
     * @throws WCMException if an error occurs
     * @deprecated since 5.5 use {@link #execute(org.apache.sling.api.resource.Resource, org.apache.sling.api.resource.Resource, LiveRelationship, boolean, boolean)}
     *             instead.
     */
    @Deprecated
    public void execute(ResourceResolver resolver, LiveRelationship relation, ActionConfig config, boolean autoSave, boolean isResetRollout) throws WCMException;

     /**
      * Returns the title of current action. Title is used to be displayed to end-user.
      * @return action name
      * @deprecated since 5.5
      */
     @Deprecated
     public String getTitle();

    /**
     * Returns execution rank of the action: actions are executed by ascending ranks
     * @return action rank
     * @deprecated since 5.5 the Rank is defined by the order in the
     * {@link com.day.cq.wcm.msm.api.RolloutConfig RolloutConfig}
     */
    @Deprecated
    public int getRank();

    /**
     * Returns names of the properties defined for this action.
     * @return array of parameters names
     * @deprecated since 5.5
     */
    @Deprecated
    public String[] getPropertiesNames();

    /**
     * Returns the global parameter name of current action. Parameter name is used in requests.
     * @return action parameter name
     * @deprecated since 5.5
     */
    @Deprecated
    public String getParameterName();

    /**
     * @deprecated since 5.5
     */
    @Deprecated
    void write(JSONWriter out) throws JSONException;
}
