/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2025 Adobe Inc.
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.day.cq.wcm.workflow.process;

import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;

import com.day.cq.replication.ReplicationActionType;
import com.day.cq.workflow.WorkflowException;
import com.day.cq.workflow.WorkflowSession;
import com.day.cq.workflow.exec.WorkItem;
import com.day.cq.workflow.exec.WorkflowData;
import com.day.cq.workflow.exec.WorkflowProcess;
import com.day.cq.workflow.metadata.MetaDataMap;

@Component
@Service(WorkflowProcess.class)
@Property(name = "process.label", value = "Deactivate Page from both Publish and Preview")
public class UnpublishPageProcess extends ReplicatePageProcess{

    @Override
    public void execute(WorkItem workItem, WorkflowSession workflowSession, MetaDataMap args) throws WorkflowException {
        unpublishFromPublishAndPreviewTiers(workItem, workflowSession, args);
    }

    private void unpublishFromPublishAndPreviewTiers(WorkItem workItem, WorkflowSession workflowSession, MetaDataMap args) throws WorkflowException {
        // first unpublish from publish tier
        super.execute(workItem, workflowSession, args);

        // set agentId to preview in order to unpublish from preview tier
        WorkflowData workflowData = workItem.getWorkflowData();
        var metadata = workflowData.getMetaDataMap();
        metadata.put("agentId", "preview");
        super.execute(workItem, workflowSession, metadata);
    }

    @Override
    public ReplicationActionType getReplicationType() {
        return ReplicationActionType.DEACTIVATE;
    }
}
