/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.workflow.collection;

import javax.jcr.Session;
import javax.jcr.Node;
import java.util.List;

/**
 * The <code>ResourceCollectionManager</code> can read, list all available
 * resource collections respectovely manage the resource collections...
 */
public interface ResourceCollectionManager {
    /**
     * Creates a {@link com.day.cq.workflow.collection.ResourceCollection} object
     * from the given node if possible.
     *
     * @param node node to create {@link com.day.cq.workflow.collection.ResourceCollection} object
     * @return {@link com.day.cq.workflow.collection.ResourceCollection} or <code>
     * null</code> if the node can not be turned into such an object.
     */
    ResourceCollection createCollection(Node node);

    /**
     * Lists all available {@link com.day.cq.workflow.collection.ResourceCollection}s
     * which are accessible be the given {@link Session}
     *
     * @param session user session
     * @return all available {@link com.day.cq.workflow.collection.ResourceCollection}s
     */
    List<ResourceCollection> getCollections(Session session);
}
