package com.day.cq.workflow.statistics;

import java.util.Map;

import javax.jcr.Session;

import org.osgi.annotation.versioning.ProviderType;

import com.day.cq.workflow.model.WorkflowModel;

/**
 * The <code>WorkflowStatisticService</code> class ...
 */
@ProviderType
public interface WorkflowStatisticService {
    /**
     * No longer supported, now throws {@link UnsupportedOperationException}.  Use {@link #getReport(Session)} instead.
     */
    Map getReport();

    /**
     * No longer support, now throws {@link UnsupportedOperationException}.  Use {@link #getInstanceReport(Session, WorkflowModel)} instead.
     */
    Map getInstanceReport(WorkflowModel model);

    /**
     * Returns the overall workflow report.
     * @param session The user session used to read the statistics.
     * @return The map of data that makes up the report.
     */
    Map getReport(Session session);

    /**
     * Returns the workflow instance report.
     * @param session The user session used to read the statistics.
     * @param model The workflow model to get the instance report for.
     * @return The map of data that makes up the report.
     */
    Map getInstanceReport(Session session, WorkflowModel model);
}