/*************************************************************************
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 1997 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 **************************************************************************/
package com.day.crx;

import javax.jcr.AccessDeniedException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.RepositoryException;

import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.XASession;

import com.day.crx.io.CRXExportHandler;
import com.day.crx.io.CRXImportHandler;

/**
 * This Interface extends the default jcr session by some crx specific methods.
 *
 */
public interface CRXSession extends JackrabbitSession, XASession {

    /**
     * Returns the export handler
     * @return the export handler
     * @throws RepositoryException
     */
    CRXExportHandler getExportHandler() throws RepositoryException;

    /**
     * Returns the import handler
     * @return the import handler
     * @throws RepositoryException
     */
    CRXImportHandler getImportHandler() throws RepositoryException;

    /**
     * Creates a new session with the same subject as this sessions but to a
     * different workspace. The returned session is a newly logged in session,
     * with the same subject but a different workspace. Even if the given
     * workspace is the same as this sessions one, the implementation must
     * return a new session object.
     *
     * @param workspaceName name of the workspace to acquire a session for.
     * @return A session to the requested workspace for the same authenticated
     *         subject.
     * @throws AccessDeniedException in case the current Subject is not allowed
     *         to access the requested Workspace
     * @throws NoSuchWorkspaceException If the named workspace does not exist.
     * @throws RepositoryException in any other exceptional state
     */
    CRXSession getSession(String workspaceName)
            throws AccessDeniedException, NoSuchWorkspaceException,
            RepositoryException;
}
