/*************************************************************************
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 1997 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 **************************************************************************/
package com.day.crx;

/**
 * Marker interface for a <code>Repository</code> to indicate it allows
 * observation of its life cycle events.
 */
public interface ObservableRepository {

    /**
     * Register a listener interested in lifecycle events..
     *
     * @param listener listener to register.
     */
    void addListener(RepositoryLifecycleListener listener);

    /**
     * Unregister a listener that was previously registered.
     *
     * @param listener listener to unregister.
     */
    void removeListener(RepositoryLifecycleListener listener);

}
