/*************************************************************************
*
* ADOBE CONFIDENTIAL
* ___________________
*
*  Copyright 1997 Adobe Systems Incorporated
*  All Rights Reserved.
*
* NOTICE:  All information contained herein is, and remains
* the property of Adobe Systems Incorporated and its suppliers,
* if any.  The intellectual and technical concepts contained
* herein are proprietary to Adobe Systems Incorporated and its
* suppliers and are protected by trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from Adobe Systems Incorporated.
**************************************************************************/
package com.day.crx.statistics.keyword;

import com.day.crx.statistics.Report;

import javax.jcr.Session;
import javax.jcr.RepositoryException;
import javax.jcr.NodeIterator;
import javax.jcr.Node;
import javax.jcr.Value;
import javax.jcr.query.QueryManager;
import javax.jcr.query.Query;
import java.util.Iterator;
import java.util.List;
import java.util.ArrayList;

import org.apache.jackrabbit.util.Text;

/**
 * <code>KeywordsReport</code> implements a report that returns the paths of
 * all nodes with a given keyword property.
 *
 * @author mreutegg
 */
public class KeywordsReport extends Report {

    /**
     * The relative path to the keyword property.
     */
    private final String keywordRelPath;

    /**
     * Creates a new report.
     *
     * @param dataPath       the path where the content is stored. E.g.
     *                       '/content' or '' (empty String) if the complete
     *                       workspace should be considered.
     * @param keywordRelPath the relative path of the keyword property.
     */
    public KeywordsReport(String dataPath, String keywordRelPath) {
        super(dataPath);
        this.keywordRelPath = keywordRelPath;
    }

    /**
     * {@inheritDoc}
     * <p/>
     * Returns result rows with the following objects:
     * <ul>
     * <li>Path <code>String</code> of a page.</li>
     * <li>Keywords as <code>String[]</code>.</li>
     * </ul>
     */
    public Iterator getResult(Session session) throws RepositoryException {
        QueryManager qm = session.getWorkspace().getQueryManager();
        StringBuffer stmt = new StringBuffer("/jcr:root");
        stmt.append(getDataPath());
        stmt.append("//*[");
        String[] parts = Text.explode(keywordRelPath, '/');
        String separator = "";
        for (int i = 0; i < parts.length; i++) {
            stmt.append(separator);
            if (i == parts.length - 1) {
                stmt.append("@");
            }
            stmt.append(parts[i]);
            separator = "/";
        }
        stmt.append("]");
        NodeIterator nodes = qm.createQuery(stmt.toString(),
                Query.XPATH).execute().getNodes();
        List paths = new ArrayList();
        while (nodes.hasNext()) {
            Node n = nodes.nextNode();
            Value[] values;
            if (n.hasProperty(keywordRelPath)) {
                values = n.getProperty(keywordRelPath).getValues();
            } else {
                values = new Value[0];
            }
            String[] keywords = new String[values.length];
            for (int i = 0; i < values.length; i++) {
                keywords[i] = values[i].getString();
            }
            paths.add(new Object[]{n.getPath(), keywords});
        }
        return paths.iterator();
    }
}
