/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.jackrabbit.oak.plugins.memory;

import static java.util.Objects.requireNonNull;
import java.util.Map.Entry;
import org.apache.jackrabbit.oak.commons.collections.IterableUtils;
import org.apache.jackrabbit.oak.spi.state.AbstractChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.ChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.NodeState;

/**
 *  Basic JavaBean implementation of a child node entry.
 *
 * @deprecated The Jackrabbit Oak Memory library is designed for Oak-internal use only and thus deprecated. It will not be part of the AEM SDK after October 2025.
 */
@Deprecated(since = "2025-04-15")
public class MemoryChildNodeEntry extends AbstractChildNodeEntry {

    public static <E extends Entry<String, ? extends NodeState>> Iterable<ChildNodeEntry> iterable(Iterable<E> set) {
        return IterableUtils.transform(set, entry -> new MemoryChildNodeEntry(entry.getKey(), entry.getValue()));
    }

    private final String name;

    private final NodeState node;

    /**
     * Creates a child node entry with the given name and referenced
     * child node state.
     *
     * @param name child node name
     * @param node child node state
     */
    public MemoryChildNodeEntry(String name, NodeState node) {
        this.name = requireNonNull(name);
        this.node = requireNonNull(node);
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public NodeState getNodeState() {
        return node;
    }
}
