/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.core.cos;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosDocument;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.cos.RepairContainer;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

class CosRepairList {
    private HashMap<Integer, RepairContainer> repairList = new HashMap();
    private CosDocument document;

    public CosRepairList(CosDocument document) {
        this.document = document;
    }

    void setRepairedValue(CosDictionary obj, ASName key, CosObject value) {
        Integer objectNum = obj.getObjNum();
        RepairContainer container = this.repairList.get(objectNum);
        if (container == null) {
            container = new RepairContainer(null);
            this.repairList.put(objectNum, container);
        }
        container.put(key, value);
    }

    void setRepairedValue(Integer objNum, CosObject obj) {
        if (obj == null) {
            return;
        }
        RepairContainer container = this.repairList.get(objNum);
        if (container == null) {
            container = new RepairContainer(obj);
            this.repairList.put(objNum, container);
            obj.setRepaired(true);
        }
    }

    boolean isObjectRepaired(Integer objectNum) {
        return this.repairList.containsKey(objectNum);
    }

    CosObject getRepairedValue(Integer objectNum, ASName key) {
        if (!this.document.getUseRepairList()) {
            return null;
        }
        RepairContainer container = this.repairList.get(objectNum);
        if (container == null) {
            return null;
        }
        return container.get(key);
    }

    CosObject getRepairedValue(Integer objectNum) {
        if (!this.document.getUseRepairList()) {
            return null;
        }
        RepairContainer container = this.repairList.get(objectNum);
        if (container == null) {
            return null;
        }
        return container.getRepairedObject();
    }

    void clear() {
        this.repairList.clear();
    }

    void updateObjectNumbers(HashMap<Integer, Integer> objectNumMap) {
        Iterator<Map.Entry<Integer, Integer>> iter = objectNumMap.entrySet().iterator();
        HashMap<Integer, RepairContainer> tempRepairList = new HashMap<Integer, RepairContainer>();
        while (iter.hasNext()) {
            Map.Entry<Integer, Integer> entry = iter.next();
            Integer oldNum = entry.getKey();
            Integer newNum = entry.getValue();
            tempRepairList.put(newNum, this.repairList.get(oldNum));
        }
        this.repairList.clear();
        this.repairList = tempRepairList;
    }
}

