/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.text;

import com.adobe.xfa.text.IteratorData;
import com.adobe.xfa.text.TextBreakIterator;
import com.adobe.xfa.text.TextCharProp;
import com.adobe.xfa.text.TextCharPropIterator;

class GraphemeBreakIterator
extends TextBreakIterator {
    private final TextCharPropIterator mpoTextCharPropIterator;
    private final IteratorData moData = new IteratorData();
    private int mePrevData;
    static final boolean[][] gbGraphemeBreak = new boolean[][]{{true, true, true, false, true, true, true, true, true, true}, {true, true, true, false, true, false, true, true, true, true}, {true, true, true, false, true, true, true, true, true, true}, {true, true, true, false, true, true, true, true, true, true}, {true, true, true, false, false, true, false, false, true, false}, {true, true, true, false, true, true, true, true, true, true}, {true, true, true, false, true, true, true, true, false, false}, {true, true, true, false, true, true, true, true, false, true}, {true, true, true, false, true, true, true, true, false, true}, {true, true, true, false, true, true, true, true, false, false}};

    public GraphemeBreakIterator(TextCharPropIterator poTextCharPropIterator) {
        this.mpoTextCharPropIterator = poTextCharPropIterator;
        this.doFirst();
    }

    public int getPrevData() {
        return this.mePrevData;
    }

    public int advanceGrapheme() {
        int nTestIndex;
        int nNextIndex;
        int nPrevIndex;
        if (this.moData.mbEnd) {
            return Integer.MAX_VALUE;
        }
        this.mePrevData = this.moData.mePrevData;
        do {
            nTestIndex = this.moData.mnCharIndex;
            int eNextData = this.moData.next(this.mpoTextCharPropIterator);
            if (this.moData.mbEnd) {
                return nTestIndex;
            }
            nPrevIndex = TextCharProp.graphemeToIndex(this.moData.mePrevData);
            nNextIndex = TextCharProp.graphemeToIndex(eNextData);
            this.moData.mePrevData = eNextData;
        } while (!gbGraphemeBreak[nPrevIndex][nNextIndex]);
        return nTestIndex;
    }

    @Override
    public int first() {
        return this.doFirst();
    }

    @Override
    public int next() {
        return this.advanceGrapheme();
    }

    private int doFirst() {
        int nIndex;
        this.moData.mnCharIndex = nIndex = this.mpoTextCharPropIterator.first();
        this.moData.mePrevData = this.moData.next(this.mpoTextCharPropIterator);
        return nIndex;
    }
}

