/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.ut;

import com.adobe.xfa.ut.LcData;
import com.adobe.xfa.ut.StringUtils;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public final class LcLocale {
    public static final String Arabic = "ar";
    public static final String Arabic_UAE = "ar_AE";
    public static final String Arabic_Bahrain = "ar_BH";
    public static final String Arabic_Algeria = "ar_DZ";
    public static final String Arabic_Egypt = "ar_EG";
    public static final String Arabic_Iraq = "ar_IQ";
    public static final String Arabic_Jordan = "ar_JO";
    public static final String Arabic_Kuwait = "ar_KW";
    public static final String Arabic_Lebanon = "ar_LB";
    public static final String Arabic_Libya = "ar_LY";
    public static final String Arabic_Morocco = "ar_MA";
    public static final String Arabic_Oman = "ar_OM";
    public static final String Arabic_Qatar = "ar_QA";
    public static final String Arabic_SaudiArabia = "ar_SA";
    public static final String Arabic_Sudan = "ar_SD";
    public static final String Arabic_Syria = "ar_SY";
    public static final String Arabic_Tunisia = "ar_TN";
    public static final String Arabic_Yemen = "ar_YE";
    public static final String Azerbaijani = "az";
    public static final String Azerbaijani_Azerbaijan = "az_AZ";
    public static final String Azerbaijani_Cyrillic = "az_Cyrl";
    public static final String Azerbaijani_Cyrillic_Azerbaijan = "az_Cyrl_AZ";
    public static final String Azerbaijani_Latin = "az_Latn";
    public static final String Azerbaijani_Latin_Azerbaijan = "az_Latn_AZ";
    public static final String Byelorussian = "be";
    public static final String Byelorussian_Belarus = "be_BY";
    public static final String Bulgarian = "bg";
    public static final String Bulgarian_Bulgaria = "bg_BG";
    public static final String Bosnian = "bs";
    public static final String Bosnian_BosniaHerzegovina = "bs_BA";
    public static final String C = "c";
    public static final String Catalan = "ca";
    public static final String Catalan_Spain = "ca_ES";
    public static final String Czech = "cs";
    public static final String Czech_CzechRepublic = "cs_CZ";
    public static final String Danish = "da";
    public static final String Danish_Denmark = "da_DK";
    public static final String German = "de";
    public static final String German_Austria = "de_AT";
    public static final String German_Belgium = "de_BE";
    public static final String German_Switzerland = "de_CH";
    public static final String German_Germany = "de_DE";
    public static final String German_Liechtenstein = "de_LI";
    public static final String German_Luxembourg = "de_LU";
    public static final String Greek = "el";
    public static final String Greek_Greece = "el_GR";
    public static final String English = "en";
    public static final String English_Australia = "en_AU";
    public static final String English_Belgium = "en_BE";
    public static final String English_Canada = "en_CA";
    public static final String English_UK = "en_GB";
    public static final String English_UK_Euro = "en_GB_EURO";
    public static final String English_HongKong = "en_HK";
    public static final String English_Ireland = "en_IE";
    public static final String English_India = "en_IN";
    public static final String English_NewZealand = "en_NZ";
    public static final String English_Philippines = "en_PH";
    public static final String English_Singapore = "en_SG";
    public static final String English_US = "en_US";
    public static final String English_US_Posix = "en_US_POSIX";
    public static final String English_VirginIslands = "en_VI";
    public static final String English_SouthAfrica = "en_ZA";
    public static final String Spanish = "es";
    public static final String Spanish_Argentina = "es_AR";
    public static final String Spanish_Bolivia = "es_BO";
    public static final String Spanish_Chile = "es_CL";
    public static final String Spanish_Colombia = "es_CO";
    public static final String Spanish_CostaRica = "es_CR";
    public static final String Spanish_DominicanRepublic = "es_DO";
    public static final String Spanish_Ecuador = "es_EC";
    public static final String Spanish_Spain = "es_ES";
    public static final String Spanish_Guatemala = "es_GT";
    public static final String Spanish_Honduras = "es_HN";
    public static final String Spanish_Mexico = "es_MX";
    public static final String Spanish_Nicaragua = "es_NI";
    public static final String Spanish_Panama = "es_PA";
    public static final String Spanish_Peru = "es_PE";
    public static final String Spanish_PuertoRico = "es_PR";
    public static final String Spanish_Paraguay = "es_PY";
    public static final String Spanish_ElSalvador = "es_SV";
    public static final String Spanish_US = "es_US";
    public static final String Spanish_Uruguay = "es_UY";
    public static final String Spanish_Venezuela = "es_VE";
    public static final String Estonian = "et";
    public static final String Estonian_Estonia = "et_EE";
    public static final String Basque = "eu";
    public static final String Basque_Spain = "eu_ES";
    public static final String Persian = "fa";
    public static final String Persian_Iran = "fa_IR";
    public static final String Finnish = "fi";
    public static final String Finnish_Finland = "fi_FI";
    public static final String French = "fr";
    public static final String French_Belgium = "fr_BE";
    public static final String French_Canada = "fr_CA";
    public static final String French_Switzerland = "fr_CH";
    public static final String French_France = "fr_FR";
    public static final String French_Luxembourg = "fr_LU";
    public static final String Hebrew = "he";
    public static final String Hebrew_Israel = "he_IL";
    public static final String Hindi = "hi";
    public static final String Hindi_India = "hi_IN";
    public static final String Croatian = "hr";
    public static final String Croatian_Croatia = "hr_HR";
    public static final String Hungarian = "hu";
    public static final String Hungarian_Hungary = "hu_HU";
    public static final String Armenian = "hy";
    public static final String Armenian_Armenia = "hy_AM";
    public static final String Indonesian = "id";
    public static final String Indonesian_Indonesia = "id_ID";
    public static final String Icelandic = "is";
    public static final String Icelandic_Iceland = "is_IS";
    public static final String Italian = "it";
    public static final String Italian_Switzerland = "it_CH";
    public static final String Italian_Italy = "it_IT";
    public static final String Japanese = "ja";
    public static final String Japanese_Japan = "ja_JP";
    public static final String Kazakh = "kk";
    public static final String Kazakh_Kazakhstan = "kk_KZ";
    public static final String Khmer = "km";
    public static final String Khmer_Cambodia = "km_KH";
    public static final String Korean = "ko";
    public static final String Korean_Korea = "ko_KR";
    public static final String Korean_Korea_Hani = "ko_KR_HANI";
    public static final String Lao = "lo";
    public static final String Lao_Laos = "lo_LA";
    public static final String Lithuanian = "lt";
    public static final String Lithuanian_Lithuania = "lt_LT";
    public static final String Latvian = "lv";
    public static final String Latvian_Latvia = "lv_LV";
    public static final String Macedonian = "mk";
    public static final String Macedonian_Macedonia = "mk_MK";
    public static final String Malay = "ms";
    public static final String Malay_Malaysia = "ms_MY";
    public static final String Norwegian_Bokmal = "nb";
    public static final String Norwegian_Bokmal_Norway = "nb_NO";
    public static final String Dutch = "nl";
    public static final String Dutch_Belgium = "nl_BE";
    public static final String Dutch_Netherlands = "nl_NL";
    public static final String Norwegian_Nynorsk = "nn";
    public static final String Norwegian_Nynorsk_Norway = "nn_NO";
    public static final String Polish = "pl";
    public static final String Polish_Poland = "pl_PL";
    public static final String Portuguese = "pt";
    public static final String Portuguese_Brazil = "pt_BR";
    public static final String Portuguese_Portugal = "pt_PT";
    public static final String Romanian = "ro";
    public static final String Romanian_Moldova = "ro_MD";
    public static final String Romanian_Romania = "ro_RO";
    public static final String Russian = "ru";
    public static final String Russian_Moldova = "ru_MD";
    public static final String Russian_Russia = "ru_RU";
    public static final String Russian_Ukraine = "ru_UA";
    public static final String Serbo_Croatian = "sh";
    public static final String Serbo_Croatian_BosniaHerzegovina = "sh_BA";
    public static final String Serbo_Croatian_SerbiaMontenegro = "sh_CS";
    public static final String Serbo_Croatian_Croatia = "sh_HR";
    public static final String Slovak = "sk";
    public static final String Slovak_Slovakia = "sk_SK";
    public static final String Slovenian = "sl";
    public static final String Slovenian_Slovenia = "sl_SI";
    public static final String Albanian = "sq";
    public static final String Albanian_Albania = "sq_AL";
    public static final String Serbian = "sr";
    public static final String Serbian_Yugoslavia = "sr_CS";
    public static final String Serbian_Cyrillic = "sr_Cyrl";
    public static final String Serbian_Cyrillic_SerbiaMontenegro = "sr_Cyrl_CS";
    public static final String Serbian_Latin = "sr_Latn";
    public static final String Serbian_Latin_SerbiaMontenegro = "sr_Latn_CS";
    public static final String Swedish = "sv";
    public static final String Swedish_Finland = "sv_FI";
    public static final String Swedish_Sweden = "sv_SE";
    public static final String Thai = "th";
    public static final String Thai_Thailand = "th_TH";
    public static final String Thai_Thailand_Traditional = "th_TH_TH";
    public static final String Tagalog = "tl";
    public static final String Tagalog_Philippines = "tl_PH";
    public static final String Turkish = "tr";
    public static final String Turkish_Turkey = "tr_TR";
    public static final String Ukrainian = "uk";
    public static final String Ukrainian_Ukraine = "uk_UA";
    public static final String Vietnamese = "vi";
    public static final String Vietnamese_Vietnam = "vi_VN";
    public static final String Chinese = "zh";
    public static final String Chinese_China = "zh_CN";
    public static final String Chinese_HongKong = "zh_HK";
    public static final String Chinese_Simplified = "zh_Hans";
    public static final String Chinese_Traditional = "zh_Hant";
    public static final String Chinese_Singapore = "zh_SG";
    public static final String Chinese_Taiwan = "zh_TW";
    public static final String DEFAULT_LOCALE = "en_US";
    private static final int MASK_ARABIC = 1;
    private static final int MASK_BIDI = 2;
    private static final int MASK_CHINESE = 4;
    private static final int MASK_CHINESE_SIMPLIFIED = 8;
    private static final int MASK_CHINESE_TRADITIONAL = 16;
    private static final int MASK_DICTIONARY = 32;
    private static final int MASK_IDEOGRAPHIC = 64;
    private static final int MASK_JAPANESE = 128;
    private static final int MASK_KOREAN = 256;
    private static final int MASK_KOREAN_HANI = 512;
    private static final int MASK_THAI = 1024;
    private final LocaleDesc mLocaleDesc;
    private static final LocaleDesc mInvalidLocale = new LocaleDesc("x", "XXX", "ibm367", 0);
    private static final ThreadLocal<Map<String, LocaleDesc>> mRuntimeMap = new ThreadLocal<Map<String, LocaleDesc>>(){

        @Override
        protected Map<String, LocaleDesc> initialValue() {
            return new HashMap<String, LocaleDesc>();
        }
    };
    private static final Map<String, LocaleDesc> mStaticMap = new HashMap<String, LocaleDesc>(188){
        private static final long serialVersionUID = 1L;
        {
            this.add(new LocaleDesc(LcLocale.Arabic, "Arabic", "iso88596", 3));
            this.add(new LocaleDesc(LcLocale.Arabic_UAE, "Arabic (U.A.E.)", "iso88596", 3));
            this.add(new LocaleDesc(LcLocale.Arabic_Bahrain, "Arabic (Bahrain)", "iso88596", 3));
            this.add(new LocaleDesc(LcLocale.Arabic_Algeria, "Arabic (Algeria)", "iso88596", 3));
            this.add(new LocaleDesc(LcLocale.Arabic_Egypt, "Arabic (Egypt)", "iso88596", 3));
            this.add(new LocaleDesc(LcLocale.Arabic_Iraq, "Arabic (Iraq)", "iso88596", 3));
            this.add(new LocaleDesc(LcLocale.Arabic_Jordan, "Arabic (Jordan)", "iso88596", 3));
            this.add(new LocaleDesc(LcLocale.Arabic_Kuwait, "Arabic (Kuwait)", "iso88596", 3));
            this.add(new LocaleDesc(LcLocale.Arabic_Lebanon, "Arabic (Lebanon)", "iso88596", 3));
            this.add(new LocaleDesc(LcLocale.Arabic_Libya, "Arabic (Libya)", "iso88596", 3));
            this.add(new LocaleDesc(LcLocale.Arabic_Morocco, "Arabic (Morocco)", "iso88596", 3));
            this.add(new LocaleDesc(LcLocale.Arabic_Oman, "Arabic (Oman)", "iso88596", 3));
            this.add(new LocaleDesc(LcLocale.Arabic_Qatar, "Arabic (Qatar)", "iso88596", 3));
            this.add(new LocaleDesc(LcLocale.Arabic_SaudiArabia, "Arabic (SaudiArabia)", "iso88596", 3));
            this.add(new LocaleDesc(LcLocale.Arabic_Sudan, "Arabic (Sudan)", "iso88596", 3));
            this.add(new LocaleDesc(LcLocale.Arabic_Syria, "Arabic (Syria)", "iso88596", 3));
            this.add(new LocaleDesc(LcLocale.Arabic_Tunisia, "Arabic (Tunisia)", "iso88596", 3));
            this.add(new LocaleDesc(LcLocale.Arabic_Yemen, "Arabic (Yemen)", "iso88596", 3));
            this.add(new LocaleDesc(LcLocale.Azerbaijani_Cyrillic, "Azerbaijani_Cyrillic", "iso88595", 0));
            this.add(new LocaleDesc(LcLocale.Azerbaijani_Cyrillic_Azerbaijan, "Azerbaijani_Cyrillic (Azerbaijan)", "iso88595", 0));
            this.add(new LocaleDesc(LcLocale.Azerbaijani_Latin, "Azerbaijani_Latin", "iso88592", 0));
            this.add(new LocaleDesc(LcLocale.Azerbaijani_Latin_Azerbaijan, "Azerbaijani_Latin (Azerbaijan)", "iso88592", 0));
            this.add(new LocaleDesc(LcLocale.Byelorussian, "Belarusian", "iso88595", 0));
            this.add(new LocaleDesc(LcLocale.Byelorussian_Belarus, "Belarusian (Belarus)", "iso88595", 0));
            this.add(new LocaleDesc(LcLocale.Bulgarian, "Bulgarian", "iso88595", 0));
            this.add(new LocaleDesc(LcLocale.Bulgarian_Bulgaria, "Bulgarian (Bulgaria)", "iso88595", 0));
            this.add(new LocaleDesc(LcLocale.Bosnian, "Bosnian", "iso88592", 0));
            this.add(new LocaleDesc(LcLocale.Bosnian_BosniaHerzegovina, "Bosnian (Bosnia And Herzegovina)", "iso88592", 0));
            this.add(new LocaleDesc(LcLocale.C, "C", "ibm367", 0));
            this.add(new LocaleDesc(LcLocale.Catalan, "Catalan", "iso885915", 0));
            this.add(new LocaleDesc(LcLocale.Catalan_Spain, "Catalan (Spain)", "iso885915", 0));
            this.add(new LocaleDesc(LcLocale.Czech, "Czech", "iso88592", 0));
            this.add(new LocaleDesc(LcLocale.Czech_CzechRepublic, "Czech (Czech Republic)", "iso88592", 0));
            this.add(new LocaleDesc(LcLocale.Danish, "Danish", "iso88591", 0));
            this.add(new LocaleDesc(LcLocale.Danish_Denmark, "Danish (Denmark)", "iso88591", 0));
            this.add(new LocaleDesc(LcLocale.German, "German", "iso88591", 0));
            this.add(new LocaleDesc(LcLocale.German_Austria, "German (Austria)", "iso88591", 0));
            this.add(new LocaleDesc(LcLocale.German_Belgium, "German (Belgium)", "iso88591", 0));
            this.add(new LocaleDesc(LcLocale.German_Switzerland, "German (Switzerland)", "iso88591", 0));
            this.add(new LocaleDesc(LcLocale.German_Germany, "German (Germany)", "iso88591", 0));
            this.add(new LocaleDesc(LcLocale.German_Liechtenstein, "German (Liechtenstein)", "iso88591", 0));
            this.add(new LocaleDesc(LcLocale.German_Luxembourg, "German (Luxembourg)", "iso88591", 0));
            this.add(new LocaleDesc(LcLocale.Greek, "Greek", "iso88597", 0));
            this.add(new LocaleDesc(LcLocale.Greek_Greece, "Greek (Greece)", "iso88597", 0));
            this.add(new LocaleDesc(LcLocale.English, "English", "iso88591", 0));
            this.add(new LocaleDesc(LcLocale.English_Australia, "English (Australia)", "iso88591", 0));
            this.add(new LocaleDesc(LcLocale.English_Belgium, "English (Belgium)", "iso88591", 0));
            this.add(new LocaleDesc(LcLocale.English_Canada, "English (Canada)", "iso88591", 0));
            this.add(new LocaleDesc(LcLocale.English_UK, "English (United Kingdom)", "iso88591", 0));
            this.add(new LocaleDesc(LcLocale.English_UK_Euro, "English (United Kingdom Euro)", "iso88591", 0));
            this.add(new LocaleDesc(LcLocale.English_HongKong, "English (HongKong)", "iso88591", 0));
            this.add(new LocaleDesc(LcLocale.English_Ireland, "English (Ireland)", "iso88591", 0));
            this.add(new LocaleDesc(LcLocale.English_India, "English (India)", "iso88591", 0));
            this.add(new LocaleDesc(LcLocale.English_NewZealand, "English (NewZealand)", "iso88591", 0));
            this.add(new LocaleDesc(LcLocale.English_Philippines, "English (Philippines)", "iso88591", 0));
            this.add(new LocaleDesc(LcLocale.English_Singapore, "English (Singapore)", "iso88591", 0));
            this.add(new LocaleDesc("en_US", "English (United States)", "iso88591", 0));
            this.add(new LocaleDesc(LcLocale.English_VirginIslands, "English (U.S. Virgin Islands)", "iso88591", 0));
            this.add(new LocaleDesc(LcLocale.English_SouthAfrica, "English (South Africa)", "iso88591", 0));
            this.add(new LocaleDesc(LcLocale.Spanish, "Spanish (Spain)", "iso88591", 0));
            this.add(new LocaleDesc(LcLocale.Spanish_Argentina, "Spanish (Argentina)", "iso88591", 0));
            this.add(new LocaleDesc(LcLocale.Spanish_Bolivia, "Spanish (Bolivia)", "iso88591", 0));
            this.add(new LocaleDesc(LcLocale.Spanish_Chile, "Spanish (Chile)", "iso88591", 0));
            this.add(new LocaleDesc(LcLocale.Spanish_Colombia, "Spanish (Colombia)", "iso88591", 0));
            this.add(new LocaleDesc(LcLocale.Spanish_CostaRica, "Spanish (Costa Rica)", "iso88591", 0));
            this.add(new LocaleDesc(LcLocale.Spanish_DominicanRepublic, "Spanish (Dominican Republic)", "iso88591", 0));
            this.add(new LocaleDesc(LcLocale.Spanish_Ecuador, "Spanish (Ecuador)", "iso88591", 0));
            this.add(new LocaleDesc(LcLocale.Spanish_Spain, "Spanish (Spain)", "iso88591", 0));
            this.add(new LocaleDesc(LcLocale.Spanish_Guatemala, "Spanish (Guatemala)", "iso88591", 0));
            this.add(new LocaleDesc(LcLocale.Spanish_Honduras, "Spanish (Honduras)", "iso88591", 0));
            this.add(new LocaleDesc(LcLocale.Spanish_Mexico, "Spanish (Mexico)", "iso88591", 0));
            this.add(new LocaleDesc(LcLocale.Spanish_Nicaragua, "Spanish (Nicaragua)", "iso88591", 0));
            this.add(new LocaleDesc(LcLocale.Spanish_Panama, "Spanish (Panama)", "iso88591", 0));
            this.add(new LocaleDesc(LcLocale.Spanish_Peru, "Spanish (Peru)", "iso88591", 0));
            this.add(new LocaleDesc(LcLocale.Spanish_PuertoRico, "Spanish (Puerto Rico)", "iso88591", 0));
            this.add(new LocaleDesc(LcLocale.Spanish_Paraguay, "Spanish (Paraguay)", "iso88591", 0));
            this.add(new LocaleDesc(LcLocale.Spanish_ElSalvador, "Spanish (El Salvador)", "iso88591", 0));
            this.add(new LocaleDesc(LcLocale.Spanish_US, "Spanish (United States)", "iso88591", 0));
            this.add(new LocaleDesc(LcLocale.Spanish_Uruguay, "Spanish (Uruguay)", "iso88591", 0));
            this.add(new LocaleDesc(LcLocale.Spanish_Venezuela, "Spanish (Venezuela)", "iso88591", 0));
            this.add(new LocaleDesc(LcLocale.Estonian, "Estonian", "utf8", 0));
            this.add(new LocaleDesc(LcLocale.Estonian_Estonia, "Estonian (Estonia)", "utf8", 0));
            this.add(new LocaleDesc(LcLocale.Basque, "Basque", "iso88591", 0));
            this.add(new LocaleDesc(LcLocale.Basque_Spain, "Basque (Spain)", "iso88591", 0));
            this.add(new LocaleDesc(LcLocale.Persian, "Persian", "iso88591", 3));
            this.add(new LocaleDesc(LcLocale.Persian_Iran, "Persian (Iran)", "iso88591", 3));
            this.add(new LocaleDesc(LcLocale.Finnish, "Finnish", "iso88591", 0));
            this.add(new LocaleDesc(LcLocale.Finnish_Finland, "Finnish (Finland)", "iso88591", 0));
            this.add(new LocaleDesc(LcLocale.French, "French", "iso88591", 0));
            this.add(new LocaleDesc(LcLocale.French_Belgium, "French (Belgium)", "iso88591", 0));
            this.add(new LocaleDesc(LcLocale.French_Canada, "French (Canada)", "iso88591", 0));
            this.add(new LocaleDesc(LcLocale.French_Switzerland, "French (Switzerland)", "iso88591", 0));
            this.add(new LocaleDesc(LcLocale.French_France, "French (France)", "iso88591", 0));
            this.add(new LocaleDesc(LcLocale.French_Luxembourg, "French (Luxembourg)", "iso88591", 0));
            this.add(new LocaleDesc(LcLocale.Hebrew, "Hebrew", "iso88598", 2));
            this.add(new LocaleDesc(LcLocale.Hebrew_Israel, "Hebrew (Israel)", "iso88598", 2));
            this.add(new LocaleDesc(LcLocale.Hindi, "Hindi", "utf8", 0));
            this.add(new LocaleDesc(LcLocale.Hindi_India, "Hindi (India)", "utf8", 0));
            this.add(new LocaleDesc(LcLocale.Croatian, "Croatian", "iso88592", 0));
            this.add(new LocaleDesc(LcLocale.Croatian_Croatia, "Croatian (Croatia)", "iso88592", 0));
            this.add(new LocaleDesc(LcLocale.Hungarian, "Hungarian", "iso88592", 0));
            this.add(new LocaleDesc(LcLocale.Hungarian_Hungary, "Hungarian (Hungary)", "iso88592", 0));
            this.add(new LocaleDesc(LcLocale.Armenian, "Armenian", "utf8", 0));
            this.add(new LocaleDesc(LcLocale.Armenian_Armenia, "Armenian (Armenia)", "utf8", 0));
            this.add(new LocaleDesc(LcLocale.Indonesian, "Indonesian", "iso88591", 0));
            this.add(new LocaleDesc(LcLocale.Indonesian_Indonesia, "Indonesian (Indonesia)", "iso88591", 0));
            this.add(new LocaleDesc(LcLocale.Icelandic, "Icelandic", "iso88591", 0));
            this.add(new LocaleDesc(LcLocale.Icelandic_Iceland, "Icelandic (Iceland)", "iso88591", 0));
            this.add(new LocaleDesc(LcLocale.Italian, "Italian", "iso88591", 0));
            this.add(new LocaleDesc(LcLocale.Italian_Switzerland, "Italian (Switzerland)", "iso88591", 0));
            this.add(new LocaleDesc(LcLocale.Italian_Italy, "Italian (Italy)", "iso88591", 0));
            this.add(new LocaleDesc(LcLocale.Japanese, "Japanese", "shift_jis", 192));
            this.add(new LocaleDesc(LcLocale.Japanese_Japan, "Japanese (Japan)", "shift-jis", 192));
            this.add(new LocaleDesc(LcLocale.Kazakh, "Kazakh", "iso88595", 0));
            this.add(new LocaleDesc(LcLocale.Kazakh_Kazakhstan, "Kazakh-Kazakhstan", "iso88595", 0));
            this.add(new LocaleDesc(LcLocale.Khmer, "Khmer", "utf8", 0));
            this.add(new LocaleDesc(LcLocale.Khmer_Cambodia, "Khmer (Cambodia)", "utf8", 0));
            this.add(new LocaleDesc(LcLocale.Korean, "Korean", "ksc_5601", 320));
            this.add(new LocaleDesc(LcLocale.Korean_Korea, "Korean (Korea)", "ksc-5601", 320));
            this.add(new LocaleDesc(LcLocale.Korean_Korea_Hani, "Korean_Hanja (Korea)", "ksc-5601", 832));
            this.add(new LocaleDesc(LcLocale.Lao, "Lao", "utf8", 0));
            this.add(new LocaleDesc(LcLocale.Lao_Laos, "Lao (Laos)", "utf8", 0));
            this.add(new LocaleDesc(LcLocale.Lithuanian, "Lithuanian", "iso885913", 0));
            this.add(new LocaleDesc(LcLocale.Lithuanian_Lithuania, "Lithuanian (Lithuania)", "iso885913", 0));
            this.add(new LocaleDesc(LcLocale.Latvian, "Latvian", "iso885913", 0));
            this.add(new LocaleDesc(LcLocale.Latvian_Latvia, "Latvian (Latvia)", "iso885913", 0));
            this.add(new LocaleDesc(LcLocale.Macedonian, "Macedonian", "iso88595", 0));
            this.add(new LocaleDesc(LcLocale.Macedonian_Macedonia, "Macedonian (Macedonia)", "iso88595", 0));
            this.add(new LocaleDesc(LcLocale.Malay, "Malay", "iso88591", 0));
            this.add(new LocaleDesc(LcLocale.Malay_Malaysia, "Malay (Malaysia)", "iso88591", 0));
            this.add(new LocaleDesc(LcLocale.Norwegian_Bokmal, "Norwegian_Bokm\u00ef\u00bf\u00bdl", "iso88591", 0));
            this.add(new LocaleDesc(LcLocale.Norwegian_Bokmal_Norway, "Norwegian_Bokm\u00ef\u00bf\u00bdl (Norway)", "iso88591", 0));
            this.add(new LocaleDesc(LcLocale.Dutch, "Dutch", "iso88591", 0));
            this.add(new LocaleDesc(LcLocale.Dutch_Belgium, "Dutch (Belgium)", "iso88591", 0));
            this.add(new LocaleDesc(LcLocale.Dutch_Netherlands, "Dutch (Netherlands)", "iso88591", 0));
            this.add(new LocaleDesc(LcLocale.Norwegian_Nynorsk, "Norwegian_Nynorsk", "iso88591", 0));
            this.add(new LocaleDesc(LcLocale.Norwegian_Nynorsk_Norway, "Norwegian_Nynorsk (Norway)", "iso88591", 0));
            this.add(new LocaleDesc("no", "Norwegian", "iso88591", 0));
            this.add(new LocaleDesc("no_NO", "Norwegian (Norway)", "iso88591", 0));
            this.add(new LocaleDesc("no_NO_NY", "Norwegian (Norway Nynorsk)", "iso88591", 0));
            this.add(new LocaleDesc(LcLocale.Polish, "Polish", "iso88592", 0));
            this.add(new LocaleDesc(LcLocale.Polish_Poland, "Polish (Poland)", "iso88592", 0));
            this.add(new LocaleDesc(LcLocale.Portuguese, "Portuguese", "iso88591", 0));
            this.add(new LocaleDesc(LcLocale.Portuguese_Brazil, "Portuguese (Brazil)", "iso88591", 0));
            this.add(new LocaleDesc(LcLocale.Portuguese_Portugal, "Portuguese (Portugal)", "iso88591", 0));
            this.add(new LocaleDesc(LcLocale.Romanian, "Romanian", "iso88592", 0));
            this.add(new LocaleDesc(LcLocale.Romanian_Moldova, "Romanian (Moldova)", "iso88592", 0));
            this.add(new LocaleDesc(LcLocale.Romanian_Romania, "Romanian (Romania)", "iso88592", 0));
            this.add(new LocaleDesc(LcLocale.Russian, "Russian", "iso88595", 0));
            this.add(new LocaleDesc(LcLocale.Russian_Moldova, "Russian (Moldova)", "iso88595", 0));
            this.add(new LocaleDesc(LcLocale.Russian_Russia, "Russian (Russia)", "iso88595", 0));
            this.add(new LocaleDesc(LcLocale.Russian_Ukraine, "Russian (Ukraine)", "iso88595", 0));
            this.add(new LocaleDesc(LcLocale.Serbo_Croatian, "Serbo (Croatian)", "iso88592", 0));
            this.add(new LocaleDesc(LcLocale.Serbo_Croatian_BosniaHerzegovina, "Serbo (Croatian Bosnia And Herzegovina)", "iso88592", 0));
            this.add(new LocaleDesc(LcLocale.Serbo_Croatian_SerbiaMontenegro, "Serbo (Croatian Serbia And Montenegro)", "iso88592", 0));
            this.add(new LocaleDesc(LcLocale.Serbo_Croatian_Croatia, "Serbo (Croatian Croatia)", "iso88592", 0));
            this.add(new LocaleDesc(LcLocale.Slovak, "Slovak", "iso88592", 0));
            this.add(new LocaleDesc(LcLocale.Slovak_Slovakia, "Slovak (Slovakia)", "iso88592", 0));
            this.add(new LocaleDesc(LcLocale.Slovenian, "Slovenian", "iso88592", 0));
            this.add(new LocaleDesc(LcLocale.Slovenian_Slovenia, "Slovenian (Slovenia)", "iso88592", 0));
            this.add(new LocaleDesc(LcLocale.Albanian, "Albanian", "iso885915", 0));
            this.add(new LocaleDesc(LcLocale.Albanian_Albania, "Albanian (Albania)", "iso885915", 0));
            this.add(new LocaleDesc(LcLocale.Serbian, "Serbian", "iso88595", 0));
            this.add(new LocaleDesc(LcLocale.Serbian_Yugoslavia, "Serbian (Yugoslavia)", "iso88595", 0));
            this.add(new LocaleDesc(LcLocale.Serbian_Cyrillic, "Serbian_Cyrillic", "iso88595", 0));
            this.add(new LocaleDesc(LcLocale.Serbian_Cyrillic_SerbiaMontenegro, "Serbian_Cyrillic (Serbia And Montenegro)", "iso88595", 0));
            this.add(new LocaleDesc(LcLocale.Serbian_Latin, "Serbian_Latin", "iso88592", 0));
            this.add(new LocaleDesc(LcLocale.Serbian_Latin_SerbiaMontenegro, "Serbian_Latin (Serbia And Montenegro)", "iso88592", 0));
            this.add(new LocaleDesc(LcLocale.Swedish, "Swedish", "iso88591", 0));
            this.add(new LocaleDesc(LcLocale.Swedish_Finland, "Swedish (Finland)", "iso88591", 0));
            this.add(new LocaleDesc(LcLocale.Swedish_Sweden, "Swedish (Sweden)", "iso88591", 0));
            this.add(new LocaleDesc(LcLocale.Thai, "Thai", "ibm874", 1056));
            this.add(new LocaleDesc(LcLocale.Thai_Thailand, "Thai (Thailand)", "ibm874", 1056));
            this.add(new LocaleDesc(LcLocale.Thai_Thailand_Traditional, "Thai (Thailand Traditional)", "ibm874", 1056));
            this.add(new LocaleDesc(LcLocale.Tagalog, "Tagalog", "iso88591", 0));
            this.add(new LocaleDesc(LcLocale.Tagalog_Philippines, "Tagalog (Philippines)", "iso88591", 0));
            this.add(new LocaleDesc(LcLocale.Turkish, "Turkish", "iso88599", 0));
            this.add(new LocaleDesc(LcLocale.Turkish_Turkey, "Turkish (Turkey)", "iso88599", 0));
            this.add(new LocaleDesc(LcLocale.Ukrainian, "Ukrainian", "ibm1124", 0));
            this.add(new LocaleDesc(LcLocale.Ukrainian_Ukraine, "Ukrainian (Ukraine)", "ibm1124", 0));
            this.add(new LocaleDesc(LcLocale.Vietnamese, "Vietnamese", "ibm1258", 0));
            this.add(new LocaleDesc(LcLocale.Vietnamese_Vietnam, "Vietnamese (Vietnam)", "ibm1258", 0));
            this.add(new LocaleDesc(LcLocale.Chinese, "Chinese", "gbk", 68));
            this.add(new LocaleDesc(LcLocale.Chinese_China, "Chinese (China)", "gbk", 76));
            this.add(new LocaleDesc(LcLocale.Chinese_Simplified, "Chinese_Hans", "gbk", 76));
            this.add(new LocaleDesc(LcLocale.Chinese_Traditional, "Chinese_Hant", "big5", 84));
            this.add(new LocaleDesc(LcLocale.Chinese_HongKong, "Chinese (Hong Kong)", "hkscs-big5", 84));
            this.add(new LocaleDesc(LcLocale.Chinese_Singapore, "Chinese (Singapore)", "big5", 76));
            this.add(new LocaleDesc(LcLocale.Chinese_Taiwan, "Chinese (Taiwan)", "big5", 84));
        }

        private void add(LocaleDesc localeDesc) {
            this.put(localeDesc.mLocName, localeDesc);
        }
    };

    public LcLocale(String locale) {
        LocaleDesc localeDesc = null;
        if (!StringUtils.isEmpty(locale)) {
            String sDequalifiedLocale;
            String sNormalizedLocale = LcLocale.normalize(locale);
            localeDesc = LcLocale.searchMap(sNormalizedLocale);
            if (localeDesc == null) {
                localeDesc = mStaticMap.get(sNormalizedLocale);
            }
            if (localeDesc == null && !sNormalizedLocale.equals(sDequalifiedLocale = LcLocale.dequalify(sNormalizedLocale))) {
                localeDesc = LcLocale.searchMap(sDequalifiedLocale);
            }
        }
        this.mLocaleDesc = localeDesc == null ? mInvalidLocale : localeDesc;
    }

    public static String normalize(String locale) {
        String sNormal = "";
        if (locale != null) {
            char c;
            int p;
            StringBuilder loc = new StringBuilder(locale);
            int pDash = loc.indexOf("-");
            while (pDash >= 0) {
                loc.setCharAt(pDash, '_');
                pDash = loc.indexOf("-");
            }
            int pUnderScore = loc.indexOf("_");
            if (pUnderScore >= 0) {
                char c2;
                int i;
                int p2;
                int pNextUnderScore = loc.indexOf("_", pUnderScore + 1);
                if (pNextUnderScore >= 0 && pUnderScore + 5 == pNextUnderScore) {
                    p2 = pUnderScore + 1;
                    for (i = 0; i < 4; ++i) {
                        c2 = loc.charAt(p2);
                        if (i == 0 && Character.isLowerCase(c2)) {
                            loc.setCharAt(p2, Character.toUpperCase(c2));
                        } else if (i > 0 && Character.isUpperCase(c2)) {
                            loc.setCharAt(p2, Character.toLowerCase(c2));
                        }
                        ++p2;
                    }
                    pUnderScore += 5;
                } else if (pNextUnderScore < 0 && pUnderScore + 5 == loc.length()) {
                    p2 = pUnderScore + 1;
                    for (i = 0; i < 4; ++i) {
                        c2 = loc.charAt(p2);
                        if (i == 0 && Character.isLowerCase(c2)) {
                            loc.setCharAt(p2, Character.toUpperCase(c2));
                        } else if (i > 0 && Character.isUpperCase(c2)) {
                            loc.setCharAt(p2, Character.toLowerCase(c2));
                        }
                        ++p2;
                    }
                    pUnderScore += 5;
                } else {
                    pUnderScore = 0;
                }
            } else {
                for (p = pUnderScore = 0; p < loc.length(); ++p) {
                    c = loc.charAt(p);
                    if (!Character.isUpperCase(c)) continue;
                    loc.setCharAt(p, Character.toLowerCase(c));
                }
            }
            pUnderScore = loc.indexOf("_", pUnderScore);
            if (pUnderScore >= 0) {
                for (p = pUnderScore + 1; p < loc.length(); ++p) {
                    c = loc.charAt(p);
                    if (Character.isLowerCase(c)) {
                        loc.setCharAt(p, Character.toUpperCase(c));
                        continue;
                    }
                    if (c != '-') continue;
                    loc.setCharAt(p, '_');
                }
            }
            sNormal = loc.toString();
        }
        return sNormal;
    }

    private static String dequalify(String locale) {
        int length = locale.length();
        int dot = locale.indexOf(46);
        int at = locale.indexOf(64);
        int qualifier = Math.min(dot == -1 ? length : dot, at == -1 ? length : at);
        return qualifier == length ? locale : locale.substring(0, qualifier);
    }

    public boolean isValid() {
        return this.getLocaleDesc() != mInvalidLocale;
    }

    public boolean isChinese() {
        return (this.getLocaleDesc().mMask & 4) != 0;
    }

    public boolean isSimplifiedChinese() {
        LocaleDesc oLocaleDesc = this.getLocaleDesc();
        if (oLocaleDesc.mLocName.equals(Chinese_HongKong)) {
            return true;
        }
        return (oLocaleDesc.mMask & 8) != 0;
    }

    public boolean isTraditionalChinese() {
        LocaleDesc oLocaleDesc = this.getLocaleDesc();
        if (oLocaleDesc.mLocName.equals(Chinese_HongKong)) {
            return false;
        }
        return (oLocaleDesc.mMask & 0x10) != 0;
    }

    public boolean isJapanese() {
        return (this.getLocaleDesc().mMask & 0x80) != 0;
    }

    public boolean isKoreanHani() {
        return (this.getLocaleDesc().mMask & 0x200) != 0;
    }

    public boolean isKorean() {
        return (this.getLocaleDesc().mMask & 0x100) != 0;
    }

    public boolean isThai() {
        return (this.getLocaleDesc().mMask & 0x400) != 0;
    }

    public boolean isBIDI() {
        return (this.getLocaleDesc().mMask & 2) != 0;
    }

    public boolean isArabic() {
        return (this.getLocaleDesc().mMask & 1) != 0;
    }

    public boolean isIdeographic() {
        return (this.getLocaleDesc().mMask & 0x40) != 0;
    }

    public boolean needsDictionaryBreaking() {
        return (this.getLocaleDesc().mMask & 0x20) != 0;
    }

    public String getName() {
        return this.getLocaleDesc().mLocName;
    }

    public String getIsoName() {
        return this.getLocaleDesc().mLocName;
    }

    private LocaleDesc getLocaleDesc() {
        return this.mLocaleDesc;
    }

    public String getCharSet() {
        return this.getLocaleDesc().mCharSet;
    }

    public String getDescName() {
        LocaleDesc oLocaleDesc = this.getLocaleDesc();
        Locale oLoc = new Locale(oLocaleDesc.mLocName);
        String sDesc = oLoc.getDisplayName();
        if (sDesc.length() == 0 || oLocaleDesc.mLocName.equals(LcLocale.normalize(sDesc))) {
            sDesc = oLocaleDesc.mDescName;
        }
        return sDesc;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        LcLocale locale = (LcLocale)object;
        return this.getIsoName().equals(locale.getIsoName());
    }

    private static LocaleDesc searchMap(String name) {
        LocaleDesc localeDesc = mRuntimeMap.get().get(name);
        if (localeDesc == null) {
            localeDesc = mStaticMap.get(name);
        }
        return localeDesc;
    }

    public int hashCode() {
        return this.getIsoName().hashCode();
    }

    public static String getLocale() {
        return Locale.getDefault().toString();
    }

    public static void setLocale(String localeName) {
        String language = null;
        String country = null;
        String variant = null;
        Locale locale = null;
        int split = localeName.indexOf(95);
        if (split < 0) {
            locale = new Locale(localeName);
        } else {
            country = localeName.substring(split + 1);
            language = localeName.substring(0, split);
            split = country.indexOf(95);
            if (split < 0) {
                locale = new Locale(language, country);
            } else {
                variant = country.substring(split + 1);
                country = country.substring(0, split);
                locale = new Locale(language, country, variant);
            }
        }
        Locale.setDefault(locale);
    }

    public static void reset() {
        mRuntimeMap.get().clear();
    }

    public static void update(String sLocale, String sDesc) {
        String sLoc = LcLocale.normalize(sLocale);
        String sCharSet = "";
        int nDot = sLoc.indexOf(46);
        if (nDot >= 0) {
            sCharSet = sLoc.substring(nDot + 1);
            sLoc = sLoc.substring(0, nDot);
        }
        int nMask = 0;
        if (sLoc.startsWith(Chinese)) {
            nMask |= 0x44;
            if (sLoc.startsWith(Chinese_Simplified)) {
                nMask |= 8;
            } else if (sLoc.equals(Chinese_China)) {
                nMask |= 8;
            } else if (sLoc.equals(Chinese_Singapore)) {
                nMask |= 8;
            } else if (sLoc.startsWith(Chinese_Traditional)) {
                nMask |= 0x10;
            } else if (sLoc.equals(Chinese_HongKong)) {
                nMask |= 0x10;
            } else if (sLoc.equals(Chinese_Taiwan)) {
                nMask |= 0x10;
            }
        } else if (sLoc.startsWith(Japanese)) {
            nMask |= 0xC0;
        } else if (sLoc.startsWith(Korean)) {
            nMask |= 0x140;
            if (sLoc.startsWith(Korean_Korea_Hani)) {
                nMask |= 0x200;
            }
        } else if (sLoc.startsWith(Thai)) {
            nMask |= 0x420;
        } else if (sLoc.startsWith(Arabic)) {
            nMask |= 3;
        } else if (sLoc.startsWith(Persian)) {
            nMask |= 3;
        } else if (sLoc.startsWith(Hebrew)) {
            nMask |= 2;
        }
        LocaleDesc oLcDesc = new LocaleDesc(sLoc, sDesc, sCharSet, nMask);
        mRuntimeMap.get().put(sLoc, oLcDesc);
    }

    public static String currencySymbol() {
        return LcLocale.getLcData().getCurrencySymbol();
    }

    public static String negativeSign() {
        return LcLocale.getLcData().getNegativeSymbol();
    }

    public static String positiveSign() {
        return LcLocale.getLcData().getPositiveSymbol();
    }

    public static String decimalPoint() {
        return LcLocale.getLcData().getRadixSymbol();
    }

    public static String thousandsSep() {
        return LcLocale.getLcData().getGroupingSymbol();
    }

    public static String systemDecimalPoint() {
        StringBuilder radix = new StringBuilder();
        DecimalFormat f = (DecimalFormat)NumberFormat.getInstance();
        DecimalFormatSymbols s = f.getDecimalFormatSymbols();
        radix.append(s.getDecimalSeparator());
        return radix.toString();
    }

    public static char systemDecimalPointAsChar() {
        DecimalFormat f = (DecimalFormat)NumberFormat.getInstance();
        DecimalFormatSymbols s = f.getDecimalFormatSymbols();
        return s.getDecimalSeparator();
    }

    private static LcData getLcData() {
        LcLocale oLocale = new LcLocale(LcLocale.getLocale());
        if (!oLocale.isValid()) {
            oLocale = new LcLocale("en_US");
        }
        return new LcData(oLocale.getIsoName());
    }

    private static class LocaleDesc {
        final String mLocName;
        final String mDescName;
        final String mCharSet;
        final int mMask;

        LocaleDesc(String locName, String descName, String charSet, int mask) {
            this.mLocName = locName;
            this.mDescName = descName;
            this.mCharSet = charSet;
            this.mMask = mask;
        }
    }
}

