/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.api;

import java.util.Arrays;
import java.util.Date;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.osgi.service.event.Event;

public class DamEvent {
    public static final String EVENT_TOPIC = "com/day/cq/dam";
    private static final String PROPERTY_TYPE = "type";
    private static final String PROPERTY_DATE = "date";
    public static final String PROPERTY_EXPIRATIONDATE = "expirationDate";
    public static final String PROPERTY_CREATEDBY = "createdBy";
    private static final String PROPERTY_ASSETPATH = "assetPath";
    private static final String PROPERTY_USER_ID = "userId";
    public static final String PROPERTY_VERSION_ID = "versionId";
    public static final String PROPERTY_LICENSE_INFO = "licenseInfo";
    public static final String PROPERTY_ADDITIONAL_INFO = "additionalInfo";
    private static final String PROPERTY_DISTRIBUTABLE = "event.distribute";
    private static final Map<String, Class<?>> propertyTypesMap = new HashMap<String, Class<?>>(){
        {
            this.put(DamEvent.PROPERTY_TYPE, Type.class);
            this.put(DamEvent.PROPERTY_ASSETPATH, String.class);
            this.put(DamEvent.PROPERTY_USER_ID, String.class);
            this.put(DamEvent.PROPERTY_VERSION_ID, String.class);
            this.put(DamEvent.PROPERTY_LICENSE_INFO, String.class);
            this.put(DamEvent.PROPERTY_ADDITIONAL_INFO, String.class);
            this.put(DamEvent.PROPERTY_DATE, Date.class);
            this.put(DamEvent.PROPERTY_EXPIRATIONDATE, Date.class);
            this.put(DamEvent.PROPERTY_CREATEDBY, String.class);
        }
    };
    private final Map<String, Object> propertiesMap = new HashMap<String, Object>();

    private <T> T getTypedProperty(String key, Class<T> type) {
        Object propVal = this.propertiesMap.get(key);
        if (null == propVal) {
            return null;
        }
        if (type.isAssignableFrom(propVal.getClass())) {
            return (T)propVal;
        }
        return null;
    }

    private <T> T getTypedPropertyFromEvent(String key, Class<T> type, Event event) {
        Object propVal = event.getProperty(key);
        if (null == propVal) {
            return null;
        }
        if (type.isAssignableFrom(propVal.getClass())) {
            return (T)propVal;
        }
        return null;
    }

    private DamEvent(Type type, String assetPath, String userId, String licenseInfo, String versionId, String additionalInfo, Date date, Date expirationDate, String createdBy) {
        this.propertiesMap.put(PROPERTY_TYPE, (Object)type);
        this.propertiesMap.put(PROPERTY_ASSETPATH, assetPath);
        this.propertiesMap.put(PROPERTY_USER_ID, userId);
        this.propertiesMap.put(PROPERTY_VERSION_ID, versionId);
        this.propertiesMap.put(PROPERTY_LICENSE_INFO, licenseInfo);
        this.propertiesMap.put(PROPERTY_ADDITIONAL_INFO, additionalInfo);
        this.propertiesMap.put(PROPERTY_DATE, null != date ? date : new Date());
        this.propertiesMap.put(PROPERTY_EXPIRATIONDATE, expirationDate);
        this.propertiesMap.put(PROPERTY_CREATEDBY, createdBy);
    }

    private DamEvent(Event event) {
        Arrays.stream(event.getPropertyNames()).filter(name -> !StringUtils.startsWith(name, "event.")).forEach(key -> {
            Class<Object> clazz = propertyTypesMap.get(key);
            if (null == clazz) {
                clazz = String.class;
            }
            if (null != this.getTypedPropertyFromEvent((String)key, clazz, event)) {
                this.propertiesMap.put((String)key, this.getTypedPropertyFromEvent((String)key, clazz, event));
            }
        });
    }

    public String getAssetPath() {
        return this.getTypedProperty(PROPERTY_ASSETPATH, String.class);
    }

    public Date getDate() {
        return this.getTypedProperty(PROPERTY_DATE, Date.class);
    }

    public String getLicenseInfo() {
        return this.getTypedProperty(PROPERTY_LICENSE_INFO, String.class);
    }

    public String getVersionId() {
        return this.getTypedProperty(PROPERTY_VERSION_ID, String.class);
    }

    public String getUserId() {
        return this.getTypedProperty(PROPERTY_USER_ID, String.class);
    }

    public Type getType() {
        return this.getTypedProperty(PROPERTY_TYPE, Type.class);
    }

    public String getAdditionalInfo() {
        return this.getTypedProperty(PROPERTY_ADDITIONAL_INFO, String.class);
    }

    public Date getExpirationDate() {
        return this.getTypedProperty(PROPERTY_EXPIRATIONDATE, Date.class);
    }

    public String getCreatedBy() {
        return this.getTypedProperty(PROPERTY_CREATEDBY, String.class);
    }

    public boolean isPublishedExternally() {
        return Type.PUBLISHED_EXTERNAL == this.getType();
    }

    public static DamEvent fromEvent(Event event) {
        return EVENT_TOPIC.equals(event.getTopic()) ? new DamEvent(event) : null;
    }

    public Event toEvent() {
        return new Event(EVENT_TOPIC, this.getDistributableEventProperties());
    }

    public Event toNonDistributableEvent() {
        return new Event(EVENT_TOPIC, this.getEventProperties());
    }

    public static DamEvent accepted(String assetPath, String userId, String licenseInfo) {
        return new DamEvent(Type.ACCEPTED, assetPath, userId, licenseInfo, null, null, null, null, null);
    }

    public static DamEvent rejected(String assetPath, String userId, String licenseInfo) {
        return new DamEvent(Type.REJECTED, assetPath, userId, licenseInfo, null, null, null, null, null);
    }

    public static DamEvent downloaded(String assetPath, String userId) {
        return new DamEvent(Type.DOWNLOADED, assetPath, userId, null, null, null, null, null, null);
    }

    public static DamEvent downloaded(String assetPath, String userId, String additionalInfo) {
        return new DamEvent(Type.DOWNLOADED, assetPath, userId, null, null, additionalInfo, null, null, null);
    }

    public static DamEvent versioned(String assetPath, String userId, String versionId) {
        return new DamEvent(Type.VERSIONED, assetPath, userId, null, versionId, null, null, null, null);
    }

    public static DamEvent restored(String assetPath, String userId, String versionId) {
        return new DamEvent(Type.RESTORED, assetPath, userId, null, versionId, null, null, null, null);
    }

    public static DamEvent metadataUpdated(String assetPath, String userId) {
        return new DamEvent(Type.METADATA_UPDATED, assetPath, userId, null, null, null, null, null, null);
    }

    public static DamEvent metadataUpdated(String assetPath, String userId, String additionalInfo) {
        return new DamEvent(Type.METADATA_UPDATED, assetPath, userId, null, null, additionalInfo, null, null, null);
    }

    public static DamEvent publishedExternally(String assetPath, String userId, String additionalInfo) {
        return new DamEvent(Type.PUBLISHED_EXTERNAL, assetPath, userId, null, null, additionalInfo, null, null, null);
    }

    public static DamEvent originalUpdated(String assetPath, String userId) {
        return new DamEvent(Type.ORIGINAL_UPDATED, assetPath, userId, null, null, null, null, null, null);
    }

    public static DamEvent renditionUpdated(String assetPath, String userId, String renditionPath) {
        return new DamEvent(Type.RENDITION_UPDATED, assetPath, userId, null, null, renditionPath, null, null, null);
    }

    public static DamEvent renditionRemoved(String assetPath, String userId, String renditionPath) {
        return new DamEvent(Type.RENDITION_REMOVED, assetPath, userId, null, null, renditionPath, null, null, null);
    }

    public static DamEvent renditionDownloaded(String assetPath, String userId, String renditionPath) {
        return new DamEvent(Type.RENDITION_DOWNLOADED, assetPath, userId, null, null, renditionPath, null, null, null);
    }

    public static DamEvent subassetUpdated(String assetPath, String userId, String subassetPath) {
        return new DamEvent(Type.SUBASSET_UPDATED, assetPath, userId, null, null, subassetPath, null, null, null);
    }

    public static DamEvent subassetRemoved(String assetPath, String userId, String subassetPath) {
        return new DamEvent(Type.SUBASSET_REMOVED, assetPath, userId, null, null, subassetPath, null, null, null);
    }

    public static DamEvent assetCreated(String assetPath, String userId) {
        return new DamEvent(Type.ASSET_CREATED, assetPath, userId, null, null, null, null, null, null);
    }

    public static DamEvent assetMoved(String assetPath, String userId) {
        return new DamEvent(Type.ASSET_MOVED, assetPath, userId, null, null, null, null, null, null);
    }

    public static DamEvent assetRemoved(String assetPath, String userId) {
        return new DamEvent(Type.ASSET_REMOVED, assetPath, userId, null, null, null, null, null, null);
    }

    public static DamEvent assetExpired(String assetPath, String userId, Date expirationDate, String createdBy) {
        return new DamEvent(Type.ASSET_EXPIRED, assetPath, userId, null, null, null, null, expirationDate, createdBy);
    }

    public static DamEvent assetExpiring(String assetPath, String userId, Date expirationDate, String createdBy) {
        return new DamEvent(Type.ASSET_EXPIRING, assetPath, userId, null, null, null, null, expirationDate, createdBy);
    }

    public static DamEvent assetViewed(String assetPath, String userId) {
        return new DamEvent(Type.ASSET_VIEWED, assetPath, userId, null, null, null, null, null, null);
    }

    public static DamEvent assetShared(String assetPath, String userId, String additionalInfo) {
        return new DamEvent(Type.ASSET_SHARED, assetPath, userId, null, null, additionalInfo, null, null, null);
    }

    public static DamEvent assetPublished(String assetPath, String userId) {
        return new DamEvent(Type.ASSET_PUBLISHED, assetPath, userId, null, null, null, null, null, null);
    }

    public static DamEvent projectViewed(String assetPath, String userId) {
        return new DamEvent(Type.PROJECT_VIEWED, assetPath, userId, null, null, null, null, null, null);
    }

    public static DamEvent collectionViewed(String assetPath, String userId) {
        return new DamEvent(Type.COLLECTION_VIEWED, assetPath, userId, null, null, null, null, null, null);
    }

    public static DamEvent addedComment(String assetPath, String userId, String additionalInfo) {
        return new DamEvent(Type.ADDED_COMMENT, assetPath, userId, null, null, additionalInfo, null, null, null);
    }

    public static DamEvent assetUsage(String assetPath, String usageType, Date date) {
        return new DamEvent(Type.ASSET_USAGE, assetPath, null, null, null, usageType, date, null, null);
    }

    public static DamEvent damUpdateAssetWorkflowCompleted(String assetPath) {
        return new DamEvent(Type.DAM_UPDATE_ASSET_WORKFLOW_COMPLETED, assetPath, null, null, null, null, null, null, null);
    }

    public static DamEvent damMetadataWritebackWorkflowCompleted(String assetPath) {
        return new DamEvent(Type.DAM_METADATA_WRITEBACK_WORKFLOW_COMPLETED, assetPath, null, null, null, null, null, null, null);
    }

    private Dictionary<String, Object> getEventProperties() {
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        this.propertiesMap.keySet().forEach(k -> {
            Class<Object> clazz = propertyTypesMap.get(k);
            if (null == clazz) {
                clazz = String.class;
            }
            if (null != this.getTypedProperty((String)k, clazz)) {
                properties.put((String)k, this.getTypedProperty((String)k, clazz));
            }
        });
        return properties;
    }

    private Dictionary<String, Object> getDistributableEventProperties() {
        Dictionary<String, Object> properties = this.getEventProperties();
        properties.put(PROPERTY_DISTRIBUTABLE, Boolean.TRUE);
        return properties;
    }

    public static enum Type {
        ACCEPTED,
        REJECTED,
        DOWNLOADED,
        VERSIONED,
        RESTORED,
        METADATA_UPDATED,
        PUBLISHED_EXTERNAL,
        ORIGINAL_UPDATED,
        RENDITION_UPDATED,
        RENDITION_REMOVED,
        RENDITION_DOWNLOADED,
        SUBASSET_UPDATED,
        SUBASSET_REMOVED,
        ASSET_CREATED,
        ASSET_MOVED,
        ASSET_REMOVED,
        ASSET_EXPIRED,
        ASSET_EXPIRING,
        ASSET_VIEWED,
        ASSET_SHARED,
        ASSET_PUBLISHED,
        ADDED_COMMENT,
        PROJECT_VIEWED,
        COLLECTION_VIEWED,
        ASSET_USAGE,
        DAM_UPDATE_ASSET_WORKFLOW_COMPLETED,
        DAM_METADATA_WRITEBACK_WORKFLOW_COMPLETED;

    }
}

