/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.photoshop;

import com.drew.imaging.jpeg.JpegSegmentMetadataReader;
import com.drew.imaging.jpeg.JpegSegmentType;
import com.drew.lang.Charsets;
import com.drew.lang.SequentialByteArrayReader;
import com.drew.lang.SequentialReader;
import com.drew.lang.annotations.NotNull;
import com.drew.metadata.Metadata;
import com.drew.metadata.photoshop.DuckyDirectory;
import java.io.IOException;
import java.util.Collections;

@Deprecated(since="2024-11-20")
public class DuckyReader
implements JpegSegmentMetadataReader {
    @NotNull
    private static final String JPEG_SEGMENT_PREAMBLE = "Ducky";

    @Override
    @NotNull
    public Iterable<JpegSegmentType> getSegmentTypes() {
        return Collections.singletonList(JpegSegmentType.APPC);
    }

    @Override
    public void readJpegSegments(@NotNull Iterable<byte[]> segments, @NotNull Metadata metadata, @NotNull JpegSegmentType segmentType) {
        int preambleLength = JPEG_SEGMENT_PREAMBLE.length();
        for (byte[] segmentBytes : segments) {
            if (segmentBytes.length < preambleLength || !JPEG_SEGMENT_PREAMBLE.equals(new String(segmentBytes, 0, preambleLength))) continue;
            this.extract(new SequentialByteArrayReader(segmentBytes, preambleLength), metadata);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void extract(@NotNull SequentialReader reader, @NotNull Metadata metadata) {
        DuckyDirectory directory = new DuckyDirectory();
        metadata.addDirectory(directory);
        try {
            block6: while (true) {
                int tag;
                if ((tag = reader.getUInt16()) == 0) {
                    return;
                }
                int length = reader.getUInt16();
                switch (tag) {
                    case 1: {
                        if (length != 4) {
                            directory.addError("Unexpected length for the quality tag");
                            return;
                        }
                        directory.setInt(tag, reader.getInt32());
                        continue block6;
                    }
                    case 2: 
                    case 3: {
                        reader.skip(4L);
                        directory.setStringValue(tag, reader.getStringValue(length - 4, Charsets.UTF_16BE));
                        continue block6;
                    }
                }
                directory.setByteArray(tag, reader.getBytes(length));
            }
        }
        catch (IOException e) {
            directory.addError(e.getMessage());
        }
    }
}

