/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene;

import java.io.File;
import java.io.IOException;
import java.util.Objects;
import java.util.Set;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.conditions.Validate;
import org.apache.jackrabbit.oak.json.JsopDiff;
import org.apache.jackrabbit.oak.plugins.index.AsyncIndexInfo;
import org.apache.jackrabbit.oak.plugins.index.AsyncIndexInfoService;
import org.apache.jackrabbit.oak.plugins.index.IndexInfo;
import org.apache.jackrabbit.oak.plugins.index.IndexInfoProvider;
import org.apache.jackrabbit.oak.plugins.index.IndexUtils;
import org.apache.jackrabbit.oak.plugins.index.lucene.LuceneIndexDefinition;
import org.apache.jackrabbit.oak.plugins.index.lucene.directory.DirectoryUtils;
import org.apache.jackrabbit.oak.plugins.index.lucene.directory.IndexConsistencyChecker;
import org.apache.jackrabbit.oak.plugins.index.lucene.directory.OakDirectory;
import org.apache.jackrabbit.oak.plugins.index.lucene.writer.MultiplexersLucene;
import org.apache.jackrabbit.oak.plugins.index.search.util.NodeStateCloner;
import org.apache.jackrabbit.oak.spi.state.EqualsDiff;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateUtils;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.apache.jackrabbit.oak.spi.state.ReadOnlyBuilder;
import org.apache.jackrabbit.util.ISO8601;
import org.apache.lucene.store.Directory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LuceneIndexInfoProvider
implements IndexInfoProvider {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final NodeStore nodeStore;
    private final AsyncIndexInfoService asyncInfoService;
    private final File workDir;

    public LuceneIndexInfoProvider(NodeStore nodeStore, AsyncIndexInfoService asyncInfoService, File workDir) {
        this.nodeStore = Objects.requireNonNull(nodeStore);
        this.asyncInfoService = Objects.requireNonNull(asyncInfoService);
        this.workDir = Objects.requireNonNull(workDir);
    }

    @Override
    public String getType() {
        return "lucene";
    }

    @Override
    public IndexInfo getInfo(String indexPath) throws IOException {
        NodeState idxState = NodeStateUtils.getNode(this.nodeStore.getRoot(), indexPath);
        Validate.checkArgument((boolean)"lucene".equals(idxState.getString("type")), (String)"Index definition at [%s] is not of type 'lucene'", (Object[])new Object[]{indexPath});
        LuceneIndexInfo info = new LuceneIndexInfo(indexPath);
        this.computeSize(idxState, info);
        LuceneIndexInfoProvider.computeIndexDefinitionChange(idxState, info);
        LuceneIndexInfoProvider.computeStatusNodeInfo(idxState, info);
        this.computeAsyncIndexInfo(idxState, indexPath, info);
        LuceneIndexInfoProvider.checkIfHiddenNodesExists(idxState, info);
        LuceneIndexInfoProvider.computeCreationTimestamp(idxState, info);
        return info;
    }

    @Override
    public boolean isValid(String indexPath) throws IOException {
        IndexConsistencyChecker checker = new IndexConsistencyChecker(this.nodeStore.getRoot(), indexPath, this.workDir);
        boolean result = false;
        try {
            result = checker.check((IndexConsistencyChecker.Level)IndexConsistencyChecker.Level.BLOBS_ONLY).clean;
        }
        catch (Exception e) {
            this.log.warn("Error occurred while performing consistency check for {}", (Object)indexPath, (Object)e);
        }
        return result;
    }

    private void computeAsyncIndexInfo(NodeState idxState, String indexPath, LuceneIndexInfo info) {
        String asyncName = IndexUtils.getAsyncLaneName(idxState, indexPath);
        if (asyncName == null) {
            this.log.warn("No 'async' value for index definition at [{}]. Definition {}", (Object)indexPath, (Object)idxState);
            return;
        }
        AsyncIndexInfo asyncInfo = this.asyncInfoService.getInfo(asyncName);
        Objects.requireNonNull(asyncInfo, String.format("No async info found for name [%s] for index at [%s]", asyncName, indexPath));
        info.indexedUptoTime = asyncInfo.getLastIndexedTo();
        info.asyncName = asyncName;
    }

    private void computeSize(NodeState idxState, LuceneIndexInfo info) throws IOException {
        LuceneIndexDefinition defn = LuceneIndexDefinition.newLuceneBuilder(this.nodeStore.getRoot(), idxState, info.indexPath).build();
        for (String dirName : idxState.getChildNodeNames()) {
            OakDirectory dir;
            if (!NodeStateUtils.isHidden(dirName)) continue;
            if (MultiplexersLucene.isIndexDirName((String)dirName)) {
                dir = new OakDirectory((NodeBuilder)new ReadOnlyBuilder(idxState), dirName, defn, true);
                try {
                    info.numEntries += (long)DirectoryUtils.getNumDocs((Directory)dir);
                    info.size += DirectoryUtils.dirSize((Directory)dir);
                    continue;
                }
                finally {
                    dir.close();
                    continue;
                }
            }
            if (!MultiplexersLucene.isSuggestIndexDirName((String)dirName)) continue;
            dir = new OakDirectory((NodeBuilder)new ReadOnlyBuilder(idxState), dirName, defn, true);
            try {
                info.suggestSize += DirectoryUtils.dirSize((Directory)dir);
            }
            finally {
                dir.close();
            }
        }
    }

    private static void computeStatusNodeInfo(NodeState idxState, LuceneIndexInfo info) {
        NodeState status = idxState.getChildNode(":status");
        if (status.exists()) {
            PropertyState reindexCompletionTime;
            PropertyState updatedTime = status.getProperty("lastUpdated");
            if (updatedTime != null) {
                info.lastUpdatedTime = ISO8601.parse(updatedTime.getValue(Type.DATE)).getTimeInMillis();
            }
            if ((reindexCompletionTime = status.getProperty("reindexCompletionTimestamp")) != null) {
                info.reindexCompletionTimestamp = ISO8601.parse(reindexCompletionTime.getValue(Type.DATE)).getTimeInMillis();
            }
        }
    }

    private static void computeCreationTimestamp(NodeState idxState, LuceneIndexInfo info) {
        PropertyState creationTime;
        NodeState indexDef = idxState.getChildNode(":index-definition");
        if (indexDef.exists() && (creationTime = indexDef.getProperty("creationTimestamp")) != null) {
            info.creationTimestamp = ISO8601.parse(creationTime.getValue(Type.DATE)).getTimeInMillis();
        }
    }

    private static void checkIfHiddenNodesExists(NodeState idxState, LuceneIndexInfo info) {
        info.hasHiddenOakLibsMount = false;
        info.hasPropertyIndexNode = false;
        for (String c : idxState.getChildNodeNames()) {
            if (c.startsWith(":oak:mount-")) {
                info.hasHiddenOakLibsMount = true;
                continue;
            }
            if (!c.equals(":property-index")) continue;
            info.hasPropertyIndexNode = true;
        }
    }

    private static void computeIndexDefinitionChange(NodeState idxState, LuceneIndexInfo info) {
        NodeState currentDefn;
        NodeState storedDefn = idxState.getChildNode(":index-definition");
        if (storedDefn.exists() && !FilteringEqualsDiff.equals(storedDefn, currentDefn = NodeStateCloner.cloneVisibleState((NodeState)idxState))) {
            info.indexDefinitionChanged = true;
            info.indexDiff = JsopDiff.diffToJsop(storedDefn, currentDefn);
        }
    }

    private static class LuceneIndexInfo
    implements IndexInfo {
        String indexPath;
        String asyncName;
        long numEntries;
        long size;
        long indexedUptoTime;
        long lastUpdatedTime;
        boolean indexDefinitionChanged;
        String indexDiff;
        boolean hasHiddenOakLibsMount;
        boolean hasPropertyIndexNode;
        boolean isActive;
        long suggestSize;
        long creationTimestamp;
        long reindexCompletionTimestamp;

        public LuceneIndexInfo(String indexPath) {
            this.indexPath = indexPath;
        }

        @Override
        public String getIndexPath() {
            return this.indexPath;
        }

        @Override
        public String getType() {
            return "lucene";
        }

        @Override
        public String getAsyncLaneName() {
            return this.asyncName;
        }

        @Override
        public long getLastUpdatedTime() {
            return this.lastUpdatedTime;
        }

        @Override
        public long getIndexedUpToTime() {
            return this.indexedUptoTime;
        }

        @Override
        public long getEstimatedEntryCount() {
            return this.numEntries;
        }

        @Override
        public long getSizeInBytes() {
            return this.size;
        }

        @Override
        public boolean hasIndexDefinitionChangedWithoutReindexing() {
            return this.indexDefinitionChanged;
        }

        @Override
        public String getIndexDefinitionDiff() {
            return this.indexDiff;
        }

        @Override
        public boolean hasHiddenOakLibsMount() {
            return this.hasHiddenOakLibsMount;
        }

        @Override
        public boolean hasPropertyIndexNode() {
            return this.hasPropertyIndexNode;
        }

        @Override
        public void setActive(boolean value) {
            this.isActive = value;
        }

        @Override
        public boolean isActive() {
            return this.isActive;
        }

        @Override
        public long getSuggestSizeInBytes() {
            return this.suggestSize;
        }

        @Override
        public long getCreationTimestamp() {
            return this.creationTimestamp;
        }

        @Override
        public long getReindexCompletionTimestamp() {
            return this.reindexCompletionTimestamp;
        }
    }

    static class FilteringEqualsDiff
    extends EqualsDiff {
        private static final Set<String> IGNORED_PROP_NAMES = Set.of("reindexCount", "reindex");

        FilteringEqualsDiff() {
        }

        public static boolean equals(NodeState before, NodeState after) {
            return before.exists() == after.exists() && after.compareAgainstBaseState(before, new FilteringEqualsDiff());
        }

        @Override
        public boolean propertyChanged(PropertyState before, PropertyState after) {
            return this.ignoredProp(before.getName());
        }

        @Override
        public boolean propertyAdded(PropertyState after) {
            if (this.ignoredProp(after.getName())) {
                return true;
            }
            return super.propertyAdded(after);
        }

        @Override
        public boolean propertyDeleted(PropertyState before) {
            if (this.ignoredProp(before.getName())) {
                return true;
            }
            return super.propertyDeleted(before);
        }

        private boolean ignoredProp(String name) {
            return IGNORED_PROP_NAMES.contains(name) || NodeStateUtils.isHidden(name);
        }
    }
}

