/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.stats;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.jackrabbit.oak.stats.CounterStats;
import org.apache.jackrabbit.oak.stats.GaugeStats;
import org.apache.jackrabbit.oak.stats.HistogramStats;
import org.apache.jackrabbit.oak.stats.MeterStats;
import org.apache.jackrabbit.oak.stats.TimerStats;

public final class SimpleStats<T>
implements TimerStats,
MeterStats,
CounterStats,
HistogramStats,
GaugeStats<T> {
    private final AtomicLong statsHolder;
    private long counter;
    private T value;
    private long meterSum;
    private final AtomicLong meterSumRef = new AtomicLong();
    private final Type type;

    public SimpleStats(AtomicLong statsHolder, Type type) {
        this(statsHolder, type, null);
    }

    public SimpleStats(AtomicLong statsHolder, Type type, T value) {
        this.statsHolder = statsHolder;
        this.type = type;
        this.value = value;
    }

    @Override
    public long getCount() {
        switch (this.type) {
            case HISTOGRAM: 
            case TIMER: {
                return this.counter;
            }
            case COUNTER: {
                return this.statsHolder.get();
            }
            case METER: {
                return this.meterSum + this.meterSumRef.get();
            }
            case GAUGE: {
                return 0L;
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public void inc() {
        this.statsHolder.getAndIncrement();
    }

    @Override
    public void dec() {
        this.statsHolder.getAndDecrement();
    }

    @Override
    public void inc(long n) {
        this.statsHolder.getAndAdd(n);
    }

    @Override
    public void dec(long n) {
        this.statsHolder.getAndAdd(-n);
    }

    @Override
    public void mark() {
        this.inc();
        ++this.meterSum;
    }

    @Override
    public void mark(long n) {
        this.meterSumRef.getAndAdd(n);
        this.statsHolder.getAndAdd(n);
    }

    @Override
    public void update(long duration, TimeUnit unit) {
        ++this.counter;
        this.statsHolder.getAndAdd(unit.toMillis(duration));
    }

    @Override
    public TimerStats.Context time() {
        return new SimpleContext(this);
    }

    @Override
    public void update(long value) {
        ++this.counter;
        this.statsHolder.getAndAdd(value);
    }

    @Override
    public T getValue() {
        return this.value;
    }

    public static enum Type {
        COUNTER,
        METER,
        TIMER,
        HISTOGRAM,
        GAUGE;

    }

    private static final class SimpleContext
    implements TimerStats.Context {
        private final TimerStats timer;
        private final long startTime;

        private SimpleContext(TimerStats timer) {
            this.timer = timer;
            this.startTime = System.nanoTime();
        }

        @Override
        public long stop() {
            long elapsed = System.nanoTime() - this.startTime;
            this.timer.update(elapsed, TimeUnit.NANOSECONDS);
            return elapsed;
        }

        @Override
        public void close() {
            this.stop();
        }
    }
}

