/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.gfx;

public class GFXDecorationInfo {
    public static final int DECORATE_TYPE = 15;
    public static final int DECORATE_UNKNOWN = 0;
    public static final int DECORATE_NONE = 1;
    public static final int DECORATE_ALL = 2;
    public static final int DECORATE_WORD = 3;
    public static final int DECORATE_COUNT = 240;
    public static final int DECORATE_SINGLE = 16;
    public static final int DECORATE_DOUBLE = 32;
    public static final GFXDecorationInfo decorateNone = new GFXDecorationInfo(0, 1);
    public static final GFXDecorationInfo decorateSingleWord = new GFXDecorationInfo(1, 3);
    public static final GFXDecorationInfo decorateSingleAll = new GFXDecorationInfo(1, 2);
    public static final GFXDecorationInfo decorateDoubleWord = new GFXDecorationInfo(2, 3);
    public static final GFXDecorationInfo decorateDoubleAll = new GFXDecorationInfo(2, 2);
    public final int mType;
    public final int mCount;

    public GFXDecorationInfo(int count, int type) {
        this.mType = type;
        this.mCount = count;
    }

    public static GFXDecorationInfo extractDecoration(int nDecoration) {
        int nType = nDecoration & 0xF;
        int nCount = 0;
        switch (nDecoration & 0xF0) {
            case 16: {
                nCount = 1;
                break;
            }
            case 32: {
                nCount = 2;
            }
        }
        if (nType == 1 || nCount == 0) {
            return decorateNone;
        }
        if (nCount == 1) {
            return nType == 3 ? decorateSingleWord : decorateSingleAll;
        }
        return nType == 3 ? decorateDoubleWord : decorateDoubleAll;
    }
}

