/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.scripthandler.formcalc;

import com.adobe.xfa.AppModel;
import com.adobe.xfa.Arg;
import com.adobe.xfa.DependencyTracker;
import com.adobe.xfa.Node;
import com.adobe.xfa.Obj;
import com.adobe.xfa.SOMParser;
import com.adobe.xfa.ScriptDebugger;
import com.adobe.xfa.ScriptHandler;
import com.adobe.xfa.formcalc.CalcException;
import com.adobe.xfa.formcalc.CalcParser;
import com.adobe.xfa.formcalc.CalcSymbol;
import com.adobe.xfa.formcalc.DebugHost;
import com.adobe.xfa.formcalc.Frame;
import com.adobe.xfa.formcalc.FrameTable;
import com.adobe.xfa.formcalc.ProtocolHost;
import com.adobe.xfa.formcalc.ScriptHost;
import com.adobe.xfa.ut.ExFull;
import com.adobe.xfa.ut.IntegerHolder;
import com.adobe.xfa.ut.MsgFormat;
import com.adobe.xfa.ut.MsgFormatPos;
import com.adobe.xfa.ut.ResId;
import com.adobe.xfa.ut.ResourceLoader;
import com.adobe.xfa.ut.StringUtils;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.StringTokenizer;

public class FormCalcScriptHandler
extends ScriptHandler {
    private String msReturnMessage;
    private FormCalcParser moParser = null;
    private final AppModel moAppModel;
    private boolean mbFatalError;

    public FormCalcScriptHandler(AppModel oAppModel) {
        this(oAppModel, null);
    }

    public FormCalcScriptHandler(AppModel oAppModel, ScriptDebugger oScriptDebugger) {
        super(oScriptDebugger);
        this.moAppModel = oAppModel;
        this.mbFatalError = true;
    }

    @Override
    public void executeOrSyntaxCheck(String script, Arg returnCode, int eReason, boolean bSyntaxCheckOnly) {
        if (this.moParser == null) {
            this.moParser = new FormCalcParser(this.moAppModel, this);
        }
        this.mbFatalError = true;
        this.msReturnMessage = "";
        int nScriptID = -1;
        ScriptDebugger oDebugger = this.getDebugger();
        if (oDebugger != null) {
            nScriptID = oDebugger.getScriptID((ScriptHandler)this, script, this.moAppModel.getContext(), eReason);
        }
        this.msReturnMessage = this.moParser.execute(script, null, nScriptID, returnCode, false);
        if (oDebugger != null) {
            oDebugger.didExecuteScript(nScriptID, returnCode);
        }
    }

    @Override
    public void syntaxCheck(String script) {
        if (this.moParser == null) {
            this.moParser = new FormCalcParser(this.moAppModel, this);
        }
        this.mbFatalError = true;
        this.msReturnMessage = "";
        int nScriptID = -1;
        Arg returnCode = null;
        this.msReturnMessage = this.moParser.execute(script, "", nScriptID, returnCode, true);
    }

    @Override
    public String languageName() {
        return "formcalc";
    }

    public boolean getCancelOrTimeState() {
        return false;
    }

    @Override
    public void setOption(String sOptionName, String sOptionValue) {
        if (this.moParser == null) {
            this.moParser = new FormCalcParser(this.moAppModel, this);
        }
        if (sOptionName.equals("DupsMode")) {
            this.moParser.setDupsMode((sOptionValue.length() >= 1 ? sOptionValue.charAt(0) : (char)'\u0000') == '1');
        }
    }

    @Override
    public String getOption(String sOptionName) {
        if (sOptionName.equals("DupsMode") && this.moParser != null) {
            return this.moParser.getDupsMode() ? "1" : "0";
        }
        return "";
    }

    @Override
    public FormCalcScriptHandler clone() {
        FormCalcScriptHandler oNewScriptHandler = new FormCalcScriptHandler(this.moAppModel, this.getDebugger());
        oNewScriptHandler.moParser = this.moParser;
        oNewScriptHandler.msReturnMessage = this.msReturnMessage;
        return oNewScriptHandler;
    }

    @Override
    public boolean wasFatalError() {
        return this.mbFatalError;
    }

    void setFatalError(boolean bFatal) {
        this.mbFatalError = bFatal;
    }

    @Override
    public boolean debugCommand(int eCmd) {
        switch (eCmd) {
            case 0: {
                this.moParser.command(this.getParser(true), 0);
                return true;
            }
            case 1: {
                this.moParser.command(this.getParser(true), 1);
                return true;
            }
            case 2: {
                this.moParser.command(this.getParser(true), 2);
                return true;
            }
            case 3: {
                this.moParser.command(this.getParser(true), 1);
                return true;
            }
            case 4: {
                this.moParser.command(this.getParser(true), 3);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean debugBreakPoint(int nScriptID, int nLine, int eSetType) {
        if (eSetType == 0 || eSetType == 1) {
            return this.moParser.breakPoint(this.getParser(true), nScriptID, nLine, eSetType == 0);
        }
        return false;
    }

    @Override
    public boolean debugGetStack(List<String> oStack) {
        oStack.clear();
        String sStackTrace = this.moParser.getStackTrace(this.getParser(true));
        StringTokenizer sToke = new StringTokenizer(sStackTrace, "\n");
        while (sToke.hasMoreTokens()) {
            String sEntry = sToke.nextToken();
            oStack.add(sEntry);
        }
        return true;
    }

    @Override
    public boolean debugGetVariables(List<String> oVarNames, List<Arg> oVarValues) {
        oVarNames.clear();
        oVarValues.clear();
        ArrayList<CalcSymbol> oCalcSymbols = new ArrayList<CalcSymbol>();
        this.moParser.getVariables(this.getParser(true), oVarNames, oCalcSymbols);
        for (int i = 0; i < oVarNames.size(); ++i) {
            Arg oArg = new Arg();
            FormCalcScriptHandler.FCValToXFAArg((CalcSymbol)oCalcSymbols.get(i), oArg);
            oVarValues.add(oArg);
        }
        return true;
    }

    @Override
    protected int debugFeatures() {
        int nFeatures = 30;
        return nFeatures;
    }

    static void FCValToXFAArg(CalcSymbol oFCVal, Arg oArgVal) {
        switch (oFCVal.getType()) {
            case 3: {
                oArgVal.setDouble(new Double(oFCVal.getNumericValue()));
                break;
            }
            case 6: {
                oArgVal.setObject(oFCVal.getObjValue());
                break;
            }
            case 2: 
            case 5: {
                oArgVal.setString(oFCVal.getStringValue());
                break;
            }
            case 1: {
                oArgVal.setNull();
                break;
            }
            default: {
                oArgVal.empty();
            }
        }
    }

    static int FCResIdToErrorCode(int nErrorResId) {
        if (nErrorResId == ResId.FC_ERR_SYNTAX) {
            return 8;
        }
        if (nErrorResId == ResId.FC_ERR_LOOP) {
            return 10;
        }
        if (nErrorResId == ResId.FC_ERR_FUNC_USED) {
            return 100;
        }
        if (nErrorResId == ResId.FC_ERR_FUNC_UNKN) {
            return 101;
        }
        return 8;
    }

    protected String getReturnMessage() {
        return this.msReturnMessage;
    }

    protected CalcParser getParser(boolean bForceCreation) {
        if (this.moParser == null) {
            if (bForceCreation) {
                this.moParser = new FormCalcParser(this.moAppModel, this);
            } else {
                return null;
            }
        }
        return this.moParser;
    }

    public static class FormCalcParser
    extends CalcParser
    implements ScriptHost,
    ProtocolHost,
    DebugHost {
        private final CalcParser moParser;
        private final AppModel moAppModel;
        private final FormCalcScriptHandler moScriptHandler;

        public FormCalcParser(AppModel oAppModel, FormCalcScriptHandler oScriptHandler) {
            this.moAppModel = oAppModel;
            this.moScriptHandler = oScriptHandler;
            this.moParser = new CalcParser();
            this.moParser.setScriptHost(this);
            this.moParser.setProtocolHost(this);
            this.moParser.setDebugHost(this);
            EnumSet<CalcParser.LegacyVersion> oLegacyScripting = EnumSet.noneOf(CalcParser.LegacyVersion.class);
            if (this.moAppModel.getLegacySetting(AppModel.XFA_LEGACY_V30_SCRIPTING)) {
                oLegacyScripting.add(CalcParser.LegacyVersion.V30_SCRIPTING);
            }
            if (this.moAppModel.getLegacySetting(AppModel.XFA_LEGACY_V32_SCRIPTING)) {
                oLegacyScripting.add(CalcParser.LegacyVersion.V32_SCRIPTING);
            }
            if (oLegacyScripting.size() == 0) {
                oLegacyScripting.add(CalcParser.LegacyVersion.CUR_SCRIPTING);
            }
            this.moParser.setLegacyScripting(oLegacyScripting);
        }

        String execute(String script, String locale, int nScriptID, Arg returnCode, boolean bSyntaxCheckOnly) {
            CalcSymbol oResult;
            boolean bSave;
            boolean bSuccess;
            ScriptDebugger oDebugger;
            CalcParser oCalcParser = this.moParser;
            if (this.moParser.inUse()) {
                oCalcParser = (CalcParser)this.moParser.clone();
            }
            oCalcParser.putScript(script);
            oCalcParser.setScriptID(nScriptID);
            if (!StringUtils.isEmpty(locale)) {
                oCalcParser.setLocale(locale);
            }
            if ((oDebugger = this.moScriptHandler.getDebugger()) != null) {
                oCalcParser.debugEnable(true);
            }
            if ((bSuccess = oCalcParser.compile(bSave = !bSyntaxCheckOnly, bSave, bSyntaxCheckOnly)) && !bSyntaxCheckOnly) {
                if (oDebugger != null) {
                    oDebugger.willExecuteScript(nScriptID);
                }
                oCalcParser.evaluate(true, true);
            }
            if ((oResult = oCalcParser.getCalcResult()) == null) {
                return "";
            }
            String sReturnMessage = null;
            if (oResult.getType() == 0) {
                String sNoExpr;
                IntegerHolder oErrorLine = new IntegerHolder();
                IntegerHolder oErrorCode = new IntegerHolder();
                String sErr = oResult.getErrorValue(oErrorLine, oErrorCode);
                if (sErr.equals(sNoExpr = ResourceLoader.loadResource(ResId.FC_ERR_NO_EXPR))) {
                    returnCode.empty();
                    return sReturnMessage;
                }
                MsgFormat oFmt = new MsgFormat(ResId.ScriptHandlerError, sErr);
                if (bSyntaxCheckOnly) {
                    throw new ScriptHandler.ScriptException(oFmt, oErrorLine.value, FormCalcScriptHandler.FCResIdToErrorCode(oErrorCode.value));
                }
                throw new ExFull(oFmt);
            }
            if (oResult.getType() == 10) {
                sReturnMessage = oResult.getStringValue();
                returnCode.empty();
                return sReturnMessage;
            }
            FormCalcScriptHandler.FCValToXFAArg(oResult, returnCode);
            return sReturnMessage;
        }

        @Override
        public Obj getItem(String sItem, Obj[] oObj) {
            try {
                DependencyTracker oDependencyTracker = this.moAppModel.dependencyTracker();
                SOMParser oParser = new SOMParser(oDependencyTracker);
                ArrayList<SOMParser.SomResultInfo> oResultList = new ArrayList<SOMParser.SomResultInfo>();
                int resultListLength = 0;
                if (oParser.resolve(this.moAppModel.getContext(), sItem, oObj, oResultList, null)) {
                    resultListLength = oResultList.size();
                }
                if (resultListLength == 0) {
                    this.moScriptHandler.setFatalError(false);
                    MsgFormatPos sFmt = new MsgFormatPos(ResId.FC_ERR_ACCESSOR);
                    sFmt.format(sItem);
                    CalcSymbol calcsymbol = new CalcSymbol(sFmt.toString(), true, 0, 0);
                    throw new CalcException(calcsymbol);
                }
                Arg arg = ((SOMParser.SomResultInfo)oResultList.get((int)0)).value;
                return arg.getObject();
            }
            catch (ExFull oError) {
                CalcSymbol calcsymbol = new CalcSymbol(oError.toString(), true, 0, 0);
                throw new CalcException(calcsymbol);
            }
        }

        @Override
        public CalcSymbol[] getItemValue(String sItem, Obj[] oObj) {
            try {
                DependencyTracker oDependencyTracker = this.moAppModel.dependencyTracker();
                SOMParser oParser = new SOMParser(oDependencyTracker);
                ArrayList<SOMParser.SomResultInfo> oResultList = new ArrayList<SOMParser.SomResultInfo>();
                int resultListLength = 0;
                if (oParser.resolve(this.moAppModel.getContext(), sItem, oObj, oResultList, null)) {
                    resultListLength = oResultList.size();
                }
                if (resultListLength == 0) {
                    this.moScriptHandler.setFatalError(false);
                    MsgFormatPos sFmt = new MsgFormatPos(ResId.FC_ERR_ACCESSOR);
                    sFmt.format(sItem);
                    CalcSymbol calcsymbol = new CalcSymbol(sFmt.toString(), true, 0, 0);
                    throw new CalcException(calcsymbol);
                }
                CalcSymbol[] oSym = new CalcSymbol[resultListLength];
                for (int i = 0; i < resultListLength; ++i) {
                    ScriptDebugger oDebugger;
                    Obj obj = ((SOMParser.SomResultInfo)oResultList.get((int)i)).object;
                    Arg arg = ((SOMParser.SomResultInfo)oResultList.get((int)i)).value;
                    boolean bNullValue = false;
                    if (arg.getArgType() == 7) {
                        Obj o = arg.getObject();
                        boolean bl = bNullValue = !o.getScriptProperty(arg, "", oDependencyTracker, true, true);
                    }
                    if ((oDebugger = this.moScriptHandler.getDebugger()) != null) {
                        oDebugger.resolvedValue(sItem, arg);
                    }
                    if (arg.getArgType() == 8) {
                        throw arg.getException();
                    }
                    oSym[i] = bNullValue ? new CalcSymbol() : (arg.getArgType() == 6 ? new CalcSymbol(arg.getString()) : (arg.getArgType() == 5 ? new CalcSymbol(arg.getDouble(false)) : (arg.getArgType() == 4 ? new CalcSymbol(arg.getInteger().doubleValue()) : (arg.getArgType() == 3 ? new CalcSymbol(arg.getBool() != false ? 1.0 : 0.0) : (arg.getArgType() == 7 ? new CalcSymbol(obj, null) : new CalcSymbol())))));
                }
                return oSym;
            }
            catch (ExFull oError) {
                CalcSymbol calcsymbol = new CalcSymbol(oError.toString(), true, 0, 0);
                throw new CalcException(calcsymbol);
            }
        }

        @Override
        public int putItemValue(String sItem, Obj[] oObj, CalcSymbol oValue) {
            try {
                Node oNode;
                String sValue = null;
                if (oValue.getType() != 1) {
                    sValue = oValue.getStringValue();
                }
                if (!(oNode = this.moAppModel.getContext()).performSOMAssignment(sItem, sValue, oObj)) {
                    this.moScriptHandler.setFatalError(false);
                    MsgFormatPos sFmt = new MsgFormatPos(ResId.FC_ERR_ACCESSOR);
                    sFmt.format(sItem);
                    CalcSymbol calcsymbol = new CalcSymbol(sFmt.toString(), true, 0, 0);
                    throw new CalcException(calcsymbol);
                }
                return 0;
            }
            catch (ExFull oError) {
                CalcSymbol calcsymbol = new CalcSymbol(oError.toString(), true, 0, 0);
                throw new CalcException(calcsymbol);
            }
        }

        @Override
        public int putItem(Obj[] oObj, CalcSymbol oValue) {
            return 0;
        }

        @Override
        public CalcSymbol getUrl(String sUrl) throws CalcException {
            MsgFormatPos sFmt = new MsgFormatPos(ResId.PROTOCOL_ERR_SYS);
            sFmt.format(sUrl);
            CalcSymbol oErr = new CalcSymbol(sFmt.toString(), true, 0, 0);
            throw new CalcException(oErr);
        }

        @Override
        public CalcSymbol putUrl(String sUrl, String sData, String sEnc) throws CalcException {
            MsgFormatPos sFmt = new MsgFormatPos(ResId.PROTOCOL_ERR_SYS);
            sFmt.format(sUrl);
            CalcSymbol oErr = new CalcSymbol(sFmt.toString(), true, 0, 0);
            throw new CalcException(oErr);
        }

        @Override
        public CalcSymbol postUrl(String sUrl, String sSoapHeader, String sData, String sContentType, String sEnc) throws CalcException {
            MsgFormatPos sFmt = new MsgFormatPos(ResId.PROTOCOL_ERR_SYS);
            sFmt.format(sUrl);
            CalcSymbol oErr = new CalcSymbol(sFmt.toString(), true, 0, 0);
            throw new CalcException(oErr);
        }

        @Override
        public int stopped(int nScriptID, int nLine) {
            ScriptDebugger oDebugger = this.moScriptHandler.getDebugger();
            if (oDebugger != null) {
                oDebugger.stopped(nScriptID, nLine);
            }
            return -1;
        }

        @Override
        public void poll() {
            ScriptDebugger oDebugger = this.moScriptHandler.getDebugger();
            if (oDebugger != null) {
                oDebugger.poll(this.moScriptHandler);
            }
        }

        @Override
        public boolean breakPoint(CalcParser oParser, int nScriptID, int nLine, boolean bSet) {
            return oParser.moCode.debugBreakPoint(nScriptID, nLine, bSet);
        }

        @Override
        public boolean command(CalcParser oParser, int eCmd) {
            return oParser.moCode.debugCommand(oParser, eCmd);
        }

        @Override
        public String getStackTrace(CalcParser oParser) {
            return oParser.moFrame.getStackTrace(oParser.mStack);
        }

        @Override
        public void getVariables(CalcParser oParser, List<String> oNames, List<CalcSymbol> oValues) {
            ArrayList<CalcSymbol> oSymbols = new ArrayList<CalcSymbol>();
            oParser.moData.enumerate(oParser.moScope, oSymbols);
            Frame oTopFrame = null;
            CalcSymbol oFuncSym = null;
            String sFuncPrefix = "";
            FrameTable oFrameTable = oParser.moFrame;
            if (oFrameTable.getDepth() > 0) {
                oTopFrame = oFrameTable.peek();
                oFuncSym = oTopFrame.getFuncSym();
                sFuncPrefix = oFuncSym.getName();
                sFuncPrefix = sFuncPrefix + '`';
            }
            for (CalcSymbol oSym : oSymbols) {
                String sName = oSym.getName();
                if (oSym.getType() == 7) {
                    if (oFuncSym == null || !sFuncPrefix.startsWith(sName)) continue;
                    sName = sName.substring(sFuncPrefix.length());
                    int nStackAddr = oTopFrame.getStackAddr();
                    int nArgCount = oTopFrame.getArgCount();
                    int nStackIdx = oSym.getIdxValue();
                    oSym = oParser.mStack.peek(nStackAddr - nArgCount + nStackIdx);
                }
                oNames.add(sName);
                oValues.add(oSym);
            }
        }

        @Override
        public boolean cancelActionOccured() {
            return this.moScriptHandler.getCancelOrTimeState();
        }
    }
}

