/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.contentsync.handler;

import com.day.cq.contentsync.handler.ContentUpdateHandler;
import com.day.cq.contentsync.handler.util.RequestResponseFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HashableContentUpdateHandler
implements ContentUpdateHandler {
    private static final String NT_CONTENT_SYNC_HASH = "cq:ContentSyncHash";
    public static final String HASH_PROPERTY = "md5";
    private static final Logger log = LoggerFactory.getLogger(HashableContentUpdateHandler.class);

    @Deprecated
    protected String getHash(RequestResponseFactory factory, HttpServletResponse response) throws RepositoryException {
        throw new UnsupportedOperationException("getHash is no longer supported");
    }

    @Deprecated
    protected String getHash(byte[] bytes) throws RepositoryException {
        throw new UnsupportedOperationException("getHash is no longer supported");
    }

    protected boolean hashMatches(Session session, String cachePath, String hash) throws RepositoryException {
        String hashPath = cachePath + "/" + "jcr:content" + "/" + HASH_PROPERTY;
        return session.propertyExists(hashPath) && session.getProperty(hashPath).getString().equals(hash);
    }

    protected void writeHash(Node node, String hash) throws RepositoryException {
        node.addMixin(NT_CONTENT_SYNC_HASH);
        node.setProperty(HASH_PROPERTY, hash);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InputStream writeHashAndGetStream(InputStream in, Node node) throws IOException, RepositoryException, NoSuchAlgorithmException {
        File tempDir = File.createTempFile("contentsync", ".tmp").getParentFile();
        File tempFile = new File(tempDir, "stream");
        try {
            FileOutputStream out = new FileOutputStream(tempFile);
            try {
                int len;
                byte[] buffer = new byte[1024];
                while ((len = in.read(buffer)) != -1) {
                    out.write(buffer, 0, len);
                }
            }
            finally {
                IOUtils.closeQuietly(in);
                IOUtils.closeQuietly(out);
            }
            FileInputStream inputStreamForHash = null;
            try {
                inputStreamForHash = new FileInputStream(tempFile);
                String hash = DigestUtils.sha256Hex(inputStreamForHash);
                this.writeHash(node, hash);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStreamForHash);
                throw throwable;
            }
            IOUtils.closeQuietly(inputStreamForHash);
            FileInputStream fileInputStream = new FileInputStream(tempFile);
            return fileInputStream;
        }
        finally {
            try {
                FileUtils.deleteDirectory(tempDir);
            }
            catch (Exception e) {
                log.warn("Memory leak detected. Please remove manually: {}", (Object)tempDir);
            }
        }
    }
}

