/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.commons.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DamMimeUtil {
    private static final Logger log = LoggerFactory.getLogger(DamMimeUtil.class);
    private static boolean allowAllMime = true;
    private static boolean detectMimeFromContent = false;
    private static final List<String> supportedMimeTypes = new ArrayList<String>();

    public static void setAllowAllMimeAttribute(boolean val) {
        allowAllMime = val;
    }

    public static void setDetectMimeFromContent(boolean val) {
        detectMimeFromContent = val;
    }

    public static void setSupportedMimeTypes(String[] mimeList) {
        supportedMimeTypes.clear();
        supportedMimeTypes.addAll(Arrays.asList(mimeList));
    }

    public static boolean isAllowedMimeType(String nameMimeType, String contentMimeType) {
        if (StringUtils.isEmpty(contentMimeType)) {
            contentMimeType = nameMimeType;
        }
        log.trace("Detected mimeType: {}", (Object)contentMimeType);
        if (allowAllMime) {
            log.trace("upload allowed");
            return true;
        }
        if (StringUtils.isEmpty(contentMimeType)) {
            return false;
        }
        for (String regEx : supportedMimeTypes) {
            if (!contentMimeType.matches(regEx)) continue;
            log.trace("upload allowed");
            return true;
        }
        log.trace("upload NOT allowed");
        return false;
    }

    public static boolean getDetectMimeFromContent() {
        return detectMimeFromContent;
    }
}

