/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigHelper {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigHelper.class);

    public static int getSystemPropertyAsInt(String name, int defaultValue) {
        int result = Integer.getInteger(name, defaultValue);
        LOG.info("Config {}={}", (Object)name, (Object)result);
        return result;
    }

    public static String getSystemPropertyAsString(String name, String defaultValue) {
        String result = System.getProperty(name, defaultValue);
        LOG.info("Config {}={}", (Object)name, (Object)result);
        return result;
    }

    public static boolean getSystemPropertyAsBoolean(String name, boolean defaultValue) {
        String sysPropValue = System.getProperty(name);
        boolean value = sysPropValue == null ? defaultValue : Boolean.parseBoolean(sysPropValue);
        LOG.info("Config {}={}", (Object)name, (Object)value);
        return value;
    }

    public static List<String> getSystemPropertyAsStringList(String name, String defaultValue, char separator) {
        String result = System.getProperty(name, defaultValue);
        List<String> parts = ConfigHelper.splitString(result, separator);
        LOG.info("Config {}={}", (Object)name, (Object)parts);
        return parts;
    }

    private static List<String> splitString(String str, char separator) {
        return str.isBlank() ? List.of() : Arrays.stream(StringUtils.split(str, separator)).map(String::trim).collect(Collectors.toList());
    }
}

