/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.apache.jackrabbit.guava.common.collect.TreeTraverser;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.jmx.Name;
import org.apache.jackrabbit.oak.commons.IOUtils;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.commons.collections.IterableUtils;
import org.apache.jackrabbit.oak.commons.conditions.Validate;
import org.apache.jackrabbit.oak.commons.jmx.AnnotatedStandardMBean;
import org.apache.jackrabbit.oak.commons.json.JsopBuilder;
import org.apache.jackrabbit.oak.commons.time.Stopwatch;
import org.apache.jackrabbit.oak.json.JsopDiff;
import org.apache.jackrabbit.oak.plugins.index.IndexPathService;
import org.apache.jackrabbit.oak.plugins.index.lucene.IndexTracker;
import org.apache.jackrabbit.oak.plugins.index.lucene.LuceneIndexDefinition;
import org.apache.jackrabbit.oak.plugins.index.lucene.LuceneIndexMBean;
import org.apache.jackrabbit.oak.plugins.index.lucene.LuceneIndexNode;
import org.apache.jackrabbit.oak.plugins.index.lucene.TermFactory;
import org.apache.jackrabbit.oak.plugins.index.lucene.directory.DirectoryUtils;
import org.apache.jackrabbit.oak.plugins.index.lucene.directory.IndexConsistencyChecker;
import org.apache.jackrabbit.oak.plugins.index.lucene.property.HybridPropertyIndexInfo;
import org.apache.jackrabbit.oak.plugins.index.lucene.property.PropertyIndexCleaner;
import org.apache.jackrabbit.oak.plugins.index.lucene.reader.LuceneIndexReader;
import org.apache.jackrabbit.oak.plugins.index.lucene.util.PathStoredFieldVisitor;
import org.apache.jackrabbit.oak.plugins.index.search.BadIndexTracker;
import org.apache.jackrabbit.oak.plugins.index.search.util.NodeStateCloner;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateUtils;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.NumericUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LuceneIndexMBeanImpl
extends AnnotatedStandardMBean
implements LuceneIndexMBean {
    private static final boolean LOAD_INDEX_FOR_STATS = Boolean.parseBoolean(System.getProperty("oak.lucene.LoadIndexForStats", "false"));
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final IndexTracker indexTracker;
    private final NodeStore nodeStore;
    private final IndexPathService indexPathService;
    private final File workDir;
    private final PropertyIndexCleaner propertyIndexCleaner;

    public LuceneIndexMBeanImpl(IndexTracker indexTracker, NodeStore nodeStore, IndexPathService indexPathService, File workDir, @Nullable PropertyIndexCleaner cleaner) {
        super(LuceneIndexMBean.class);
        this.indexTracker = Objects.requireNonNull(indexTracker);
        this.nodeStore = Objects.requireNonNull(nodeStore);
        this.indexPathService = indexPathService;
        this.workDir = Objects.requireNonNull(workDir);
        this.propertyIndexCleaner = cleaner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TabularData getIndexStats() throws IOException {
        TabularDataSupport tds;
        try {
            TabularType tt = new TabularType(LuceneIndexMBeanImpl.class.getName(), "Lucene Index Stats", IndexStats.TYPE, new String[]{"path"});
            tds = new TabularDataSupport(tt);
            Set<String> indexes = this.indexTracker.getIndexNodePaths();
            for (String path : indexes) {
                LuceneIndexNode indexNode = null;
                try {
                    indexNode = this.indexTracker.acquireIndexNode(path);
                    if (indexNode == null) continue;
                    IndexStats stats = new IndexStats(path, indexNode);
                    tds.put(stats.toCompositeData());
                }
                finally {
                    if (indexNode == null) continue;
                    indexNode.release();
                }
            }
        }
        catch (OpenDataException e) {
            throw new IllegalStateException(e);
        }
        return tds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IndexStats getIndexStats(String path) throws IOException {
        LuceneIndexNode indexNode = null;
        try {
            indexNode = this.indexTracker.acquireIndexNode(path);
            if (indexNode != null) {
                IndexStats indexStats = new IndexStats(path, indexNode);
                return indexStats;
            }
        }
        finally {
            if (indexNode != null) {
                indexNode.release();
            }
        }
        throw new IOException("could not fetch stats for index at path " + path);
    }

    @Override
    public TabularData getBadIndexStats() {
        TabularDataSupport tds;
        try {
            TabularType tt = new TabularType(LuceneIndexMBeanImpl.class.getName(), "Lucene Bad Index Stats", BadIndexStats.TYPE, new String[]{"path"});
            tds = new TabularDataSupport(tt);
            Set indexes = this.indexTracker.getBadIndexTracker().getIndexPaths();
            for (String path : indexes) {
                BadIndexTracker.BadIndexInfo info = this.indexTracker.getBadIndexTracker().getInfo(path);
                if (info == null) continue;
                BadIndexStats stats = new BadIndexStats(info);
                tds.put(stats.toCompositeData());
            }
        }
        catch (OpenDataException e) {
            throw new IllegalStateException(e);
        }
        return tds;
    }

    @Override
    public TabularData getBadPersistedIndexStats() {
        TabularDataSupport tds;
        try {
            TabularType tt = new TabularType(LuceneIndexMBeanImpl.class.getName(), "Lucene Bad Persisted Index Stats", BadIndexStats.TYPE, new String[]{"path"});
            tds = new TabularDataSupport(tt);
            Set indexes = this.indexTracker.getBadIndexTracker().getBadPersistedIndexPaths();
            for (String path : indexes) {
                BadIndexTracker.BadIndexInfo info = this.indexTracker.getBadIndexTracker().getPersistedIndexInfo(path);
                if (info == null) continue;
                BadIndexStats stats = new BadIndexStats(info);
                tds.put(stats.toCompositeData());
            }
        }
        catch (OpenDataException e) {
            throw new IllegalStateException(e);
        }
        return tds;
    }

    @Override
    public boolean isFailing() {
        return this.indexTracker.getBadIndexTracker().hasBadIndexes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getIndexedPaths(String indexPath, int maxLevel, int maxPathCount) throws IOException {
        LuceneIndexNode indexNode = null;
        try {
            if (indexPath == null) {
                indexPath = "/";
            }
            if ((indexNode = this.indexTracker.acquireIndexNode(indexPath)) != null) {
                LuceneIndexDefinition defn = indexNode.getDefinition();
                if (!defn.evaluatePathRestrictions()) {
                    String msg = String.format("Index at [%s] does not have [%s] enabled. So paths statistics cannot be determined for this index", indexPath, "evaluatePathRestrictions");
                    String[] stringArray = LuceneIndexMBeanImpl.createMsg(msg);
                    return stringArray;
                }
                IndexSearcher searcher = indexNode.getSearcher();
                String[] stringArray = LuceneIndexMBeanImpl.determineIndexedPaths(searcher, maxLevel, maxPathCount);
                return stringArray;
            }
        }
        finally {
            if (indexNode != null) {
                indexNode.release();
            }
        }
        return new String[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getFieldInfo(String indexPath) throws IOException {
        TreeSet<String> indexes = new TreeSet<String>();
        if (indexPath == null || indexPath.isEmpty()) {
            indexes.addAll(this.indexTracker.getIndexNodePaths());
        } else {
            indexes.add(indexPath);
        }
        ArrayList<String> list = new ArrayList<String>();
        for (String path : indexes) {
            LuceneIndexNode indexNode = null;
            try {
                indexNode = this.indexTracker.acquireIndexNode(path);
                if (indexNode == null) continue;
                IndexSearcher searcher = indexNode.getSearcher();
                list.addAll(LuceneIndexMBeanImpl.getFieldInfo(path, searcher));
            }
            finally {
                if (indexNode == null) continue;
                indexNode.release();
            }
        }
        return list.toArray(new String[0]);
    }

    @Override
    public String[] getFieldTermsInfo(String indexPath, String field, int max) throws IOException {
        return this.getFieldTermPrefixInfo(indexPath, field, max, null, null);
    }

    @Override
    public String[] getFieldTermInfo(String indexPath, String field, String term) throws IOException {
        return this.getFieldTermPrefixInfo(indexPath, field, Integer.MAX_VALUE, term, null);
    }

    @Override
    public String[] getFieldTermsInfo(String indexPath, String field, String fieldType, int max) throws IOException {
        return this.getFieldTermPrefixInfo(indexPath, field, max, null, fieldType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getFieldTermPrefixInfo(String indexPath, String field, int max, String term, String type) throws IOException {
        TreeSet<String> indexes = new TreeSet<String>();
        if (indexPath == null || indexPath.isEmpty()) {
            indexes.addAll(this.indexTracker.getIndexNodePaths());
        } else {
            indexes.add(indexPath);
        }
        ArrayList<String> list = new ArrayList<String>();
        for (String path : indexes) {
            LuceneIndexNode indexNode = null;
            try {
                indexNode = this.indexTracker.acquireIndexNode(path);
                if (indexNode == null) continue;
                IndexSearcher searcher = indexNode.getSearcher();
                list.addAll(LuceneIndexMBeanImpl.getFieldTerms(path, field, max, term, searcher, type));
            }
            finally {
                if (indexNode == null) continue;
                indexNode.release();
            }
        }
        return list.toArray(new String[0]);
    }

    @Override
    public String getStoredIndexDefinition(@Name(value="indexPath") String indexPath) {
        LuceneIndexDefinition defn = this.indexTracker.getIndexDefinition(indexPath);
        NodeState state = defn != null ? defn.getDefinitionNodeState() : NodeStateUtils.getNode(this.indexTracker.getRoot(), indexPath + "/:index-definition");
        if (state.exists()) {
            return NodeStateUtils.toString(state);
        }
        return "No index found at given path";
    }

    @Override
    public String diffStoredIndexDefinition(@Name(value="indexPath") String indexPath) {
        NodeState stored = NodeStateUtils.getNode(this.indexTracker.getRoot(), indexPath + "/:index-definition");
        NodeState current = NodeStateUtils.getNode(this.indexTracker.getRoot(), indexPath);
        if (stored.exists()) {
            current = NodeStateCloner.cloneVisibleState((NodeState)current);
            JsopDiff diff = new JsopDiff();
            current.compareAgainstBaseState(stored, diff);
            return JsopBuilder.prettyPrint(diff.toString());
        }
        return "No stored index definition found at given path";
    }

    @Override
    public String checkConsistency(String indexPath, boolean fullCheck) throws IOException {
        NodeState indexState = NodeStateUtils.getNode(this.nodeStore.getRoot(), indexPath);
        Validate.checkArgument((boolean)indexState.exists(), (String)"No node exist at path [%s]", (Object[])new Object[]{indexPath});
        return this.getConsistencyCheckResult(indexPath, fullCheck).toString();
    }

    @Override
    public String[] checkAndReportConsistencyOfAllIndexes(boolean fullCheck) throws IOException {
        Stopwatch watch = Stopwatch.createStarted();
        ArrayList<String> results = new ArrayList<String>();
        NodeState root = this.nodeStore.getRoot();
        for (String indexPath : this.indexPathService.getIndexPaths()) {
            NodeState idxState = NodeStateUtils.getNode(root, indexPath);
            if (!"lucene".equals(idxState.getString("type"))) continue;
            IndexConsistencyChecker.Result result = this.getConsistencyCheckResult(indexPath, fullCheck);
            String msg = "OK";
            if (!result.clean) {
                msg = "NOT OK";
            }
            results.add(String.format("%s : %s", indexPath, msg));
        }
        this.log.info("Checked index consistency in {}. Check result {}", (Object)watch, (Object)results);
        return (String[])IterableUtils.toArray(results, String.class);
    }

    @Override
    public boolean checkConsistencyOfAllIndexes(boolean fullCheck) throws IOException {
        Stopwatch watch = Stopwatch.createStarted();
        NodeState root = this.nodeStore.getRoot();
        boolean clean = true;
        for (String indexPath : this.indexPathService.getIndexPaths()) {
            NodeState idxState = NodeStateUtils.getNode(root, indexPath);
            if (!"lucene".equals(idxState.getString("type"))) continue;
            IndexConsistencyChecker.Result result = this.getConsistencyCheckResult(indexPath, fullCheck);
            if (result.clean) continue;
            clean = false;
            break;
        }
        this.log.info("Checked index consistency in {}. Check result {}", (Object)watch, (Object)clean);
        return clean;
    }

    @Override
    public String performPropertyIndexCleanup(String paths, int batchSize, int sleepPerBatch, int maxRemoveCount) throws CommitFailedException {
        Object result = "PropertyIndexCleaner not enabled";
        if (this.propertyIndexCleaner != null) {
            result = "Removed nodes: " + this.propertyIndexCleaner.performCleanup(paths, batchSize, sleepPerBatch, maxRemoveCount);
        }
        this.log.info("Explicit cleanup run done with result {}", result);
        return result;
    }

    @Override
    public String performPropertyIndexCleanup() throws CommitFailedException {
        String result = "PropertyIndexCleaner not enabled";
        if (this.propertyIndexCleaner != null) {
            result = this.propertyIndexCleaner.performCleanup(true).toString();
        }
        this.log.info("Explicit cleanup run done with result {}", (Object)result);
        return result;
    }

    @Override
    public String getHybridIndexInfo(String indexPath) {
        NodeState idx = NodeStateUtils.getNode(this.nodeStore.getRoot(), indexPath);
        return new HybridPropertyIndexInfo(idx).getInfoAsJson();
    }

    public String getSize(String indexPath) throws IOException {
        if (!LOAD_INDEX_FOR_STATS && !this.indexTracker.getIndexNodePaths().contains(indexPath)) {
            return "-1";
        }
        return String.valueOf(this.getIndexStats((String)indexPath).indexSize);
    }

    public String getDocCount(String indexPath) throws IOException {
        if (!LOAD_INDEX_FOR_STATS && !this.indexTracker.getIndexNodePaths().contains(indexPath)) {
            return "-1";
        }
        return String.valueOf(this.getIndexStats((String)indexPath).numDocs);
    }

    private IndexConsistencyChecker.Result getConsistencyCheckResult(String indexPath, boolean fullCheck) throws IOException {
        NodeState root = this.nodeStore.getRoot();
        IndexConsistencyChecker.Level level = fullCheck ? IndexConsistencyChecker.Level.FULL : IndexConsistencyChecker.Level.BLOBS_ONLY;
        IndexConsistencyChecker checker = new IndexConsistencyChecker(root, indexPath, this.workDir);
        return checker.check(level);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpIndexContent(String sourcePath, String destPath) throws IOException {
        LuceneIndexNode indexNode = null;
        try {
            if (sourcePath == null) {
                sourcePath = "/";
            }
            if ((indexNode = this.indexTracker.acquireIndexNode(sourcePath)) != null) {
                this.log.info("Dumping Lucene directory content for [{}] to [{}]", (Object)sourcePath, (Object)destPath);
                Directory source = LuceneIndexMBeanImpl.getDirectory(LuceneIndexMBeanImpl.getPrimaryReader(indexNode.getPrimaryReaders()));
                Objects.requireNonNull(source, "IndexSearcher not backed by DirectoryReader");
                FSDirectory dest = FSDirectory.open(new File(destPath));
                for (String file : source.listAll()) {
                    source.copy(dest, file, file, IOContext.DEFAULT);
                }
            }
        }
        finally {
            if (indexNode != null) {
                indexNode.release();
            }
        }
    }

    private static ArrayList<String> getFieldInfo(String path, IndexSearcher searcher) throws IOException {
        ArrayList<String> list = new ArrayList<String>();
        IndexReader reader = searcher.getIndexReader();
        Fields fields = MultiFields.getFields(reader);
        if (fields != null) {
            for (String f : fields) {
                list.add(path + " " + f + " " + reader.getDocCount(f));
            }
        }
        return list;
    }

    private static Function<BytesRef, String> getTypeHandler(String type) {
        if (type != null) {
            if (Long.TYPE.getName().equals(type) || Long.class.getName().equals(type)) {
                return bytesRef -> String.valueOf(NumericUtils.prefixCodedToLong(bytesRef));
            }
            if (Integer.TYPE.getName().equals(type) || Integer.class.getName().equals(type)) {
                return bytesRef -> String.valueOf(NumericUtils.prefixCodedToInt(bytesRef));
            }
        }
        return BytesRef::utf8ToString;
    }

    private static ArrayList<String> getFieldTerms(String path, String field, int max, String term, IndexSearcher searcher, String type) throws IOException {
        if (field == null || field.isEmpty()) {
            ArrayList<String> list = new ArrayList<String>();
            IndexReader reader = searcher.getIndexReader();
            Fields fields = MultiFields.getFields(reader);
            if (fields != null) {
                for (String f : fields) {
                    list.addAll(LuceneIndexMBeanImpl.getFieldTerms(path, f, max, term, searcher, null));
                }
            }
            return list;
        }
        Function<BytesRef, String> handler = LuceneIndexMBeanImpl.getTypeHandler(type);
        IndexReader reader = searcher.getIndexReader();
        Terms terms = MultiFields.getTerms(reader, field);
        ArrayList<String> result = new ArrayList<String>();
        if (terms == null) {
            return result;
        }
        TermsEnum iterator = terms.iterator(null);
        BytesRef byteRef = null;
        class Entry
        implements Comparable<Entry> {
            String term;
            int count;

            Entry() {
            }

            @Override
            public int compareTo(Entry o) {
                int c = Integer.compare(this.count, o.count);
                if (c == 0) {
                    c = this.term.compareTo(o.term);
                }
                return -c;
            }
        }
        ArrayList<Entry> list = new ArrayList<Entry>();
        long totalCount = 0L;
        while ((byteRef = iterator.next()) != null) {
            Entry e = new Entry();
            e.term = handler.apply(byteRef);
            if (term != null && e.term != null && !e.term.equals(term)) continue;
            e.count = iterator.docFreq();
            totalCount += (long)e.count;
            if (e.count > 1) {
                list.add(e);
            }
            if (max <= 0 || list.size() <= 2 * max) continue;
            LuceneIndexMBeanImpl.sortAndTruncateList(list, max);
        }
        LuceneIndexMBeanImpl.sortAndTruncateList(list, max);
        result.add(totalCount + " (total for field " + field + ")");
        for (Entry e : list) {
            result.add(e.count + " " + e.term);
        }
        return result;
    }

    static <T extends Comparable<T>> void sortAndTruncateList(ArrayList<T> list, int max) {
        Collections.sort(list);
        if (max > 0 && list.size() > max) {
            list.subList(max, list.size()).clear();
        }
    }

    private static String[] determineIndexedPaths(IndexSearcher searcher, final int maxLevel, int maxPathCount) throws IOException {
        HashSet<String> paths = new HashSet<String>();
        int startDepth = LuceneIndexMBeanImpl.getStartDepth(searcher, maxLevel);
        if (startDepth < 0) {
            return LuceneIndexMBeanImpl.createMsg("startDepth cannot be determined after search for upto maxLevel [" + maxLevel + "]");
        }
        SearchContext sc = new SearchContext(searcher);
        List<LuceneDoc> docs = LuceneIndexMBeanImpl.getDocsAtLevel(startDepth, sc);
        int maxPathLimitBreachedAtLevel = -1;
        block0: for (LuceneDoc doc : docs) {
            TreeTraverser<LuceneDoc> traverser = new TreeTraverser<LuceneDoc>(){

                public Iterable<LuceneDoc> children(@NotNull LuceneDoc root) {
                    if (root.depth >= maxLevel) {
                        return Collections.emptyList();
                    }
                    return root.getChildren();
                }
            };
            for (LuceneDoc node : traverser.breadthFirstTraversal((Object)doc)) {
                if (paths.size() < maxPathCount) {
                    paths.add(node.path);
                    continue;
                }
                maxPathLimitBreachedAtLevel = node.depth;
                break block0;
            }
        }
        if (maxPathLimitBreachedAtLevel < 0) {
            return (String[])IterableUtils.toArray(paths, String.class);
        }
        HashSet<String> result = new HashSet<String>();
        int safeDepth = maxPathLimitBreachedAtLevel - 1;
        if (safeDepth > 0) {
            for (String path : paths) {
                int pathDepth = PathUtils.getDepth(path);
                if (pathDepth != safeDepth) continue;
                result.add(path);
            }
        }
        return (String[])IterableUtils.toArray(result, String.class);
    }

    private static int getStartDepth(IndexSearcher searcher, int maxLevel) throws IOException {
        for (int depth = 0; depth < maxLevel; ++depth) {
            TopDocs docs = searcher.search(LuceneIndexMBeanImpl.newDepthQuery(depth), 1);
            if (docs.totalHits == 0) continue;
            return depth;
        }
        return -1;
    }

    private static List<LuceneDoc> getDocsAtLevel(int startDepth, SearchContext sc) throws IOException {
        TopDocs docs = sc.searcher.search(LuceneIndexMBeanImpl.newDepthQuery(startDepth), Integer.MAX_VALUE);
        return LuceneIndexMBeanImpl.getLuceneDocs(docs, sc);
    }

    private static List<LuceneDoc> getLuceneDocs(TopDocs docs, SearchContext sc) throws IOException {
        ArrayList<LuceneDoc> result = new ArrayList<LuceneDoc>(docs.scoreDocs.length);
        IndexReader reader = sc.searcher.getIndexReader();
        for (ScoreDoc doc : docs.scoreDocs) {
            result.add(new LuceneDoc(LuceneIndexMBeanImpl.getPath(reader, doc), sc));
        }
        return result;
    }

    private static String getPath(IndexReader reader, ScoreDoc doc) throws IOException {
        PathStoredFieldVisitor visitor = new PathStoredFieldVisitor();
        reader.document(doc.doc, visitor);
        return visitor.getPath();
    }

    private static Query newDepthQuery(String path) {
        int depth = PathUtils.getDepth(path) + 1;
        return LuceneIndexMBeanImpl.newDepthQuery(depth);
    }

    private static Query newDepthQuery(int depth) {
        return NumericRangeQuery.newIntRange(":depth", depth, depth, true, true);
    }

    private static String[] createMsg(String msg) {
        return new String[]{msg};
    }

    private static IndexReader getPrimaryReader(List<LuceneIndexReader> indexReaders) {
        return indexReaders.isEmpty() ? null : indexReaders.get(0).getReader();
    }

    private static long getIndexSize(List<LuceneIndexReader> readers) throws IOException {
        long totalSize = 0L;
        for (LuceneIndexReader r : readers) {
            totalSize += r.getIndexSize();
        }
        return totalSize;
    }

    private static Directory getDirectory(IndexReader reader) {
        if (reader instanceof DirectoryReader) {
            return ((DirectoryReader)reader).directory();
        }
        return null;
    }

    private static int getNumDocs(List<LuceneIndexReader> readers) {
        int numDoc = 0;
        for (LuceneIndexReader r : readers) {
            numDoc += r.getReader().numDocs();
        }
        return numDoc;
    }

    private static class BadIndexStats {
        static final String[] FIELD_NAMES = new String[]{"path", "stats", "failingSince", "exception"};
        static final String[] FIELD_DESCRIPTIONS = new String[]{"Path", "Failure stats", "Failure start time", "Exception"};
        static final OpenType[] FIELD_TYPES = new OpenType[]{SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING};
        static final CompositeType TYPE = BadIndexStats.createCompositeType();
        private final BadIndexTracker.BadIndexInfo info;

        static CompositeType createCompositeType() {
            try {
                return new CompositeType(BadIndexStats.class.getName(), "Composite data type for Lucene Bad Index statistics", FIELD_NAMES, FIELD_DESCRIPTIONS, FIELD_TYPES);
            }
            catch (OpenDataException e) {
                throw new IllegalStateException(e);
            }
        }

        public BadIndexStats(BadIndexTracker.BadIndexInfo info) {
            this.info = info;
        }

        CompositeDataSupport toCompositeData() {
            Object[] values = new Object[]{this.info.path, this.info.getStats(), String.format("%tc", this.info.getCreatedTime()), this.info.getException()};
            try {
                return new CompositeDataSupport(TYPE, FIELD_NAMES, values);
            }
            catch (OpenDataException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    private static class IndexStats {
        static final String[] FIELD_NAMES = new String[]{"path", "indexSizeStr", "indexSize", "suggesterSizeStr", "suggesterSize", "numDocs", "maxDoc", "numDeletedDocs", "nrtIndexSize", "nrtIndexSizeStr", "nrtNumDocs"};
        static final String[] FIELD_DESCRIPTIONS = new String[]{"Path", "Index size in human readable format", "Index size in bytes", "Suggester size in human readable format", "Suggester size in bytes", "Number of documents in this index.", "The time and date for when the longest query took place", "Number of deleted documents", "NRT Index Size in bytes", "NRT Index Size in human readable format", "Number of documents in NRT index"};
        static final OpenType[] FIELD_TYPES = new OpenType[]{SimpleType.STRING, SimpleType.STRING, SimpleType.LONG, SimpleType.STRING, SimpleType.LONG, SimpleType.INTEGER, SimpleType.INTEGER, SimpleType.INTEGER, SimpleType.LONG, SimpleType.STRING, SimpleType.INTEGER};
        static final CompositeType TYPE = IndexStats.createCompositeType();
        private final String path;
        private final long indexSize;
        private final int numDocs;
        private final int maxDoc;
        private final int numDeletedDocs;
        private final String indexSizeStr;
        private final long suggesterSize;
        private final String suggesterSizeStr;
        private final long nrtIndexSize;
        private final String nrtIndexSizeStr;
        private final int numDocsNRT;

        static CompositeType createCompositeType() {
            try {
                return new CompositeType(IndexStats.class.getName(), "Composite data type for Lucene Index statistics", FIELD_NAMES, FIELD_DESCRIPTIONS, FIELD_TYPES);
            }
            catch (OpenDataException e) {
                throw new IllegalStateException(e);
            }
        }

        public IndexStats(String path, LuceneIndexNode indexNode) throws IOException {
            this.path = path;
            this.numDocs = indexNode.getSearcher().getIndexReader().numDocs();
            this.maxDoc = indexNode.getSearcher().getIndexReader().maxDoc();
            this.numDeletedDocs = indexNode.getSearcher().getIndexReader().numDeletedDocs();
            this.indexSize = LuceneIndexMBeanImpl.getIndexSize(indexNode.getPrimaryReaders());
            this.indexSizeStr = IOUtils.humanReadableByteCount(this.indexSize);
            this.suggesterSize = DirectoryUtils.dirSize((Directory)indexNode.getSuggestDirectory());
            this.suggesterSizeStr = IOUtils.humanReadableByteCount(this.suggesterSize);
            this.nrtIndexSize = LuceneIndexMBeanImpl.getIndexSize(indexNode.getNRTReaders());
            this.numDocsNRT = LuceneIndexMBeanImpl.getNumDocs(indexNode.getNRTReaders());
            this.nrtIndexSizeStr = IOUtils.humanReadableByteCount(this.nrtIndexSize);
        }

        CompositeDataSupport toCompositeData() {
            Object[] values = new Object[]{this.path, this.indexSizeStr, this.indexSize, this.suggesterSizeStr, this.suggesterSize, this.numDocs, this.maxDoc, this.numDeletedDocs, this.nrtIndexSize, this.nrtIndexSizeStr, this.numDocsNRT};
            try {
                return new CompositeDataSupport(TYPE, FIELD_NAMES, values);
            }
            catch (OpenDataException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    private static class LuceneDoc {
        final String path;
        final SearchContext sc;
        final int depth;

        public LuceneDoc(String path, SearchContext sc) {
            this.path = path;
            this.sc = sc;
            this.depth = PathUtils.getDepth(path);
        }

        public Iterable<LuceneDoc> getChildren() {
            BooleanQuery bq = new BooleanQuery();
            bq.add(new BooleanClause(new TermQuery(TermFactory.newAncestorTerm(this.path)), BooleanClause.Occur.MUST));
            bq.add(new BooleanClause(LuceneIndexMBeanImpl.newDepthQuery(this.path), BooleanClause.Occur.MUST));
            try {
                TopDocs docs = this.sc.searcher.search((Query)bq, Integer.MAX_VALUE);
                return LuceneIndexMBeanImpl.getLuceneDocs(docs, this.sc);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class SearchContext {
        final IndexSearcher searcher;

        SearchContext(IndexSearcher searcher) {
            this.searcher = searcher;
        }
    }
}

