/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.nodetype.write;

import java.util.Arrays;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeDefinitionTemplate;
import javax.jcr.nodetype.NodeType;
import javax.jcr.version.OnParentVersionAction;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.namepath.NameMapper;
import org.apache.jackrabbit.oak.plugins.nodetype.write.ItemDefinitionTemplate;

class NodeDefinitionTemplateImpl
extends ItemDefinitionTemplate
implements NodeDefinitionTemplate {
    private boolean allowSameNameSiblings = false;
    private String defaultPrimaryTypeOakName = null;
    private String[] requiredPrimaryTypeOakNames = null;

    public NodeDefinitionTemplateImpl(NameMapper mapper) {
        super(mapper);
    }

    public NodeDefinitionTemplateImpl(NameMapper mapper, NodeDefinition definition) throws ConstraintViolationException {
        super(mapper, definition);
        this.setSameNameSiblings(definition.allowsSameNameSiblings());
        this.setDefaultPrimaryTypeName(definition.getDefaultPrimaryTypeName());
        this.setRequiredPrimaryTypeNames(definition.getRequiredPrimaryTypeNames());
    }

    @Override
    void writeTo(Tree tree) throws RepositoryException {
        super.writeTo(tree);
        tree.setProperty("jcr:sameNameSiblings", this.allowSameNameSiblings);
        if (this.requiredPrimaryTypeOakNames != null) {
            tree.setProperty("jcr:requiredPrimaryTypes", Arrays.asList(this.requiredPrimaryTypeOakNames), Type.NAMES);
        } else {
            tree.removeProperty("jcr:requiredPrimaryTypes");
        }
        if (this.defaultPrimaryTypeOakName != null) {
            tree.setProperty("jcr:defaultPrimaryType", this.defaultPrimaryTypeOakName, Type.NAME);
        } else {
            tree.removeProperty("jcr:defaultPrimaryType");
        }
    }

    @Override
    public boolean allowsSameNameSiblings() {
        return this.allowSameNameSiblings;
    }

    @Override
    public void setSameNameSiblings(boolean allowSameNameSiblings) {
        this.allowSameNameSiblings = allowSameNameSiblings;
    }

    @Override
    public NodeType getDefaultPrimaryType() {
        return null;
    }

    @Override
    public String getDefaultPrimaryTypeName() {
        return this.getJcrNameAllowNull(this.defaultPrimaryTypeOakName);
    }

    @Override
    public void setDefaultPrimaryTypeName(String jcrName) throws ConstraintViolationException {
        this.defaultPrimaryTypeOakName = this.getOakNameAllowNullOrThrowConstraintViolation(jcrName);
    }

    @Override
    public NodeType[] getRequiredPrimaryTypes() {
        return null;
    }

    @Override
    public String[] getRequiredPrimaryTypeNames() {
        return this.getJcrNamesAllowNull(this.requiredPrimaryTypeOakNames);
    }

    @Override
    public void setRequiredPrimaryTypeNames(String[] jcrNames) throws ConstraintViolationException {
        this.requiredPrimaryTypeOakNames = this.getOakNamesOrThrowConstraintViolation(jcrNames);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("+ ");
        if (this.getOakName() == null) {
            builder.append("*");
        } else {
            builder.append(this.getOakName());
        }
        if (this.defaultPrimaryTypeOakName != null) {
            builder.append(" (");
            builder.append(this.defaultPrimaryTypeOakName);
            builder.append(")");
        }
        if (this.isAutoCreated()) {
            builder.append(" a");
        }
        if (this.isProtected()) {
            builder.append(" p");
        }
        if (this.isMandatory()) {
            builder.append(" m");
        }
        if (this.getOnParentVersion() != 1) {
            builder.append(" ");
            builder.append(OnParentVersionAction.nameFromValue(this.getOnParentVersion()));
        }
        return builder.toString();
    }
}

