/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.sites.ui.designfield.datasources;

import com.adobe.granite.ui.components.Config;
import com.adobe.granite.ui.components.ExpressionHelper;
import com.adobe.granite.ui.components.ExpressionResolver;
import com.adobe.granite.ui.components.PagingIterator;
import com.adobe.granite.ui.components.ds.AbstractDataSource;
import com.adobe.granite.ui.components.ds.DataSource;
import com.adobe.granite.ui.components.ds.EmptyDataSource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.servlet.Servlet;
import org.apache.commons.collections4.IteratorUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={Servlet.class}, property={"sling.servlet.resourceTypes=wcm/designer/gui/components/designfield/datasources/children", "sling.servlet.methods=GET"})
public class Children
extends SlingSafeMethodsServlet {
    @Reference
    ExpressionResolver expressionResolver;

    @Override
    public void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) {
        DataSource ds;
        String DEFAULT_ROOT = "/";
        String LEGACY_DESIGNS_LOCATION = "/etc/designs";
        String DEFAULT_DESIGNS_LOCATION = "/libs/settings/wcm/designs";
        String USER_DESIGNS_LOCATIONS = "/apps/settings/wcm/designs";
        String LEGACY_DESIGNS_ROOT = "/etc";
        String DEFAULT_DESIGNS_ROOT = "/libs";
        String USER_DESIGNS_ROOT = "/apps";
        ResourceResolver resourceResolver = request.getResourceResolver();
        ExpressionHelper ex = new ExpressionHelper(this.expressionResolver, request);
        Config dsCfg = new Config(request.getResource().getChild(Config.DATASOURCE));
        HashMap<String, String> rootMapping = new HashMap<String, String>();
        final ArrayList<Resource> result = new ArrayList<Resource>();
        String parentPath = null;
        String searchName = null;
        if (resourceResolver.getResource("/etc/designs") != null) {
            rootMapping.put("/etc", "/etc/designs");
        }
        rootMapping.put("/libs", "/libs/settings/wcm/designs");
        rootMapping.put("/apps", "/apps/settings/wcm/designs");
        String query = ex.getString(dsCfg.get("query", String.class));
        if (query != null) {
            int slashIndex = query.lastIndexOf(47);
            if (slashIndex < 0 && !StringUtils.isBlank(query)) {
                rootMapping.values().stream().map(resourceResolver::getResource).filter(Objects::nonNull).forEach(r -> result.addAll(IteratorUtils.toList(r.listChildren())));
                searchName = query;
            } else if (rootMapping.values().stream().anyMatch(query::startsWith)) {
                parentPath = query.substring(0, slashIndex + 1);
                searchName = query.substring(slashIndex + 1);
            } else {
                rootMapping.values().stream().filter(s -> s.startsWith(query)).forEach(s -> result.add(resourceResolver.getResource((String)s)));
            }
        } else {
            parentPath = ex.getString(dsCfg.get("path", String.class));
        }
        if ("/".equals(parentPath)) {
            rootMapping.keySet().stream().forEach(path -> result.add(resourceResolver.getResource((String)path)));
        } else if (parentPath != null) {
            if (rootMapping.containsKey(parentPath)) {
                parentPath = (String)rootMapping.get(parentPath);
            }
            Resource parent = resourceResolver.getResource(parentPath);
            Iterator<Resource> childIt = parent.listChildren();
            while (childIt.hasNext()) {
                result.add(childIt.next());
            }
        }
        if (result.isEmpty()) {
            ds = EmptyDataSource.instance();
        } else {
            final Integer offset = ex.get(dsCfg.get("offset", String.class), Integer.class);
            final Integer limit = ex.get(dsCfg.get("limit", String.class), Integer.class);
            result.removeIf(resource -> !resource.isResourceType("cq:Page") && !resource.isResourceType("nt:folder") && !resource.isResourceType("sling:Folder") && !resource.isResourceType("sling:OrderedFolder"));
            if (!StringUtils.isBlank(searchName)) {
                Pattern searchNamePattern = Pattern.compile(Pattern.quote(searchName), 2);
                result.removeIf(resource -> !searchNamePattern.matcher(resource.getName()).lookingAt());
            }
            Collections.sort(result, Comparator.comparing(Resource::getName));
            AbstractDataSource datasource = new AbstractDataSource(){

                @Override
                public Iterator<Resource> iterator() {
                    return new PagingIterator<Resource>(result.iterator(), offset, limit);
                }
            };
            ds = datasource;
        }
        request.setAttribute(DataSource.class.getName(), ds);
    }
}

