/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.ut.trace;

import com.adobe.xfa.ut.MsgFormatPos;
import com.adobe.xfa.ut.trace.GlobalTraceStore;
import com.adobe.xfa.ut.trace.TraceHandler;

public final class Trace {
    private final String msName;
    private volatile boolean mbEnabled;
    private volatile int mnHelpId;
    private volatile boolean mbIsPlaceHolder;

    Trace(String sName) {
        this.msName = sName;
        this.mbIsPlaceHolder = true;
    }

    public Trace(String sName, int nHelpId) {
        this.msName = sName;
        this.mnHelpId = nHelpId;
        GlobalTraceStore.getStore().addTrace(this);
    }

    public static boolean isEnabled(String sName, int nLevel) {
        GlobalTraceStore globalTraceStore = GlobalTraceStore.getStore();
        if (globalTraceStore.isEnabled()) {
            return TraceHandler.getTraceHandler().isActive(sName, nLevel);
        }
        return false;
    }

    public static void trace(String sName, int nLevel, int nId, String sMsg) {
        GlobalTraceStore globalTraceStore = GlobalTraceStore.getStore();
        if (globalTraceStore.isEnabled()) {
            TraceHandler.getTraceHandler().trace(sName, nLevel, nId, sMsg);
        }
    }

    public static void trace(String sName, int nLevel, MsgFormatPos oMsg) {
        GlobalTraceStore globalTraceStore = GlobalTraceStore.getStore();
        if (globalTraceStore.isEnabled()) {
            TraceHandler.getTraceHandler().trace(sName, nLevel, oMsg);
        }
    }

    public void activate(int nLevel) {
        TraceHandler.getTraceHandler().activate(this, nLevel);
    }

    public void deactivate() {
        if (this.mbEnabled) {
            TraceHandler.getTraceHandler().deactivate(this.msName);
        }
    }

    protected void enable() {
        this.mbEnabled = true;
    }

    public int getHelpId() {
        return this.mnHelpId;
    }

    void setHelpId(int nHelpId) {
        this.mnHelpId = nHelpId;
    }

    boolean isPlaceHolder() {
        return this.mbIsPlaceHolder;
    }

    void setPlaceHolder(boolean bIsPlaceHolder) {
        this.mbIsPlaceHolder = bIsPlaceHolder;
    }

    public String getName() {
        return this.msName;
    }

    public boolean isEnabled(int nLevel) {
        if (this.mbEnabled) {
            return TraceHandler.getTraceHandler().isActive(this.msName, nLevel);
        }
        return false;
    }

    public void trace(int nLevel, int nId, String sMsg) {
        if (this.mbEnabled) {
            TraceHandler.getTraceHandler().trace(this.msName, nLevel, nId, sMsg);
        }
    }

    public void trace(int nLevel, MsgFormatPos oMsg) {
        if (this.mbEnabled) {
            TraceHandler.getTraceHandler().trace(this.msName, nLevel, oMsg);
        }
    }
}

