/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.commons.predicates;

import com.day.cq.commons.predicates.FalsePredicate;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.Predicate;

public class AnyPredicate
implements Predicate,
Serializable {
    private final Predicate[] predicates;

    public static Predicate getInstance(Predicate[] predicates) {
        AnyPredicate.validate(predicates);
        if (predicates.length == 0) {
            return FalsePredicate.INSTANCE;
        }
        return predicates.length == 1 ? predicates[0] : new AnyPredicate(predicates);
    }

    public static Predicate getInstance(Collection predicates) {
        Predicate[] preds = AnyPredicate.validate(predicates);
        if (preds.length == 0) {
            return FalsePredicate.INSTANCE;
        }
        return preds.length == 1 ? preds[0] : new AnyPredicate(preds);
    }

    public AnyPredicate(Predicate[] predicates) {
        this.predicates = predicates;
    }

    public boolean test(Object object) {
        for (Predicate iPredicate : this.predicates) {
            if (!iPredicate.test(object)) continue;
            return true;
        }
        return false;
    }

    public Predicate[] getPredicates() {
        return this.predicates;
    }

    private static void validate(Predicate[] predicates) {
        if (predicates == null) {
            throw new IllegalArgumentException("The predicate array must not be null");
        }
        for (int i = 0; i < predicates.length; ++i) {
            if (predicates[i] != null) continue;
            throw new IllegalArgumentException("The predicate array must not contain a null predicate, index " + i + " was null");
        }
    }

    private static Predicate[] validate(Collection predicates) {
        if (predicates == null) {
            throw new IllegalArgumentException("The predicate collection must not be null");
        }
        Predicate[] preds = new Predicate[predicates.size()];
        int i = 0;
        Iterator it = predicates.iterator();
        while (it.hasNext()) {
            preds[i] = (Predicate)it.next();
            if (preds[i] == null) {
                throw new IllegalArgumentException("The predicate collection must not contain a null predicate, index " + i + " was null");
            }
            ++i;
        }
        return preds;
    }
}

