/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.tagging;

import com.day.cq.tagging.Tag;
import com.day.cq.tagging.TagManager;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Locale;
import java.util.TreeSet;
import org.apache.sling.api.resource.Resource;

public class TagCloud {
    private final Tag[] tags;
    private final long[] frequencies;

    public TagCloud(Tag[] tags) {
        this(tags, null);
    }

    public TagCloud(Tag[] tags, Locale locale) {
        this.tags = tags;
        this.frequencies = this.calculateFrequencies();
        this.sortTags(locale);
    }

    @Deprecated
    public TagCloud(TagManager tagManager) {
        this(tagManager, null);
    }

    @Deprecated
    public TagCloud(TagManager tagManager, Resource resource) {
        this.tags = resource != null ? tagManager.getTags(resource) : tagManager.findByTitle((String)"*").tags;
        this.frequencies = this.calculateFrequencies();
        this.sortTags(null);
    }

    private void sortTags(final Locale locale) {
        Arrays.sort(this.tags, new Comparator<Tag>(){
            final /* synthetic */ TagCloud this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public int compare(Tag tag1, Tag tag2) {
                return tag1.getTitle(locale).compareTo(tag2.getTitle(locale));
            }
        });
    }

    public Tag[] getTags() {
        return this.tags;
    }

    public boolean isEmpty() {
        return this.tags.length == 0;
    }

    private long[] calculateFrequencies() {
        TreeSet<Long> frequencySet = new TreeSet<Long>();
        for (Tag tag : this.tags) {
            long count = tag.getCount();
            if (count <= 0L) continue;
            frequencySet.add(tag.getCount());
        }
        long[] frequencies = new long[frequencySet.size()];
        int i = 0;
        Iterator iterator = frequencySet.iterator();
        while (iterator.hasNext()) {
            long freq;
            frequencies[i] = freq = ((Long)iterator.next()).longValue();
            ++i;
        }
        return frequencies;
    }

    public int calculateNtiles(long tagCount, int n) {
        return TagCloud.calculateNtiles(tagCount, this.frequencies, n);
    }

    public static int calculateNtiles(long frequency, long[] frequencies, int n) {
        int i = 0;
        while (i < frequencies.length - 1 && frequencies[i] < frequency) {
            ++i;
        }
        return (int)Math.ceil((double)(i + 1) / (double)frequencies.length * (double)n);
    }
}

