/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.apache.commons.io.FileUtils;
import org.apache.jackrabbit.guava.common.util.concurrent.Monitor;
import org.apache.jackrabbit.oak.commons.IOUtils;
import org.apache.jackrabbit.oak.commons.collections.IterableUtils;
import org.apache.jackrabbit.oak.commons.collections.SetUtils;
import org.apache.jackrabbit.oak.commons.conditions.Validate;
import org.apache.jackrabbit.oak.plugins.index.lucene.CopyOnReadStatsMBean;
import org.apache.jackrabbit.oak.plugins.index.lucene.LuceneIndexDefinition;
import org.apache.jackrabbit.oak.plugins.index.lucene.directory.CopyOnReadDirectory;
import org.apache.jackrabbit.oak.plugins.index.lucene.directory.CopyOnWriteDirectory;
import org.apache.jackrabbit.oak.plugins.index.lucene.directory.DirectoryUtils;
import org.apache.jackrabbit.oak.plugins.index.lucene.directory.IndexRootDirectory;
import org.apache.jackrabbit.oak.plugins.index.lucene.directory.IndexSanityChecker;
import org.apache.jackrabbit.oak.plugins.index.lucene.directory.LocalIndexDir;
import org.apache.jackrabbit.oak.plugins.index.lucene.directory.LocalIndexFile;
import org.apache.jackrabbit.oak.plugins.index.search.IndexDefinition;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.FilterDirectory;
import org.apache.lucene.store.NoLockFactory;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexCopier
implements CopyOnReadStatsMBean,
Closeable {
    public static final Set<String> REMOTE_ONLY = Set.of("segments.gen");
    private static final int MAX_FAILURE_ENTRIES = 10000;
    private static final String WORK_DIR_NAME = "indexWriterDir";
    private static final Logger log = LoggerFactory.getLogger(IndexCopier.class);
    private final Executor executor;
    private final File indexWorkDir;
    private final AtomicInteger readerLocalReadCount = new AtomicInteger();
    private final AtomicInteger writerLocalReadCount = new AtomicInteger();
    private final AtomicInteger readerRemoteReadCount = new AtomicInteger();
    private final AtomicInteger writerRemoteReadCount = new AtomicInteger();
    private final AtomicInteger invalidFileCount = new AtomicInteger();
    private final AtomicInteger deletedFileCount = new AtomicInteger();
    private final AtomicInteger scheduledForCopyCount = new AtomicInteger();
    private final AtomicInteger copyInProgressCount = new AtomicInteger();
    private final AtomicInteger maxCopyInProgressCount = new AtomicInteger();
    private final AtomicInteger maxScheduledForCopyCount = new AtomicInteger();
    private final AtomicInteger uploadCount = new AtomicInteger();
    private final AtomicInteger downloadCount = new AtomicInteger();
    private final AtomicLong copyInProgressSize = new AtomicLong();
    private final AtomicLong downloadSize = new AtomicLong();
    private final AtomicLong uploadSize = new AtomicLong();
    private final AtomicLong garbageCollectedSize = new AtomicLong();
    private final AtomicLong skippedFromUploadSize = new AtomicLong();
    private final AtomicLong downloadTime = new AtomicLong();
    private final AtomicLong uploadTime = new AtomicLong();
    private final Monitor copyCompletionMonitor = new Monitor();
    private final Map<String, String> indexPathVersionMapping = new ConcurrentHashMap<String, String>();
    private final ConcurrentMap<String, LocalIndexFile> failedToDeleteFiles = new ConcurrentHashMap<String, LocalIndexFile>();
    private final Set<LocalIndexFile> copyInProgressFiles = Collections.newSetFromMap(new ConcurrentHashMap());
    private final boolean prefetchEnabled;
    private volatile boolean closed;
    private final IndexRootDirectory indexRootDirectory;
    private final Set<String> validatedIndexPaths = SetUtils.newConcurrentHashSet();
    private final IndexSanityChecker.IndexSanityStatistics indexSanityStatistics = new IndexSanityChecker.IndexSanityStatistics();

    public IndexCopier(Executor executor, File indexRootDir) throws IOException {
        this(executor, indexRootDir, false);
    }

    public IndexCopier(Executor executor, File indexRootDir, boolean prefetchEnabled) throws IOException {
        this.executor = executor;
        this.prefetchEnabled = prefetchEnabled;
        this.indexWorkDir = IndexCopier.initializerWorkDir(indexRootDir);
        this.indexRootDirectory = new IndexRootDirectory(indexRootDir);
    }

    public Directory wrapForRead(String indexPath, LuceneIndexDefinition definition, Directory remote, String dirName) throws IOException {
        Directory local = this.createLocalDirForIndexReader(indexPath, definition, dirName);
        this.checkIntegrity(indexPath, local, remote);
        return new CopyOnReadDirectory(this, remote, local, this.prefetchEnabled, indexPath, this.executor);
    }

    public Directory wrapForWrite(LuceneIndexDefinition definition, Directory remote, boolean reindexMode, String dirName, COWDirectoryTracker cowDirectoryTracker) throws IOException {
        Directory local = this.createLocalDirForIndexWriter(definition, dirName, reindexMode, cowDirectoryTracker);
        String indexPath = definition.getIndexPath();
        this.checkIntegrity(indexPath, local, remote);
        CopyOnWriteDirectory cowDirectory = new CopyOnWriteDirectory(this, remote, local, reindexMode, indexPath, this.executor);
        cowDirectoryTracker.registerOpenedDirectory(cowDirectory);
        return cowDirectory;
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
    }

    public boolean isClosed() {
        return this.closed;
    }

    File getIndexWorkDir() {
        return this.indexWorkDir;
    }

    IndexRootDirectory getIndexRootDirectory() {
        return this.indexRootDirectory;
    }

    protected Directory createLocalDirForIndexWriter(LuceneIndexDefinition definition, String dirName, boolean reindexMode, COWDirectoryTracker cowDirectoryTracker) throws IOException {
        String indexPath = definition.getIndexPath();
        File indexWriterDir = this.getIndexDir(definition, indexPath, dirName);
        if (reindexMode) {
            cowDirectoryTracker.registerReindexingLocalDirectory(indexWriterDir);
        }
        FSDirectory dir = FSDirectory.open(indexWriterDir, NoLockFactory.getNoLockFactory());
        log.debug("IndexWriter would use {}", (Object)indexWriterDir);
        return dir;
    }

    protected Directory createLocalDirForIndexReader(String indexPath, LuceneIndexDefinition definition, String dirName) throws IOException {
        String oldPath;
        File indexDir = this.getIndexDir(definition, indexPath, dirName);
        Directory result = FSDirectory.open(indexDir);
        String newPath = indexDir.getAbsolutePath();
        if (!newPath.equals(oldPath = this.indexPathVersionMapping.put(IndexCopier.createIndexPathKey(indexPath, dirName), newPath)) && oldPath != null) {
            result = new DeleteOldDirOnClose(result, new File(oldPath));
        }
        return result;
    }

    public File getIndexDir(IndexDefinition definition, String indexPath, String dirName) throws IOException {
        return this.indexRootDirectory.getIndexDir(definition, indexPath, dirName);
    }

    Map<String, LocalIndexFile> getFailedToDeleteFiles() {
        return Collections.unmodifiableMap(this.failedToDeleteFiles);
    }

    private void failedToDelete(LocalIndexFile file) {
        if (this.failedToDeleteFiles.size() < 10000) {
            LocalIndexFile failedToDeleteFile = this.failedToDeleteFiles.putIfAbsent(file.getKey(), file);
            if (failedToDeleteFile == null) {
                failedToDeleteFile = file;
            }
            failedToDeleteFile.incrementAttemptToDelete();
        } else {
            log.warn("Not able to delete {}. Currently more than {} file with total size {} are pending delete.", file.deleteLog(), this.failedToDeleteFiles.size(), this.getGarbageSize());
        }
    }

    private void successfullyDeleted(LocalIndexFile file, boolean fileExisted) {
        LocalIndexFile failedToDeleteFile = (LocalIndexFile)this.failedToDeleteFiles.remove(file.getKey());
        if (failedToDeleteFile != null) {
            log.debug("Deleted : {}", (Object)failedToDeleteFile.deleteLog());
        }
        if (fileExisted) {
            this.garbageCollectedSize.addAndGet(file.getSize());
            this.deletedFileCount.incrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkIntegrity(String indexPath, Directory local, Directory remote) throws IOException {
        if (this.validatedIndexPaths.contains(indexPath)) {
            return;
        }
        Set<String> set = this.validatedIndexPaths;
        synchronized (set) {
            new IndexSanityChecker(indexPath, local, remote).check(this.indexSanityStatistics);
            this.validatedIndexPaths.add(indexPath);
        }
    }

    private static File initializerWorkDir(File indexRootDir) throws IOException {
        File workDir = new File(indexRootDir, WORK_DIR_NAME);
        FileUtils.deleteDirectory(workDir);
        Validate.checkState((boolean)workDir.mkdirs(), (String)"Cannot create directory %s", (Object[])new Object[]{workDir});
        return workDir;
    }

    private static String createIndexPathKey(String indexPath, String dirName) {
        return indexPath.concat(dirName);
    }

    public boolean deleteFile(Directory dir, String fileName, boolean copiedFromRemote) {
        LocalIndexFile file = new LocalIndexFile(dir, fileName, DirectoryUtils.getFileLength((Directory)dir, (String)fileName), copiedFromRemote);
        boolean successFullyDeleted = false;
        try {
            boolean fileExisted = false;
            if (dir.fileExists(fileName)) {
                fileExisted = true;
                dir.deleteFile(fileName);
            }
            this.successfullyDeleted(file, fileExisted);
            successFullyDeleted = true;
        }
        catch (IOException e) {
            this.failedToDelete(file);
            log.debug("Error occurred while removing deleted file {} from Local {}. Attempt would be made to delete it on next run ", fileName, dir, e);
        }
        return successFullyDeleted;
    }

    public static long getNewestLocalFSTimestampFor(Set<String> names, Directory localDir) {
        File localFSDir = LocalIndexFile.getFSDir((Directory)localDir);
        if (localFSDir == null) {
            log.warn("Couldn't get FSDirectory instance for {}.", (Object)localDir);
            return -1L;
        }
        long maxTS = 0L;
        for (String name : names) {
            File f = new File(localFSDir, name);
            if (!f.exists()) {
                log.warn("File {} doesn't exist in {}", (Object)name, (Object)localFSDir);
                return -1L;
            }
            long modTS = f.lastModified();
            if (modTS == 0L) {
                log.warn("Couldn't get lastModification timestamp for {} in {}", (Object)name, (Object)localFSDir);
                return -1L;
            }
            if (modTS <= maxTS) continue;
            maxTS = modTS;
        }
        return maxTS;
    }

    public static boolean isFileModifiedBefore(String name, Directory localDir, long millis) {
        File localFSDir = LocalIndexFile.getFSDir((Directory)localDir);
        if (localFSDir == null) {
            log.warn("Couldn't get FSDirectory instance for {}.", (Object)localDir);
            return false;
        }
        File f = new File(localFSDir, name);
        if (!f.exists()) {
            log.warn("File {} doesn't exist in {}", (Object)name, (Object)localFSDir);
            return false;
        }
        long modTS = f.lastModified();
        if (modTS == 0L) {
            log.warn("Couldn't get lastModification timestamp for {} in {}", (Object)name, (Object)localFSDir);
            return false;
        }
        return modTS < millis;
    }

    public long startCopy(LocalIndexFile file) {
        this.updateMaxInProgress(this.copyInProgressCount.incrementAndGet());
        this.copyInProgressSize.addAndGet(file.getSize());
        this.copyInProgressFiles.add(file);
        return System.currentTimeMillis();
    }

    public boolean isCopyInProgress(LocalIndexFile file) {
        return this.copyInProgressFiles.contains(file);
    }

    public void waitForCopyCompletion(final LocalIndexFile file, long timeoutMillis) {
        boolean notCopying;
        long localLength;
        Monitor.Guard notCopyingGuard = new Monitor.Guard(this.copyCompletionMonitor){

            public boolean isSatisfied() {
                return !IndexCopier.this.isCopyInProgress(file);
            }
        };
        long lastLocalLength = localLength = file.actualSize();
        boolean bl = notCopying = !this.isCopyInProgress(file);
        while (!notCopying) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug("Checking for copy completion of {} - {}", (Object)file.getKey(), (Object)file.copyLog());
                }
                if (notCopying = this.copyCompletionMonitor.enterWhen(notCopyingGuard, timeoutMillis, TimeUnit.MILLISECONDS)) {
                    this.copyCompletionMonitor.leave();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            localLength = file.actualSize();
            if (localLength <= lastLocalLength) {
                log.warn("Breaking out of waiting for copy to finish as current local length ({}) hasn't increased from {}", (Object)localLength, (Object)lastLocalLength);
                break;
            }
            lastLocalLength = localLength;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doneCopy(LocalIndexFile file, long start) {
        this.copyCompletionMonitor.enter();
        try {
            this.copyInProgressFiles.remove(file);
        }
        finally {
            this.copyCompletionMonitor.leave();
        }
        this.copyInProgressCount.decrementAndGet();
        this.copyInProgressSize.addAndGet(-file.getSize());
        if (file.isCopyFromRemote()) {
            this.downloadTime.addAndGet(System.currentTimeMillis() - start);
            this.downloadSize.addAndGet(file.getSize());
            this.downloadCount.incrementAndGet();
        } else {
            this.uploadSize.addAndGet(file.getSize());
            this.uploadTime.addAndGet(System.currentTimeMillis() - start);
            this.uploadCount.incrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateMaxScheduled(int val) {
        AtomicInteger atomicInteger = this.maxScheduledForCopyCount;
        synchronized (atomicInteger) {
            int current = this.maxScheduledForCopyCount.get();
            if (val > current) {
                this.maxScheduledForCopyCount.set(val);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateMaxInProgress(int val) {
        AtomicInteger atomicInteger = this.maxCopyInProgressCount;
        synchronized (atomicInteger) {
            int current = this.maxCopyInProgressCount.get();
            if (val > current) {
                this.maxCopyInProgressCount.set(val);
            }
        }
    }

    public void skippedUpload(long skippedFilesSize) {
        this.skippedFromUploadSize.addAndGet(skippedFilesSize);
    }

    public void scheduledForCopy() {
        this.updateMaxScheduled(this.scheduledForCopyCount.incrementAndGet());
    }

    public void copyDone() {
        this.scheduledForCopyCount.decrementAndGet();
    }

    public void readFromRemote(boolean reader) {
        if (reader) {
            this.readerRemoteReadCount.incrementAndGet();
        } else {
            this.writerRemoteReadCount.incrementAndGet();
        }
    }

    public void readFromLocal(boolean reader) {
        if (reader) {
            this.readerLocalReadCount.incrementAndGet();
        } else {
            this.writerLocalReadCount.incrementAndGet();
        }
    }

    public void foundInvalidFile() {
        this.invalidFileCount.incrementAndGet();
    }

    @Override
    public TabularData getIndexPathMapping() {
        TabularDataSupport tds;
        try {
            TabularType tt = new TabularType(IndexMappingData.class.getName(), "Lucene Index Stats", IndexMappingData.TYPE, new String[]{"fsPath"});
            tds = new TabularDataSupport(tt);
            for (LocalIndexDir indexDir : this.indexRootDirectory.getAllLocalIndexes()) {
                String size = IOUtils.humanReadableByteCount(indexDir.size());
                tds.put(new CompositeDataSupport(IndexMappingData.TYPE, IndexMappingData.FIELD_NAMES, new String[]{indexDir.getJcrPath(), indexDir.getFSPath(), size}));
            }
        }
        catch (OpenDataException e) {
            throw new IllegalStateException(e);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return tds;
    }

    @Override
    public boolean isPrefetchEnabled() {
        return this.prefetchEnabled;
    }

    @Override
    public int getReaderLocalReadCount() {
        return this.readerLocalReadCount.get();
    }

    @Override
    public int getReaderRemoteReadCount() {
        return this.readerRemoteReadCount.get();
    }

    @Override
    public int getWriterLocalReadCount() {
        return this.writerLocalReadCount.get();
    }

    @Override
    public int getWriterRemoteReadCount() {
        return this.writerRemoteReadCount.get();
    }

    public int getInvalidFileCount() {
        return this.invalidFileCount.get();
    }

    @Override
    public String getDownloadSize() {
        return IOUtils.humanReadableByteCount(this.downloadSize.get());
    }

    @Override
    public long getDownloadTime() {
        return this.downloadTime.get();
    }

    @Override
    public int getDownloadCount() {
        return this.downloadCount.get();
    }

    @Override
    public int getUploadCount() {
        return this.uploadCount.get();
    }

    @Override
    public String getUploadSize() {
        return IOUtils.humanReadableByteCount(this.uploadSize.get());
    }

    @Override
    public long getUploadTime() {
        return this.uploadTime.get();
    }

    @Override
    public String getLocalIndexSize() {
        return IOUtils.humanReadableByteCount(this.indexRootDirectory.getSize());
    }

    @Override
    public long getLocalIndexDirSize() {
        return this.indexRootDirectory.getSize();
    }

    @Override
    public String[] getGarbageDetails() {
        return (String[])IterableUtils.toArray((Iterable)IterableUtils.transform(this.failedToDeleteFiles.values(), input -> input.deleteLog()), String.class);
    }

    @Override
    public String getGarbageSize() {
        long garbageSize = 0L;
        for (LocalIndexFile failedToDeleteFile : this.failedToDeleteFiles.values()) {
            garbageSize += failedToDeleteFile.getSize();
        }
        return IOUtils.humanReadableByteCount(garbageSize);
    }

    @Override
    public int getScheduledForCopyCount() {
        return this.scheduledForCopyCount.get();
    }

    @Override
    public int getCopyInProgressCount() {
        return this.copyInProgressCount.get();
    }

    @Override
    public String getCopyInProgressSize() {
        return IOUtils.humanReadableByteCount(this.copyInProgressSize.get());
    }

    @Override
    public int getMaxCopyInProgressCount() {
        return this.maxCopyInProgressCount.get();
    }

    @Override
    public int getMaxScheduledForCopyCount() {
        return this.maxScheduledForCopyCount.get();
    }

    @Override
    public String getSkippedFromUploadSize() {
        return IOUtils.humanReadableByteCount(this.skippedFromUploadSize.get());
    }

    @Override
    public String[] getCopyInProgressDetails() {
        return (String[])IterableUtils.toArray((Iterable)IterableUtils.transform(this.copyInProgressFiles, input -> input.copyLog()), String.class);
    }

    @Override
    public int getDeletedFilesCount() {
        return this.deletedFileCount.get();
    }

    @Override
    public String getGarbageCollectedSize() {
        return IOUtils.humanReadableByteCount(this.garbageCollectedSize.get());
    }

    public static interface COWDirectoryTracker {
        public static final COWDirectoryTracker NOOP = new COWDirectoryTracker(){

            @Override
            public void registerOpenedDirectory(CopyOnWriteDirectory directory) {
            }

            @Override
            public void registerReindexingLocalDirectory(File dir) {
            }
        };

        public void registerOpenedDirectory(@NotNull CopyOnWriteDirectory var1);

        public void registerReindexingLocalDirectory(@NotNull File var1);
    }

    private static class IndexMappingData {
        static final String[] FIELD_NAMES = new String[]{"jcrPath", "fsPath", "size"};
        static final String[] FIELD_DESCRIPTIONS = new String[]{"JCR Path", "Filesystem Path", "Size"};
        static final OpenType[] FIELD_TYPES = new OpenType[]{SimpleType.STRING, SimpleType.STRING, SimpleType.STRING};
        static final CompositeType TYPE = IndexMappingData.createCompositeType();

        private IndexMappingData() {
        }

        static CompositeType createCompositeType() {
            try {
                return new CompositeType(IndexMappingData.class.getName(), "Composite data type for Index Mapping Data", FIELD_NAMES, FIELD_DESCRIPTIONS, FIELD_TYPES);
            }
            catch (OpenDataException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    private class DeleteOldDirOnClose
    extends FilterDirectory {
        private final File oldIndexDir;

        protected DeleteOldDirOnClose(Directory in, File oldIndexDir) {
            super(in);
            this.oldIndexDir = oldIndexDir;
        }

        @Override
        public void close() throws IOException {
            try {
                super.close();
            }
            finally {
                try {
                    long totalDeletedSize = FileUtils.sizeOf(this.oldIndexDir);
                    FileUtils.deleteDirectory(this.oldIndexDir);
                    IndexCopier.this.garbageCollectedSize.addAndGet(totalDeletedSize += IndexCopier.this.indexRootDirectory.gcEmptyDirs(this.oldIndexDir));
                    log.debug("Removed old index content from {} ", (Object)this.oldIndexDir);
                }
                catch (IOException e) {
                    log.warn("Not able to remove old version of copied index at {}", (Object)this.oldIndexDir, (Object)e);
                }
            }
        }

        @Override
        public String toString() {
            return "DeleteOldDirOnClose wrapper for " + this.getDelegate();
        }
    }
}

