/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.jackrabbit.oak.plugins.index.search.FieldNames;
import org.apache.jackrabbit.oak.plugins.index.search.IndexStatistics;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiFields;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LuceneIndexStatistics
implements IndexStatistics {
    private static final Logger LOG = LoggerFactory.getLogger(LuceneIndexStatistics.class);
    private final int numDocs;
    private final Map<String, Integer> numDocsForField;
    private final boolean safelyInitialized;
    static boolean failReadingFields = false;
    static boolean failReadingSyntheticallyFalliableField = false;
    static final String SYNTHETICALLY_FALLIABLE_FIELD = "synthetically-falliable-field";

    LuceneIndexStatistics(IndexReader reader) {
        this.numDocs = reader.numDocs();
        HashMap<String, Integer> numDocsForField = new HashMap<String, Integer>();
        Fields fields = null;
        try {
            if (failReadingFields) {
                throw new IOException("Synthetically fail to read fields");
            }
            fields = MultiFields.getFields(reader);
        }
        catch (IOException e) {
            LOG.warn("Couldn't open fields for reader ({}). Won't extract doc count per field", (Object)reader);
            numDocsForField = null;
        }
        if (fields != null) {
            for (String f : fields) {
                if (!FieldNames.isPropertyField((String)f) && !FieldNames.isNullPropsField((String)f)) continue;
                int docCntForField = -1;
                try {
                    if (failReadingSyntheticallyFalliableField && SYNTHETICALLY_FALLIABLE_FIELD.equals(f)) {
                        throw new IOException("Synthetically fail to read count for field jcr:title");
                    }
                    docCntForField = reader.getDocCount(f);
                }
                catch (IOException e) {
                    LOG.warn("Couldn't read doc count for field {} via reader ({}).");
                }
                numDocsForField.put(f, docCntForField);
            }
        }
        if (numDocsForField != null) {
            this.numDocsForField = Collections.unmodifiableMap(numDocsForField);
            this.safelyInitialized = true;
        } else {
            this.numDocsForField = Collections.emptyMap();
            this.safelyInitialized = false;
        }
    }

    public int numDocs() {
        return this.numDocs;
    }

    public int getDocCountFor(String field) {
        int docCntForField;
        if (!this.safelyInitialized) {
            return -1;
        }
        int n = docCntForField = FieldNames.isPropertyField((String)field) ? 0 : -1;
        if (this.numDocsForField.containsKey(field)) {
            docCntForField = this.numDocsForField.get(field);
        }
        return docCntForField;
    }
}

