/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import org.apache.jackrabbit.guava.common.collect.AbstractIterator;
import org.apache.jackrabbit.guava.common.collect.FluentIterable;
import org.apache.jackrabbit.oak.api.PropertyValue;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.commons.PerfLogger;
import org.apache.jackrabbit.oak.commons.collections.IterableUtils;
import org.apache.jackrabbit.oak.commons.collections.IteratorUtils;
import org.apache.jackrabbit.oak.commons.collections.StreamUtils;
import org.apache.jackrabbit.oak.commons.conditions.Validate;
import org.apache.jackrabbit.oak.commons.properties.SystemPropertySupplier;
import org.apache.jackrabbit.oak.plugins.index.lucene.FieldFactory;
import org.apache.jackrabbit.oak.plugins.index.lucene.IndexAugmentorFactory;
import org.apache.jackrabbit.oak.plugins.index.lucene.IndexTracker;
import org.apache.jackrabbit.oak.plugins.index.lucene.LuceneIndexConstants;
import org.apache.jackrabbit.oak.plugins.index.lucene.LuceneIndexDefinition;
import org.apache.jackrabbit.oak.plugins.index.lucene.LuceneIndexLookupUtil;
import org.apache.jackrabbit.oak.plugins.index.lucene.LuceneIndexNode;
import org.apache.jackrabbit.oak.plugins.index.lucene.LuceneIndexStatistics;
import org.apache.jackrabbit.oak.plugins.index.lucene.LuceneRequestFacade;
import org.apache.jackrabbit.oak.plugins.index.lucene.TermFactory;
import org.apache.jackrabbit.oak.plugins.index.lucene.property.HybridPropertyIndexLookup;
import org.apache.jackrabbit.oak.plugins.index.lucene.reader.LuceneIndexReader;
import org.apache.jackrabbit.oak.plugins.index.lucene.spi.FulltextQueryTermsProvider;
import org.apache.jackrabbit.oak.plugins.index.lucene.util.FacetHelper;
import org.apache.jackrabbit.oak.plugins.index.lucene.util.MoreLikeThisHelper;
import org.apache.jackrabbit.oak.plugins.index.lucene.util.PathStoredFieldVisitor;
import org.apache.jackrabbit.oak.plugins.index.lucene.util.SpellcheckHelper;
import org.apache.jackrabbit.oak.plugins.index.lucene.util.SuggestHelper;
import org.apache.jackrabbit.oak.plugins.index.lucene.util.fv.SimSearchUtils;
import org.apache.jackrabbit.oak.plugins.index.lucene.writer.LuceneIndexWriter;
import org.apache.jackrabbit.oak.plugins.index.search.FieldNames;
import org.apache.jackrabbit.oak.plugins.index.search.IndexDefinition;
import org.apache.jackrabbit.oak.plugins.index.search.IndexNode;
import org.apache.jackrabbit.oak.plugins.index.search.PropertyDefinition;
import org.apache.jackrabbit.oak.plugins.index.search.SizeEstimator;
import org.apache.jackrabbit.oak.plugins.index.search.spi.query.FulltextIndex;
import org.apache.jackrabbit.oak.plugins.index.search.spi.query.FulltextIndexPlanner;
import org.apache.jackrabbit.oak.plugins.index.search.util.QueryUtils;
import org.apache.jackrabbit.oak.plugins.memory.PropertyValues;
import org.apache.jackrabbit.oak.spi.query.Cursor;
import org.apache.jackrabbit.oak.spi.query.Filter;
import org.apache.jackrabbit.oak.spi.query.QueryIndex;
import org.apache.jackrabbit.oak.spi.query.QueryLimits;
import org.apache.jackrabbit.oak.spi.query.fulltext.FullTextAnd;
import org.apache.jackrabbit.oak.spi.query.fulltext.FullTextContains;
import org.apache.jackrabbit.oak.spi.query.fulltext.FullTextExpression;
import org.apache.jackrabbit.oak.spi.query.fulltext.FullTextOr;
import org.apache.jackrabbit.oak.spi.query.fulltext.FullTextTerm;
import org.apache.jackrabbit.oak.spi.query.fulltext.FullTextVisitor;
import org.apache.jackrabbit.oak.spi.query.fulltext.VectorQuery;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Document;
import org.apache.lucene.facet.FacetResult;
import org.apache.lucene.facet.Facets;
import org.apache.lucene.facet.LabelAndValue;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.queryparser.classic.QueryParserBase;
import org.apache.lucene.queryparser.flexible.core.QueryNodeException;
import org.apache.lucene.queryparser.flexible.standard.StandardQueryParser;
import org.apache.lucene.queryparser.flexible.standard.config.StandardQueryConfigHandler;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TotalHitCountCollector;
import org.apache.lucene.search.WildcardQuery;
import org.apache.lucene.search.highlight.Highlighter;
import org.apache.lucene.search.highlight.InvalidTokenOffsetsException;
import org.apache.lucene.search.highlight.QueryScorer;
import org.apache.lucene.search.highlight.SimpleHTMLEncoder;
import org.apache.lucene.search.highlight.SimpleHTMLFormatter;
import org.apache.lucene.search.highlight.TextFragment;
import org.apache.lucene.search.postingshighlight.PostingsHighlighter;
import org.apache.lucene.search.spell.SuggestWord;
import org.apache.lucene.search.suggest.Lookup;
import org.apache.lucene.search.suggest.analyzing.AnalyzingInfixSuggester;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.Version;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LucenePropertyIndex
extends FulltextIndex {
    private static final Logger LOG = LoggerFactory.getLogger(LucenePropertyIndex.class);
    private static final PerfLogger PERF_LOGGER = new PerfLogger(LoggerFactory.getLogger(LucenePropertyIndex.class.getName() + ".perf"));
    private static final long LOAD_DOCS_WARN = Long.getLong("oak.lucene.loadDocsWarn", 30000L);
    private static final long LOAD_DOCS_STOP = Long.getLong("oak.lucene.loadDocsStop", 180000L);
    private static final boolean NON_LAZY = (Boolean)SystemPropertySupplier.create((String)"oak.lucene.nonLazyIndex", (Object)true).loggingTo(LOG).get();
    public static final String OLD_FACET_PROVIDER_CONFIG_NAME = "oak.lucene.oldFacetProvider";
    private static final boolean OLD_FACET_PROVIDER = Boolean.getBoolean("oak.lucene.oldFacetProvider");
    public static final String CACHE_FACET_RESULTS_NAME = "oak.lucene.cacheFacetResults";
    private final boolean CACHE_FACET_RESULTS = Boolean.parseBoolean(System.getProperty("oak.lucene.cacheFacetResults", "true"));
    public static final String EAGER_FACET_CACHE_FILL_NAME = "oak.lucene.cacheFacetEagerFill";
    private static final boolean EAGER_FACET_CACHE_FILL = Boolean.parseBoolean(System.getProperty("oak.lucene.cacheFacetEagerFill", "true"));
    private static boolean FLAG_CACHE_FACET_RESULTS_CHANGE = true;
    public static final int LUCENE_QUERY_BATCH_SIZE = 50;
    protected final IndexTracker tracker;
    private final Highlighter highlighter = new Highlighter(new SimpleHTMLFormatter("<strong>", "</strong>"), new SimpleHTMLEncoder(), null);
    private final PostingsHighlighter postingsHighlighter = new PostingsHighlighter();
    private final IndexAugmentorFactory augmentorFactory;

    public LucenePropertyIndex(IndexTracker tracker) {
        this(tracker, null);
    }

    public LucenePropertyIndex(IndexTracker tracker, IndexAugmentorFactory augmentorFactory) {
        this.tracker = tracker;
        this.augmentorFactory = augmentorFactory;
        this.logConfigsOnce();
    }

    private void logConfigsOnce() {
        if (FLAG_CACHE_FACET_RESULTS_CHANGE) {
            LOG.info("oak.lucene.oldFacetProvider = " + OLD_FACET_PROVIDER);
            LOG.info("oak.lucene.cacheFacetResults = " + this.CACHE_FACET_RESULTS);
            FLAG_CACHE_FACET_RESULTS_CHANGE = false;
        }
    }

    public String getIndexName() {
        return "lucene-property";
    }

    public Cursor query(final QueryIndex.IndexPlan plan, NodeState rootState) {
        LuceneResultRowIterator rItr;
        if (plan.isDeprecated()) {
            LOG.warn("This index is deprecated: {}; it is used for query {}. Please change the query or the index definitions.", (Object)plan.getPlanName(), (Object)plan.getFilter());
        }
        final Filter filter = plan.getFilter();
        final Sort sort = LucenePropertyIndex.getSort(plan);
        final FulltextIndexPlanner.PlanResult pr = LucenePropertyIndex.getPlanResult((QueryIndex.IndexPlan)plan);
        QueryLimits settings = filter.getQueryLimits();
        Object itr = rItr = new LuceneResultRowIterator(){
            private final Deque<FulltextIndex.FulltextResultRow> queue = new ArrayDeque<FulltextIndex.FulltextResultRow>();
            private final Set<String> seenPaths = new HashSet<String>();
            private ScoreDoc lastDoc;
            private int nextBatchSize = 50;
            private boolean noDocs = false;
            private IndexSearcher indexSearcher;
            private int indexNodeId = -1;
            private FulltextIndex.FacetProvider facetProvider;
            private int rewoundCount = 0;

            protected FulltextIndex.FulltextResultRow computeNext() {
                if (!this.queue.isEmpty() || this.loadDocs()) {
                    return this.queue.remove();
                }
                this.releaseSearcher();
                return (FulltextIndex.FulltextResultRow)this.endOfData();
            }

            public int rewoundCount() {
                return this.rewoundCount;
            }

            private FulltextIndex.FulltextResultRow convertToRow(ScoreDoc doc, IndexSearcher searcher, Map<String, String> excerpts, FulltextIndex.FacetProvider facetProvider, String explanation) throws IOException {
                IndexReader reader = searcher.getIndexReader();
                PathStoredFieldVisitor visitor = new PathStoredFieldVisitor();
                reader.document(doc.doc, visitor);
                String path = visitor.getPath();
                if (path != null) {
                    if ("".equals(path)) {
                        path = "/";
                    }
                    if (pr.isPathTransformed()) {
                        String originalPath = path;
                        if ((path = pr.transformPath(path)) == null) {
                            LOG.trace("Ignoring path {} : Transformation returned null", (Object)originalPath);
                            return null;
                        }
                        if (this.seenPaths.contains(path)) {
                            LOG.trace("Ignoring path {} : Duplicate post transformation", (Object)originalPath);
                            return null;
                        }
                        this.seenPaths.add(path);
                    }
                    boolean shouldIncludeForHierarchy = LucenePropertyIndex.shouldInclude((String)path, (QueryIndex.IndexPlan)plan);
                    LOG.trace("Matched path {}; shouldIncludeForHierarchy: {}", (Object)path, (Object)shouldIncludeForHierarchy);
                    return shouldIncludeForHierarchy ? new FulltextIndex.FulltextResultRow(path, (double)doc.score, excerpts, facetProvider, explanation) : null;
                }
                return null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            private boolean loadDocs() {
                ScoreDoc lastDocToRecord;
                block38: {
                    int n;
                    SuggestWord[] startLoop2;
                    QueryParser qp;
                    String aclCheckField;
                    IndexSearcher searcher;
                    block37: {
                        int repeated;
                        long startLoop2;
                        long start;
                        Query query;
                        LuceneIndexNode indexNode;
                        block36: {
                            if (this.noDocs) {
                                return false;
                            }
                            lastDocToRecord = null;
                            indexNode = LucenePropertyIndex.this.acquireIndexNode(plan);
                            Validate.checkState((indexNode != null ? 1 : 0) != 0);
                            try {
                                searcher = this.getCurrentSearcher(indexNode);
                                LuceneRequestFacade luceneRequestFacade = LucenePropertyIndex.getLuceneRequest(plan, LucenePropertyIndex.this.augmentorFactory, searcher.getIndexReader());
                                if (luceneRequestFacade.getLuceneRequest() instanceof Query) {
                                    query = (Query)luceneRequestFacade.getLuceneRequest();
                                    start = PERF_LOGGER.start();
                                    startLoop2 = System.currentTimeMillis();
                                    repeated = 0;
                                    break block36;
                                }
                                if (luceneRequestFacade.getLuceneRequest() instanceof SpellcheckHelper.SpellcheckQuery) {
                                    aclCheckField = indexNode.getDefinition().isFullTextEnabled() ? ":fulltext" : ":spellcheck";
                                    this.noDocs = true;
                                    SpellcheckHelper.SpellcheckQuery spellcheckQuery = (SpellcheckHelper.SpellcheckQuery)luceneRequestFacade.getLuceneRequest();
                                    SuggestWord[] suggestWords = SpellcheckHelper.getSpellcheck(spellcheckQuery);
                                    qp = new QueryParser(Version.LUCENE_47, aclCheckField, indexNode.getDefinition().getAnalyzer());
                                    startLoop2 = suggestWords;
                                    n = startLoop2.length;
                                    break block37;
                                }
                                if (!(luceneRequestFacade.getLuceneRequest() instanceof SuggestHelper.SuggestQuery)) break block38;
                                SuggestHelper.SuggestQuery suggestQuery = (SuggestHelper.SuggestQuery)luceneRequestFacade.getLuceneRequest();
                                this.noDocs = true;
                                List<Lookup.LookupResult> lookupResults = SuggestHelper.getSuggestions(indexNode.getLookup(), suggestQuery);
                                QueryParser qp2 = new QueryParser(Version.LUCENE_47, ":suggest", indexNode.getDefinition().isSuggestAnalyzed() ? indexNode.getDefinition().getAnalyzer() : SuggestHelper.getAnalyzer());
                                block5: for (Lookup.LookupResult suggestion : lookupResults) {
                                    Query query2 = qp2.parse("\"" + QueryParserBase.escape(suggestion.key.toString()) + "\"");
                                    query2 = LucenePropertyIndex.addDescendantClauseIfRequired(query2, plan);
                                    TopDocs topDocs = searcher.search(query2, 100);
                                    if (topDocs.totalHits <= 0) continue;
                                    for (ScoreDoc doc : topDocs.scoreDocs) {
                                        Document retrievedDoc = searcher.doc(doc.doc);
                                        String prefix = filter.getPath();
                                        if (prefix.length() == 1) {
                                            prefix = "";
                                        }
                                        if (!filter.isAccessible(prefix + retrievedDoc.get(":path"))) continue;
                                        this.queue.add(new FulltextIndex.FulltextResultRow(suggestion.key.toString(), suggestion.value));
                                        continue block5;
                                    }
                                }
                                break block38;
                            }
                            catch (Exception e) {
                                LOG.warn("query [{}] via {} failed.", plan.getFilter(), ((Object)((Object)LucenePropertyIndex.this)).getClass().getCanonicalName(), e);
                                break block38;
                            }
                            finally {
                                indexNode.release();
                            }
                        }
                        while (true) {
                            TopDocs docs;
                            long now;
                            if (repeated > 0 && (now = System.currentTimeMillis()) > startLoop2 + LOAD_DOCS_WARN) {
                                LOG.warn("loadDocs lastDoc {} repeated {} times for query {}", this.lastDoc, repeated, query);
                                if (repeated > 1 && now > startLoop2 + LOAD_DOCS_STOP) {
                                    LOG.error("loadDocs stops", new Exception());
                                    break block38;
                                }
                            }
                            if (this.lastDoc != null) {
                                LOG.debug("loading the next {} entries for query {}", (Object)this.nextBatchSize, (Object)query);
                                docs = sort == null ? searcher.searchAfter(this.lastDoc, query, this.nextBatchSize) : searcher.searchAfter(this.lastDoc, query, this.nextBatchSize, sort);
                            } else {
                                LOG.debug("loading the first {} entries for query {}", (Object)this.nextBatchSize, (Object)query);
                                docs = sort == null ? searcher.search(query, this.nextBatchSize) : searcher.search(query, this.nextBatchSize, sort);
                            }
                            PERF_LOGGER.end(start, -1L, "{} ...", (Object)docs.scoreDocs.length);
                            this.nextBatchSize = (int)Math.min((long)this.nextBatchSize * 2L, 100000L);
                            if (this.facetProvider == null) {
                                long f = PERF_LOGGER.start();
                                this.facetProvider = OLD_FACET_PROVIDER ? new LuceneFacetProvider(FacetHelper.getFacets(searcher, query, plan, indexNode.getDefinition().getSecureFacetConfiguration())) : new DelayedLuceneFacetProvider(LucenePropertyIndex.this, query, plan, indexNode.getDefinition().getSecureFacetConfiguration());
                                PERF_LOGGER.end(f, -1L, "facets retrieved", new Object[0]);
                            }
                            HashSet<String> excerptFields = new HashSet<String>();
                            for (Filter.PropertyRestriction pr2 : filter.getPropertyRestrictions()) {
                                if (!"rep:excerpt".equals(pr2.propertyName)) continue;
                                String value = pr2.first.getValue(Type.STRING);
                                excerptFields.add(value);
                            }
                            boolean addExcerpt = excerptFields.size() > 0;
                            Filter.PropertyRestriction restriction = filter.getPropertyRestriction("oak:scoreExplanation");
                            boolean addExplain = restriction != null && restriction.isNotNullRestriction();
                            Analyzer analyzer = indexNode.getDefinition().getAnalyzer();
                            FieldInfos mergedFieldInfos = null;
                            if (addExcerpt) {
                                QueryScorer scorer = new QueryScorer(query);
                                scorer.setExpandMultiTermQuery(true);
                                LucenePropertyIndex.this.highlighter.setFragmentScorer(scorer);
                                mergedFieldInfos = MultiFields.getMergedFieldInfos(searcher.getIndexReader());
                            }
                            boolean earlyStop = false;
                            if (docs.scoreDocs.length > 1) {
                                String queryString;
                                void var19_48;
                                Object var19_46 = null;
                                LuceneIndexDefinition defn = indexNode.getDefinition();
                                if (defn.hasFunctionDefined()) {
                                    Filter.PropertyRestriction propertyRestriction = filter.getPropertyRestriction(defn.getFunctionName());
                                }
                                if (var19_48 != null && (queryString = String.valueOf(var19_48.first.getValue(var19_48.first.getType()))).startsWith("mlt?")) {
                                    LinkedList<PropertyDefinition> sp = new LinkedList<PropertyDefinition>();
                                    for (IndexDefinition.IndexingRule r : defn.getDefinedRules()) {
                                        List similarityProperties = r.getSimilarityProperties();
                                        for (PropertyDefinition pd : similarityProperties) {
                                            if (!pd.similarityRerank) continue;
                                            sp.add(pd);
                                        }
                                    }
                                    if (!sp.isEmpty()) {
                                        long fvs = PERF_LOGGER.start();
                                        SimSearchUtils.bruteForceFVRerank(sp, (TopDocs)docs, (IndexSearcher)this.indexSearcher);
                                        PERF_LOGGER.end(fvs, -1L, "fv reranking done", new Object[0]);
                                        earlyStop = true;
                                    }
                                }
                            }
                            for (ScoreDoc doc : docs.scoreDocs) {
                                FulltextIndex.FulltextResultRow row;
                                Map<String, String> excerpts = null;
                                if (addExcerpt) {
                                    excerpts = LucenePropertyIndex.this.getExcerpt(query, excerptFields, analyzer, searcher, doc, mergedFieldInfos);
                                }
                                String explanation = null;
                                if (addExplain) {
                                    explanation = searcher.explain(query, doc.doc).toString();
                                }
                                if ((row = this.convertToRow(doc, searcher, excerpts, this.facetProvider, explanation)) != null) {
                                    this.queue.add(row);
                                }
                                lastDocToRecord = doc;
                            }
                            if (earlyStop) {
                                this.noDocs = true;
                                break block38;
                            } else if (this.queue.isEmpty() && docs.scoreDocs.length > 0) {
                                this.lastDoc = lastDocToRecord;
                                ++repeated;
                                continue;
                            }
                            break block38;
                            break;
                        }
                    }
                    block12: for (int repeated = 0; repeated < n; ++repeated) {
                        SuggestWord suggestion = startLoop2[repeated];
                        Query query = qp.createPhraseQuery(aclCheckField, QueryParserBase.escape(suggestion.string));
                        query = LucenePropertyIndex.addDescendantClauseIfRequired(query, plan);
                        TopDocs topDocs = searcher.search(query, 100);
                        if (topDocs.totalHits <= 0) continue;
                        for (ScoreDoc doc : topDocs.scoreDocs) {
                            Document document = searcher.doc(doc.doc);
                            String prefix = filter.getPath();
                            if (prefix.length() == 1) {
                                prefix = "";
                            }
                            if (!filter.isAccessible(prefix + document.get(":path"))) continue;
                            this.queue.add(new FulltextIndex.FulltextResultRow(suggestion.string));
                            continue block12;
                        }
                    }
                }
                if (lastDocToRecord != null) {
                    this.lastDoc = lastDocToRecord;
                }
                if (this.queue.isEmpty()) return false;
                return true;
            }

            private IndexSearcher getCurrentSearcher(LuceneIndexNode indexNode) {
                if (this.indexNodeId != indexNode.getIndexNodeId()) {
                    if (this.indexNodeId > 0) {
                        LOG.info("Change in index version detected. Query would be performed without offset");
                        ++this.rewoundCount;
                    }
                    this.indexSearcher = indexNode.getSearcher();
                    this.indexNodeId = indexNode.getIndexNodeId();
                    this.lastDoc = null;
                }
                return this.indexSearcher;
            }

            private void releaseSearcher() {
                this.indexSearcher = null;
            }
        };
        SizeEstimator sizeEstimator = this.getSizeEstimator(plan);
        if (pr.hasPropertyIndexResult() || pr.evaluateSyncNodeTypeRestriction()) {
            itr = LucenePropertyIndex.mergePropertyIndexResult(plan, rootState, (Iterator<FulltextIndex.FulltextResultRow>)itr);
        }
        return new FulltextIndex.FulltextPathCursor((Iterator)itr, (FulltextIndex.IteratorRewoundStateProvider)rItr, plan, settings, sizeEstimator);
    }

    private static Query addDescendantClauseIfRequired(Query query, QueryIndex.IndexPlan plan) {
        String path;
        Filter filter = plan.getFilter();
        if (filter.getPathRestriction() == Filter.PathRestriction.ALL_CHILDREN && !PathUtils.denotesRoot(path = LucenePropertyIndex.getPathRestriction((QueryIndex.IndexPlan)plan))) {
            if (LucenePropertyIndex.getPlanResult((QueryIndex.IndexPlan)plan).indexDefinition.evaluatePathRestrictions()) {
                BooleanQuery compositeQuery = new BooleanQuery();
                compositeQuery.add(query, BooleanClause.Occur.MUST);
                TermQuery pathQuery = new TermQuery(TermFactory.newAncestorTerm(path));
                compositeQuery.add(pathQuery, BooleanClause.Occur.MUST);
                query = compositeQuery;
            } else {
                LOG.warn("Descendant clause could not be added without path restrictions enabled. Plan: {}", (Object)plan);
            }
        }
        return query;
    }

    private Map<String, String> getExcerpt(Query query, Set<String> excerptFields, Analyzer analyzer, IndexSearcher searcher, ScoreDoc doc, FieldInfos fieldInfos) throws IOException {
        Object maxPassages;
        Object name;
        HashSet excerptFieldNames = new HashSet();
        HashMap fieldNameToColumnNameMap = new HashMap();
        HashMap<String, String> columnNameToExcerpts = new HashMap<String, String>();
        HashSet nodeExcerptColumns = new HashSet();
        excerptFields.forEach(columnName -> {
            String fieldName = "rep:excerpt".equals(columnName) ? "." : columnName.substring("rep:excerpt".length() + 1, columnName.length() - 1);
            if (!".".equals(fieldName)) {
                excerptFieldNames.add(fieldName);
                fieldNameToColumnNameMap.put(fieldName, columnName);
            } else {
                nodeExcerptColumns.add(columnName);
            }
        });
        boolean requireNodeLevelExcerpt = nodeExcerptColumns.size() > 0;
        int docID = doc.doc;
        LinkedList<String> names = new LinkedList<String>();
        for (IndexableField field : searcher.getIndexReader().document(docID).getFields()) {
            name = field.name();
            if (!((String)name).startsWith("full:") || !fieldInfos.hasProx() || !fieldInfos.hasOffsets()) continue;
            names.add((String)name);
        }
        if (!requireNodeLevelExcerpt) {
            names.retainAll(excerptFieldNames);
        }
        if (names.size() > 0) {
            maxPassages = new int[names.size()];
            Arrays.fill((int[])maxPassages, 1);
            try {
                Map<String, String[]> stringMap = this.postingsHighlighter.highlightFields(names.toArray(new String[names.size()]), query, searcher, new int[]{docID}, (int[])maxPassages);
                for (Map.Entry entry : stringMap.entrySet()) {
                    String value = Arrays.toString((Object[])entry.getValue());
                    if (!value.contains("<b>")) continue;
                    String fieldName = (String)entry.getKey();
                    String columnName2 = (String)fieldNameToColumnNameMap.get(fieldName);
                    columnNameToExcerpts.put(columnName2, value);
                }
            }
            catch (Exception e) {
                LOG.debug("postings highlighting failed", e);
            }
        }
        if (columnNameToExcerpts.size() == 0) {
            maxPassages = searcher.getIndexReader().document(doc.doc).getFields().iterator();
            while (maxPassages.hasNext()) {
                IndexableField field;
                field = (IndexableField)maxPassages.next();
                name = field.name();
                if (!((String)name).startsWith(":fulltext") && !((String)name).startsWith("full:")) continue;
                String string = field.stringValue();
                TokenStream tokenStream = analyzer.tokenStream((String)name, string);
                try {
                    TextFragment[] textFragments = this.highlighter.getBestTextFragments(tokenStream, string, true, 1);
                    if (textFragments == null || textFragments.length <= 0) continue;
                    for (TextFragment fragment : textFragments) {
                        Object columnName3 = null;
                        if (((String)name).startsWith("full:")) {
                            columnName3 = (String)fieldNameToColumnNameMap.get(((String)name).substring("full:".length()));
                        }
                        if (columnName3 == null && requireNodeLevelExcerpt) {
                            columnName3 = name;
                        }
                        if (columnName3 == null) continue;
                        columnNameToExcerpts.put((String)columnName3, fragment.toString());
                    }
                    if (excerptFieldNames.size() != 0) continue;
                    break;
                }
                catch (InvalidTokenOffsetsException e) {
                    LOG.error("highlighting failed", e);
                }
            }
        }
        if (requireNodeLevelExcerpt) {
            String nodeExcerpt = String.join((CharSequence)"...", columnNameToExcerpts.values());
            nodeExcerptColumns.forEach(nodeExcerptColumnName -> columnNameToExcerpts.put((String)nodeExcerptColumnName, nodeExcerpt));
        }
        columnNameToExcerpts.keySet().retainAll(excerptFields);
        return columnNameToExcerpts;
    }

    protected LuceneIndexNode acquireIndexNode(String indexPath) {
        if (NON_LAZY) {
            return this.tracker.acquireIndexNode(indexPath);
        }
        return new LazyLuceneIndexNode(this.tracker, indexPath);
    }

    protected LuceneIndexNode acquireIndexNode(QueryIndex.IndexPlan plan) {
        return (LuceneIndexNode)super.acquireIndexNode(plan);
    }

    protected String getType() {
        return "lucene";
    }

    protected boolean filterReplacedIndexes() {
        return this.tracker.getMountInfoProvider().hasNonDefaultMounts();
    }

    protected boolean runIsActiveIndexCheck() {
        return this.filterReplacedIndexes();
    }

    protected SizeEstimator getSizeEstimator(QueryIndex.IndexPlan plan) {
        return () -> {
            LuceneIndexNode indexNode = this.acquireIndexNode(plan);
            Validate.checkState((indexNode != null ? 1 : 0) != 0);
            try {
                IndexSearcher searcher = indexNode.getSearcher();
                LuceneRequestFacade luceneRequestFacade = LucenePropertyIndex.getLuceneRequest(plan, this.augmentorFactory, searcher.getIndexReader());
                if (luceneRequestFacade.getLuceneRequest() instanceof Query) {
                    Query query = (Query)luceneRequestFacade.getLuceneRequest();
                    TotalHitCountCollector collector = new TotalHitCountCollector();
                    searcher.search(query, collector);
                    int totalHits = collector.getTotalHits();
                    LOG.debug("Estimated size for query {} is {}", (Object)query, (Object)totalHits);
                    long l = totalHits;
                    return l;
                }
                LOG.debug("estimate size: not a Query: {}", luceneRequestFacade.getLuceneRequest());
            }
            catch (IOException e) {
                LOG.warn("query via {} failed.", (Object)this, (Object)e);
            }
            finally {
                indexNode.release();
            }
            return -1L;
        };
    }

    protected Predicate<NodeState> getIndexDefinitionPredicate() {
        return LuceneIndexLookupUtil.LUCENE_INDEX_DEFINITION_PREDICATE;
    }

    protected String getFulltextRequestString(QueryIndex.IndexPlan plan, IndexNode indexNode, NodeState root) {
        return LucenePropertyIndex.getLuceneRequest(plan, this.augmentorFactory, null).toString();
    }

    private static Sort getSort(QueryIndex.IndexPlan plan) {
        List<QueryIndex.OrderEntry> sortOrder = plan.getSortOrder();
        if (sortOrder == null || sortOrder.isEmpty()) {
            return null;
        }
        sortOrder = LucenePropertyIndex.removeNativeSort(sortOrder);
        ArrayList<SortField> fieldsList = new ArrayList<SortField>(sortOrder.size());
        FulltextIndexPlanner.PlanResult planResult = LucenePropertyIndex.getPlanResult((QueryIndex.IndexPlan)plan);
        for (int i = 0; i < sortOrder.size(); ++i) {
            QueryIndex.OrderEntry oe = sortOrder.get(i);
            PropertyDefinition pd = planResult.getOrderedProperty(i);
            boolean reverse = oe.getOrder() != QueryIndex.OrderEntry.Order.ASCENDING;
            String propName = oe.getPropertyName();
            propName = FieldNames.createDocValFieldName((String)propName);
            fieldsList.add(new SortField(propName, LucenePropertyIndex.toLuceneSortType(oe, pd), reverse));
        }
        if (fieldsList.isEmpty()) {
            return null;
        }
        return new Sort(fieldsList.toArray(new SortField[0]));
    }

    private static List<QueryIndex.OrderEntry> removeNativeSort(List<QueryIndex.OrderEntry> original) {
        if (original == null || original.isEmpty()) {
            return original;
        }
        ArrayList<QueryIndex.OrderEntry> result = new ArrayList<QueryIndex.OrderEntry>();
        for (QueryIndex.OrderEntry oe : original) {
            if (LucenePropertyIndex.isNativeSort(oe)) continue;
            result.add(oe);
        }
        return result;
    }

    private static boolean isNativeSort(QueryIndex.OrderEntry oe) {
        return oe.getPropertyName().equals(IndexDefinition.NATIVE_SORT_ORDER.getPropertyName());
    }

    private static SortField.Type toLuceneSortType(QueryIndex.OrderEntry oe, PropertyDefinition defn) {
        Type<?> t = oe.getPropertyType();
        Validate.checkState((t != null ? 1 : 0) != 0, (Object)"Type cannot be null");
        Validate.checkState((!t.isArray() ? 1 : 0) != 0, (Object)"Array types are not supported");
        int type = LucenePropertyIndex.getPropertyType((PropertyDefinition)defn, (String)oe.getPropertyName(), (int)t.tag());
        switch (type) {
            case 3: 
            case 5: {
                return SortField.Type.LONG;
            }
            case 4: {
                return SortField.Type.DOUBLE;
            }
        }
        return SortField.Type.STRING;
    }

    private static LuceneRequestFacade getLuceneRequest(QueryIndex.IndexPlan plan, IndexAugmentorFactory augmentorFactory, IndexReader reader) {
        FulltextQueryTermsProvider augmentor = LucenePropertyIndex.getIndexAgumentor(plan, augmentorFactory);
        ArrayList<Query> qs = new ArrayList<Query>();
        Filter filter = plan.getFilter();
        FullTextExpression ft = filter.getFullTextConstraint();
        FulltextIndexPlanner.PlanResult planResult = LucenePropertyIndex.getPlanResult((QueryIndex.IndexPlan)plan);
        LuceneIndexDefinition defn = (LuceneIndexDefinition)planResult.indexDefinition;
        Analyzer analyzer = defn.getAnalyzer();
        if (ft != null) {
            qs.add(LucenePropertyIndex.getFullTextQuery(plan, ft, analyzer, augmentor));
        }
        Filter.PropertyRestriction pr = null;
        if (defn.hasFunctionDefined()) {
            pr = filter.getPropertyRestriction(defn.getFunctionName());
        }
        if (pr != null) {
            String query = String.valueOf(pr.first.getValue(pr.first.getType()));
            QueryParser queryParser = new QueryParser(LuceneIndexConstants.VERSION, "", analyzer);
            if (query.startsWith("mlt?")) {
                String mltQueryString = query.replace("mlt?", "");
                if (reader != null) {
                    LinkedList sp = new LinkedList();
                    for (IndexDefinition.IndexingRule r : defn.getDefinedRules()) {
                        sp.addAll(r.getSimilarityProperties());
                    }
                    if (sp.isEmpty()) {
                        Query moreLikeThis = MoreLikeThisHelper.getMoreLikeThis(reader, analyzer, mltQueryString);
                        if (moreLikeThis != null) {
                            qs.add(moreLikeThis);
                        }
                    } else {
                        Query similarityQuery = SimSearchUtils.getSimilarityQuery(sp, (IndexReader)reader, (String)mltQueryString);
                        if (similarityQuery != null) {
                            qs.add(similarityQuery);
                        }
                    }
                }
            } else if (query.startsWith("spellcheck?")) {
                String spellcheckQueryString = query.replace("spellcheck?", "");
                if (reader != null) {
                    return new LuceneRequestFacade<SpellcheckHelper.SpellcheckQuery>(SpellcheckHelper.getSpellcheckQuery(spellcheckQueryString, reader));
                }
            } else if (query.startsWith("suggest?")) {
                String suggestQueryString = query.replace("suggest?", "");
                if (reader != null) {
                    return new LuceneRequestFacade<SuggestHelper.SuggestQuery>(SuggestHelper.getSuggestQuery(suggestQueryString));
                }
            } else {
                try {
                    qs.add(queryParser.parse(query));
                }
                catch (ParseException e) {
                    throw new RuntimeException(e);
                }
            }
        } else if (planResult.evaluateNonFullTextConstraints()) {
            LucenePropertyIndex.addNonFullTextConstraints(qs, plan, reader);
        }
        if (qs.size() == 0 && plan.getSortOrder() != null) {
            List<QueryIndex.OrderEntry> orders = LucenePropertyIndex.removeNativeSort(plan.getSortOrder());
            for (int i = 0; i < orders.size(); ++i) {
                QueryIndex.OrderEntry oe = orders.get(i);
                PropertyDefinition pd = planResult.getOrderedProperty(i);
                Filter.PropertyRestriction orderRest = new Filter.PropertyRestriction();
                orderRest.propertyName = oe.getPropertyName();
                Query q = LucenePropertyIndex.createQuery(oe.getPropertyName(), orderRest, pd);
                if (q == null) continue;
                qs.add(q);
            }
        }
        if (qs.size() == 0) {
            if (reader == null) {
                return new LuceneRequestFacade<MatchAllDocsQuery>(new MatchAllDocsQuery());
            }
            if (planResult.evaluateNodeTypeRestriction()) {
                return new LuceneRequestFacade<MatchAllDocsQuery>(new MatchAllDocsQuery());
            }
            throw new IllegalStateException("No query created for filter " + filter);
        }
        return LucenePropertyIndex.performAdditionalWraps(qs);
    }

    @NotNull
    public static LuceneRequestFacade<Query> performAdditionalWraps(@NotNull List<Query> qs) {
        if (qs.size() == 1) {
            Query q = qs.get(0);
            if (q instanceof BooleanQuery) {
                BooleanQuery ibq = (BooleanQuery)q;
                boolean onlyNotClauses = true;
                for (BooleanClause c : ibq.getClauses()) {
                    if (c.getOccur() == BooleanClause.Occur.MUST_NOT) continue;
                    onlyNotClauses = false;
                    break;
                }
                if (onlyNotClauses) {
                    ibq.add(new MatchAllDocsQuery(), BooleanClause.Occur.SHOULD);
                }
            }
            return new LuceneRequestFacade<Query>(qs.get(0));
        }
        BooleanQuery bq = new BooleanQuery();
        for (Query q : qs) {
            boolean unwrapped = false;
            if (q instanceof BooleanQuery) {
                unwrapped = LucenePropertyIndex.unwrapMustNot((BooleanQuery)q, bq);
            }
            if (unwrapped) continue;
            bq.add(q, BooleanClause.Occur.MUST);
        }
        return new LuceneRequestFacade<Query>(bq);
    }

    private static boolean unwrapMustNot(@NotNull BooleanQuery input, @NotNull BooleanQuery output) {
        Objects.requireNonNull(input);
        Objects.requireNonNull(output);
        boolean unwrapped = false;
        for (BooleanClause bc : input.getClauses()) {
            if (bc.getOccur() != BooleanClause.Occur.MUST_NOT) continue;
            output.add(bc);
            unwrapped = true;
        }
        if (unwrapped) {
            for (BooleanClause bc : input.getClauses()) {
                if (bc.getOccur() != BooleanClause.Occur.MUST) continue;
                output.add(bc);
            }
        }
        return unwrapped;
    }

    private static FulltextQueryTermsProvider getIndexAgumentor(QueryIndex.IndexPlan plan, IndexAugmentorFactory augmentorFactory) {
        FulltextIndexPlanner.PlanResult planResult = LucenePropertyIndex.getPlanResult((QueryIndex.IndexPlan)plan);
        if (augmentorFactory != null) {
            return augmentorFactory.getFulltextQueryTermsProvider(planResult.indexingRule.getNodeTypeName());
        }
        return null;
    }

    private static void addNonFullTextConstraints(List<Query> qs, QueryIndex.IndexPlan plan, IndexReader reader) {
        Filter filter = plan.getFilter();
        FulltextIndexPlanner.PlanResult planResult = LucenePropertyIndex.getPlanResult((QueryIndex.IndexPlan)plan);
        IndexDefinition defn = planResult.indexDefinition;
        if (!filter.matchesAllTypes()) {
            LucenePropertyIndex.addNodeTypeConstraints(planResult.indexingRule, qs, filter);
        }
        String path = LucenePropertyIndex.getPathRestriction((QueryIndex.IndexPlan)plan);
        switch (filter.getPathRestriction()) {
            case ALL_CHILDREN: {
                if (!defn.evaluatePathRestrictions() || "/".equals(path)) break;
                qs.add(new TermQuery(TermFactory.newAncestorTerm(path)));
                break;
            }
            case DIRECT_CHILDREN: {
                if (!defn.evaluatePathRestrictions()) break;
                BooleanQuery bq = new BooleanQuery();
                bq.add(new BooleanClause(new TermQuery(TermFactory.newAncestorTerm(path)), BooleanClause.Occur.MUST));
                bq.add(new BooleanClause(LucenePropertyIndex.newDepthQuery(path, planResult), BooleanClause.Occur.MUST));
                qs.add(bq);
                break;
            }
            case EXACT: {
                String parentPathSegment;
                if (planResult.isPathTransformed()) {
                    parentPathSegment = planResult.getParentPathSegment();
                    if (StreamUtils.toStream(PathUtils.elements(parentPathSegment)).anyMatch("*"::equals)) break;
                    qs.add(new TermQuery(TermFactory.newPathTerm(path + parentPathSegment)));
                    break;
                }
                qs.add(new TermQuery(TermFactory.newPathTerm(path)));
                break;
            }
            case PARENT: {
                String parentPathSegment;
                if (PathUtils.denotesRoot(path)) {
                    qs.add(new TermQuery(new Term(":path", "///")));
                    break;
                }
                if (planResult.isPathTransformed()) {
                    parentPathSegment = planResult.getParentPathSegment();
                    if (StreamUtils.toStream(PathUtils.elements(parentPathSegment)).anyMatch("*"::equals)) break;
                    qs.add(new TermQuery(TermFactory.newPathTerm(PathUtils.getParentPath(path) + parentPathSegment)));
                    break;
                }
                qs.add(new TermQuery(TermFactory.newPathTerm(PathUtils.getParentPath(path))));
                break;
            }
        }
        for (Filter.PropertyRestriction pr : filter.getPropertyRestrictions()) {
            Query q;
            PropertyDefinition pd;
            String name = pr.propertyName;
            if ("rep:excerpt".equals(name) || "oak:scoreExplanation".equals(name) || "rep:facet".equals(name)) continue;
            if (":localname".equals(name)) {
                Query q2;
                if (!planResult.evaluateNodeNameRestriction() || (q2 = LucenePropertyIndex.createNodeNameQuery(pr)) == null) continue;
                qs.add(q2);
                continue;
            }
            if (":indexTag".equals(name) || ":indexName".equals(name)) continue;
            if (pr.first != null && pr.first.equals(pr.last) && pr.firstIncluding && pr.lastIncluding) {
                String first = pr.first.getValue(Type.STRING);
                first = first.replace("\\", "");
                if ("jcr:path".equals(name)) {
                    qs.add(new TermQuery(TermFactory.newPathTerm(first)));
                    continue;
                }
                if ("*".equals(name)) {
                    LucenePropertyIndex.addReferenceConstraint(first, qs, reader);
                    continue;
                }
            }
            if ((pd = planResult.getPropDefn(pr)) == null || (q = LucenePropertyIndex.createQuery(planResult.getPropertyName(pr), pr, pd)) == null) continue;
            qs.add(q);
        }
    }

    private static Query createLikeQuery(String name, String first) {
        first = QueryUtils.sqlLikeToLuceneWildcardQuery((String)first);
        int indexOfWS = first.indexOf(42);
        int indexOfWC = first.indexOf(63);
        int len = first.length();
        if (indexOfWS == len || indexOfWC == len) {
            first = first.substring(0, first.length() - 1);
            if ("jcr:path".equals(name)) {
                return new PrefixQuery(TermFactory.newPathTerm(first));
            }
            return new PrefixQuery(new Term(name, first));
        }
        if ("jcr:path".equals(name)) {
            return new WildcardQuery(TermFactory.newPathTerm(first));
        }
        return new WildcardQuery(new Term(name, first));
    }

    @Nullable
    private static Query createQuery(String propertyName, Filter.PropertyRestriction pr, PropertyDefinition defn) {
        int propType = LucenePropertyIndex.determinePropertyType((PropertyDefinition)defn, (Filter.PropertyRestriction)pr);
        if (pr.isNullRestriction()) {
            return new TermQuery(new Term(":nullProps", defn.name));
        }
        if (pr.isNotNullRestriction() && defn.notNullCheckEnabled) {
            return new TermQuery(new Term(":notNullProps", defn.name));
        }
        switch (propType) {
            case 5: {
                Long not;
                Long first = pr.first != null ? FieldFactory.dateToLong(pr.first.getValue(Type.DATE)) : null;
                Long last = pr.last != null ? FieldFactory.dateToLong(pr.last.getValue(Type.DATE)) : null;
                Long l = not = pr.not != null ? FieldFactory.dateToLong(pr.not.getValue(Type.DATE)) : null;
                if (pr.first != null && pr.first.equals(pr.last) && pr.firstIncluding && pr.lastIncluding) {
                    return NumericRangeQuery.newLongRange(propertyName, first, first, true, true);
                }
                if (pr.first != null && pr.last != null) {
                    return NumericRangeQuery.newLongRange(propertyName, first, last, pr.firstIncluding, pr.lastIncluding);
                }
                if (pr.first != null && pr.last == null) {
                    return NumericRangeQuery.newLongRange(propertyName, first, null, pr.firstIncluding, true);
                }
                if (pr.last != null && !pr.last.equals(pr.first)) {
                    return NumericRangeQuery.newLongRange(propertyName, null, last, true, pr.lastIncluding);
                }
                if (pr.list != null) {
                    BooleanQuery in = new BooleanQuery();
                    for (PropertyValue value : pr.list) {
                        Long dateVal = FieldFactory.dateToLong(value.getValue(Type.DATE));
                        in.add(NumericRangeQuery.newLongRange(propertyName, dateVal, dateVal, true, true), BooleanClause.Occur.SHOULD);
                    }
                    return in;
                }
                if (pr.isNotNullRestriction()) {
                    return NumericRangeQuery.newLongRange(propertyName, Long.MIN_VALUE, Long.MAX_VALUE, true, true);
                }
                if (!pr.isNot || pr.not == null) break;
                BooleanQuery bool = new BooleanQuery();
                bool.add(NumericRangeQuery.newLongRange(propertyName, not, not, true, true), BooleanClause.Occur.MUST_NOT);
                return bool;
            }
            case 4: {
                Double last;
                Double first = pr.first != null ? pr.first.getValue(Type.DOUBLE) : null;
                Double d = last = pr.last != null ? pr.last.getValue(Type.DOUBLE) : null;
                if (pr.first != null && pr.first.equals(pr.last) && pr.firstIncluding && pr.lastIncluding) {
                    return NumericRangeQuery.newDoubleRange(propertyName, first, first, true, true);
                }
                if (pr.first != null && pr.last != null) {
                    return NumericRangeQuery.newDoubleRange(propertyName, first, last, pr.firstIncluding, pr.lastIncluding);
                }
                if (pr.first != null && pr.last == null) {
                    return NumericRangeQuery.newDoubleRange(propertyName, first, null, pr.firstIncluding, true);
                }
                if (pr.last != null && !pr.last.equals(pr.first)) {
                    return NumericRangeQuery.newDoubleRange(propertyName, null, last, true, pr.lastIncluding);
                }
                if (pr.list != null) {
                    BooleanQuery in = new BooleanQuery();
                    for (PropertyValue value : pr.list) {
                        Double doubleVal = value.getValue(Type.DOUBLE);
                        in.add(NumericRangeQuery.newDoubleRange(propertyName, doubleVal, doubleVal, true, true), BooleanClause.Occur.SHOULD);
                    }
                    return in;
                }
                if (pr.isNotNullRestriction()) {
                    return NumericRangeQuery.newDoubleRange(propertyName, Double.MIN_VALUE, Double.MAX_VALUE, true, true);
                }
                if (!pr.isNot || pr.not == null) break;
                BooleanQuery bool = new BooleanQuery();
                bool.add(NumericRangeQuery.newDoubleRange(propertyName, pr.not.getValue(Type.DOUBLE), pr.not.getValue(Type.DOUBLE), true, true), BooleanClause.Occur.MUST_NOT);
                return bool;
            }
            case 3: {
                Long last;
                Long first = pr.first != null ? pr.first.getValue(Type.LONG) : null;
                Long l = last = pr.last != null ? pr.last.getValue(Type.LONG) : null;
                if (pr.first != null && pr.first.equals(pr.last) && pr.firstIncluding && pr.lastIncluding) {
                    return NumericRangeQuery.newLongRange(propertyName, first, first, true, true);
                }
                if (pr.first != null && pr.last != null) {
                    return NumericRangeQuery.newLongRange(propertyName, first, last, pr.firstIncluding, pr.lastIncluding);
                }
                if (pr.first != null && pr.last == null) {
                    return NumericRangeQuery.newLongRange(propertyName, first, null, pr.firstIncluding, true);
                }
                if (pr.last != null && !pr.last.equals(pr.first)) {
                    return NumericRangeQuery.newLongRange(propertyName, null, last, true, pr.lastIncluding);
                }
                if (pr.list != null) {
                    BooleanQuery in = new BooleanQuery();
                    for (PropertyValue value : pr.list) {
                        Long longVal = value.getValue(Type.LONG);
                        in.add(NumericRangeQuery.newLongRange(propertyName, longVal, longVal, true, true), BooleanClause.Occur.SHOULD);
                    }
                    return in;
                }
                if (pr.isNotNullRestriction()) {
                    return NumericRangeQuery.newLongRange(propertyName, Long.MIN_VALUE, Long.MAX_VALUE, true, true);
                }
                if (!pr.isNot || pr.not == null) break;
                BooleanQuery bool = new BooleanQuery();
                bool.add(NumericRangeQuery.newLongRange(propertyName, pr.not.getValue(Type.LONG), pr.not.getValue(Type.LONG), true, true), BooleanClause.Occur.MUST_NOT);
                return bool;
            }
            default: {
                String last;
                if (pr.isLike) {
                    return LucenePropertyIndex.createLikeQuery(propertyName, pr.first.getValue(Type.STRING));
                }
                String first = pr.first != null ? pr.first.getValue(Type.STRING) : null;
                String string = last = pr.last != null ? pr.last.getValue(Type.STRING) : null;
                if (pr.first != null && pr.first.equals(pr.last) && pr.firstIncluding && pr.lastIncluding) {
                    return new TermQuery(new Term(propertyName, first));
                }
                if (pr.first != null && pr.last != null) {
                    return TermRangeQuery.newStringRange(propertyName, first, last, pr.firstIncluding, pr.lastIncluding);
                }
                if (pr.first != null && pr.last == null) {
                    return TermRangeQuery.newStringRange(propertyName, first, null, pr.firstIncluding, true);
                }
                if (pr.last != null && !pr.last.equals(pr.first)) {
                    return TermRangeQuery.newStringRange(propertyName, null, last, true, pr.lastIncluding);
                }
                if (pr.list != null) {
                    BooleanQuery in = new BooleanQuery();
                    for (PropertyValue value : pr.list) {
                        String strVal = value.getValue(Type.STRING);
                        in.add(new TermQuery(new Term(propertyName, strVal)), BooleanClause.Occur.SHOULD);
                    }
                    return in;
                }
                if (pr.isNotNullRestriction()) {
                    return new TermRangeQuery(propertyName, null, null, true, true);
                }
                if (!pr.isNot || pr.not == null) break;
                BooleanQuery bool = new BooleanQuery();
                bool.add(new TermQuery(new Term(propertyName, pr.not.getValue(Type.STRING))), BooleanClause.Occur.MUST_NOT);
                return bool;
            }
        }
        throw new IllegalStateException("PropertyRestriction not handled " + pr + " for index " + defn);
    }

    static long getVersion(IndexSearcher indexSearcher) {
        IndexReader reader = indexSearcher.getIndexReader();
        if (reader instanceof DirectoryReader) {
            return ((DirectoryReader)reader).getVersion();
        }
        return -1L;
    }

    private static Query createNodeNameQuery(Filter.PropertyRestriction pr) {
        String first;
        String string = first = pr.first != null ? pr.first.getValue(Type.STRING) : null;
        if (pr.first != null && pr.first.equals(pr.last) && pr.firstIncluding && pr.lastIncluding) {
            return new TermQuery(new Term(":nodeName", first));
        }
        if (pr.isLike) {
            return LucenePropertyIndex.createLikeQuery(":nodeName", first);
        }
        throw new IllegalStateException("For nodeName queries only EQUALS and LIKE are supported " + pr);
    }

    private static void addReferenceConstraint(String uuid, List<Query> qs, IndexReader reader) {
        if (reader == null) {
            qs.add(new TermQuery(new Term("*", uuid)));
            return;
        }
        BooleanQuery bq = new BooleanQuery();
        Collection<String> fields = MultiFields.getIndexedFields(reader);
        for (String f : fields) {
            bq.add(new TermQuery(new Term(f, uuid)), BooleanClause.Occur.SHOULD);
        }
        qs.add(bq);
    }

    private static void addNodeTypeConstraints(IndexDefinition.IndexingRule defn, List<Query> qs, Filter filter) {
        PropertyDefinition mixinType;
        BooleanQuery bq = new BooleanQuery();
        PropertyDefinition primaryType = defn.getConfig("jcr:primaryType");
        if (primaryType != null && primaryType.propertyIndex) {
            for (String type : filter.getPrimaryTypes()) {
                bq.add(new TermQuery(new Term("jcr:primaryType", type)), BooleanClause.Occur.SHOULD);
            }
        }
        if ((mixinType = defn.getConfig("jcr:mixinTypes")) != null && mixinType.propertyIndex) {
            for (String type : filter.getMixinTypes()) {
                bq.add(new TermQuery(new Term("jcr:mixinTypes", type)), BooleanClause.Occur.SHOULD);
            }
        }
        if (bq.clauses().size() != 0) {
            qs.add(bq);
        }
    }

    static Query getFullTextQuery(final QueryIndex.IndexPlan plan, FullTextExpression ft, final Analyzer analyzer, final FulltextQueryTermsProvider augmentor) {
        final FulltextIndexPlanner.PlanResult pr = LucenePropertyIndex.getPlanResult((QueryIndex.IndexPlan)plan);
        final AtomicReference result = new AtomicReference();
        ft.accept(new FullTextVisitor(){

            @Override
            public boolean visit(FullTextContains contains) {
                this.visitTerm(contains.getPropertyName(), contains.getRawText(), null, contains.isNot());
                return true;
            }

            @Override
            public boolean visit(FullTextOr or) {
                BooleanQuery q = new BooleanQuery();
                for (FullTextExpression e : or.list) {
                    Query x = LucenePropertyIndex.getFullTextQuery(plan, e, analyzer, augmentor);
                    q.add(x, BooleanClause.Occur.SHOULD);
                }
                result.set(q);
                return true;
            }

            @Override
            public boolean visit(FullTextAnd and) {
                BooleanQuery q = new BooleanQuery();
                for (FullTextExpression e : and.list) {
                    BooleanQuery bq;
                    Query x = LucenePropertyIndex.getFullTextQuery(plan, e, analyzer, augmentor);
                    boolean hasMustNot = false;
                    if (x instanceof BooleanQuery && (bq = (BooleanQuery)x).getClauses().length == 1 && bq.getClauses()[0].getOccur() == BooleanClause.Occur.MUST_NOT) {
                        hasMustNot = true;
                        q.add(bq.getClauses()[0]);
                    }
                    if (hasMustNot) continue;
                    q.add(x, BooleanClause.Occur.MUST);
                }
                result.set(q);
                return true;
            }

            @Override
            public boolean visit(FullTextTerm term) {
                return this.visitTerm(term.getPropertyName(), term.getText(), term.getBoost(), term.isNot());
            }

            private boolean visitTerm(String propertyName, String text, String boost, boolean not) {
                Query q;
                String p = LucenePropertyIndex.getLuceneFieldName(propertyName, pr);
                if (propertyName == null) {
                    VectorQuery vectorQuery = new VectorQuery(text);
                    text = vectorQuery.getQueryText();
                }
                if ((q = LucenePropertyIndex.tokenToQuery(text, p, pr, analyzer, augmentor)) == null) {
                    return false;
                }
                if (boost != null) {
                    q.setBoost(Float.parseFloat(boost));
                }
                if (not) {
                    BooleanQuery bq = new BooleanQuery();
                    bq.add(q, BooleanClause.Occur.MUST_NOT);
                    result.set(bq);
                } else {
                    result.set(q);
                }
                return true;
            }
        });
        return (Query)result.get();
    }

    static String getLuceneFieldName(@Nullable String p, FulltextIndexPlanner.PlanResult pr) {
        if (p == null) {
            return ":fulltext";
        }
        if (LucenePropertyIndex.isNodePath((String)p)) {
            p = pr.isPathTransformed() ? PathUtils.getName(p) : FieldNames.createFulltextFieldName((String)PathUtils.getParentPath(p));
        } else {
            if (pr.isPathTransformed()) {
                p = PathUtils.getName(p);
            }
            p = FieldNames.createAnalyzedFieldName((String)p);
        }
        if ("*".equals(p)) {
            p = ":fulltext";
        }
        return p;
    }

    private static Query tokenToQuery(String text, String fieldName, FulltextIndexPlanner.PlanResult pr, Analyzer analyzer, FulltextQueryTermsProvider augmentor) {
        Query ret;
        IndexDefinition.IndexingRule indexingRule = pr.indexingRule;
        if (":fulltext".equals(fieldName) && !indexingRule.getNodeScopeAnalyzedProps().isEmpty()) {
            BooleanQuery in = new BooleanQuery();
            for (PropertyDefinition pd : indexingRule.getNodeScopeAnalyzedProps()) {
                Query q = LucenePropertyIndex.tokenToQuery(text, FieldNames.createAnalyzedFieldName((String)pd.name), analyzer);
                q.setBoost(pd.boost);
                in.add(q, BooleanClause.Occur.SHOULD);
            }
            in.add(LucenePropertyIndex.tokenToQuery(text, fieldName, analyzer), BooleanClause.Occur.SHOULD);
            ret = in;
        } else {
            ret = LucenePropertyIndex.tokenToQuery(text, fieldName, analyzer);
        }
        if (":fulltext".equals(fieldName)) {
            Query subQuery = new BooleanQuery();
            if (pr.indexDefinition.isDynamicBoostLiteEnabled()) {
                subQuery = LucenePropertyIndex.tokenToQuery(text, "simtags", analyzer);
                subQuery.setBoost(1.0E-4f);
            } else if (augmentor != null) {
                subQuery = augmentor.getQueryTerm(text, analyzer, pr.indexDefinition.getDefinitionNodeState());
            }
            if (subQuery != null) {
                BooleanQuery query = new BooleanQuery();
                query.add(ret, BooleanClause.Occur.SHOULD);
                query.add(subQuery, BooleanClause.Occur.SHOULD);
                ret = query;
            }
        }
        return ret;
    }

    static Query tokenToQuery(String text, String fieldName, Analyzer analyzer) {
        if (analyzer == null) {
            return null;
        }
        StandardQueryParser parserHelper = new StandardQueryParser(analyzer);
        parserHelper.setAllowLeadingWildcard(true);
        parserHelper.setDefaultOperator(StandardQueryConfigHandler.Operator.AND);
        text = LucenePropertyIndex.rewriteQueryText((String)text);
        try {
            return parserHelper.parse(text, fieldName);
        }
        catch (QueryNodeException e) {
            throw new RuntimeException(e);
        }
    }

    private static Query newDepthQuery(String path, FulltextIndexPlanner.PlanResult planResult) {
        int depth = PathUtils.getDepth(path) + planResult.getParentDepth() + 1;
        return NumericRangeQuery.newIntRange(":depth", depth, depth, true, true);
    }

    private static Iterator<FulltextIndex.FulltextResultRow> mergePropertyIndexResult(QueryIndex.IndexPlan plan, NodeState rootState, Iterator<FulltextIndex.FulltextResultRow> itr) {
        FluentIterable paths;
        FulltextIndexPlanner.PlanResult pr = LucenePropertyIndex.getPlanResult((QueryIndex.IndexPlan)plan);
        HybridPropertyIndexLookup lookup = new HybridPropertyIndexLookup(pr.indexPath, NodeStateUtils.getNode(rootState, pr.indexPath), plan.getPathPrefix(), false);
        FulltextIndexPlanner.PropertyIndexResult pir = pr.getPropertyIndexResult();
        if (pir != null) {
            Iterable queryResult = lookup.query(plan.getFilter(), pir.propertyName, pir.pr);
            paths = FluentIterable.from((Iterable)queryResult).transform(path -> pr.isPathTransformed() ? pr.transformPath(path) : path).filter(x -> x != null);
        } else {
            Validate.checkState((boolean)pr.evaluateSyncNodeTypeRestriction());
            Filter filter = plan.getFilter();
            paths = FluentIterable.from((Iterable)IterableUtils.chainedIterable((Iterable)lookup.query(filter, "jcr:primaryType", PropertyValues.newName(filter.getPrimaryTypes())), (Iterable)lookup.query(filter, "jcr:mixinTypes", PropertyValues.newName(filter.getMixinTypes()))));
        }
        FluentIterable propIndex = paths.transform(path -> new FulltextIndex.FulltextResultRow(path, 0.0, null, null, null));
        return IteratorUtils.chainedIterator((Iterator)propIndex.iterator(), itr);
    }

    static {
        if (!NON_LAZY) {
            LOG.warn("Lazy index download is enabled explicitly; this is not recommended, see OAK-10102.");
        }
    }

    static abstract class LuceneResultRowIterator
    extends AbstractIterator<FulltextIndex.FulltextResultRow>
    implements FulltextIndex.IteratorRewoundStateProvider {
        LuceneResultRowIterator() {
        }
    }

    static class LazyLuceneIndexNode
    implements LuceneIndexNode {
        private AtomicBoolean released = new AtomicBoolean();
        private IndexTracker tracker;
        private String indexPath;
        private volatile LuceneIndexNode indexNode;

        LazyLuceneIndexNode(IndexTracker tracker, String indexPath) {
            this.tracker = tracker;
            this.indexPath = indexPath;
        }

        public void release() {
            if (this.released.getAndSet(true)) {
                return;
            }
            if (this.indexNode != null) {
                this.indexNode.release();
            }
            this.indexNode = null;
            this.tracker = null;
            this.indexPath = null;
        }

        private void checkNotReleased() {
            if (this.released.get()) {
                throw new IllegalStateException("Already released");
            }
        }

        @Override
        public LuceneIndexDefinition getDefinition() {
            this.checkNotReleased();
            return this.tracker.getIndexDefinition(this.indexPath);
        }

        private LuceneIndexNode getIndexNode() {
            LuceneIndexNode n = this.findIndexNode();
            if (n == null) {
                String message = "No index node, corrupt index? " + this.indexPath;
                LOG.warn(message);
                throw new IllegalStateException(message);
            }
            return n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        private LuceneIndexNode findIndexNode() {
            this.checkNotReleased();
            LuceneIndexNode n = this.indexNode;
            if (n == null) {
                LazyLuceneIndexNode lazyLuceneIndexNode = this;
                synchronized (lazyLuceneIndexNode) {
                    n = this.indexNode;
                    if (n == null) {
                        n = this.indexNode = this.tracker.acquireIndexNode(this.indexPath);
                    }
                }
            }
            return n;
        }

        @Override
        public int getIndexNodeId() {
            return this.getIndexNode().getIndexNodeId();
        }

        @Override
        @Nullable
        public LuceneIndexStatistics getIndexStatistics() {
            LuceneIndexNode n = this.findIndexNode();
            if (n == null) {
                return null;
            }
            return n.getIndexStatistics();
        }

        @Override
        public IndexSearcher getSearcher() {
            return this.getIndexNode().getSearcher();
        }

        @Override
        public List<LuceneIndexReader> getPrimaryReaders() {
            return this.getIndexNode().getPrimaryReaders();
        }

        @Override
        @Nullable
        public Directory getSuggestDirectory() {
            return this.getIndexNode().getSuggestDirectory();
        }

        @Override
        public List<LuceneIndexReader> getNRTReaders() {
            return this.getIndexNode().getNRTReaders();
        }

        @Override
        @Nullable
        public AnalyzingInfixSuggester getLookup() {
            return this.getIndexNode().getLookup();
        }

        @Override
        @Nullable
        public LuceneIndexWriter getLocalWriter() throws IOException {
            return this.getIndexNode().getLocalWriter();
        }

        @Override
        public void refreshReadersOnWriteIfRequired() {
            this.getIndexNode().refreshReadersOnWriteIfRequired();
        }
    }

    static class LuceneFacetProvider
    implements FulltextIndex.FacetProvider {
        private final Facets facets;

        LuceneFacetProvider(Facets facets) {
            this.facets = facets;
        }

        public List<FulltextIndex.Facet> getFacets(int numberOfFacets, String columnName) throws IOException {
            String facetFieldName = FulltextIndex.parseFacetField((String)columnName);
            if (this.facets != null) {
                try {
                    ArrayList<FulltextIndex.Facet> res = new ArrayList<FulltextIndex.Facet>();
                    FacetResult topChildren = this.facets.getTopChildren(numberOfFacets, facetFieldName, new String[0]);
                    if (topChildren != null) {
                        for (LabelAndValue lav : topChildren.labelValues) {
                            res.add(new FulltextIndex.Facet(lav.label, lav.value.intValue()));
                        }
                        return Collections.unmodifiableList(res);
                    }
                }
                catch (IllegalArgumentException iae) {
                    LOG.debug(iae.getMessage(), iae);
                    LOG.warn("facets for {} not yet indexed: " + iae, (Object)facetFieldName);
                }
            }
            return null;
        }
    }

    class DelayedLuceneFacetProvider
    implements FulltextIndex.FacetProvider {
        private final LucenePropertyIndex index;
        private final Query query;
        private final QueryIndex.IndexPlan plan;
        private final IndexDefinition.SecureFacetConfiguration config;
        private final Map<String, List<FulltextIndex.Facet>> cachedResults = new HashMap<String, List<FulltextIndex.Facet>>();

        DelayedLuceneFacetProvider(LucenePropertyIndex index, Query query, QueryIndex.IndexPlan plan, IndexDefinition.SecureFacetConfiguration config) {
            this.index = index;
            this.query = query;
            this.plan = plan;
            this.config = config;
        }

        public List<FulltextIndex.Facet> getFacets(int numberOfFacets, String columnName) throws IOException {
            if (!LucenePropertyIndex.this.CACHE_FACET_RESULTS) {
                LOG.trace("{} = {} getting uncached results for columnName = {}", LucenePropertyIndex.CACHE_FACET_RESULTS_NAME, LucenePropertyIndex.this.CACHE_FACET_RESULTS, columnName);
                return this.getFacetsUncached(numberOfFacets, columnName);
            }
            String cacheKey = columnName + "/" + numberOfFacets;
            if (this.cachedResults.containsKey(cacheKey)) {
                LOG.trace("columnName = {} returning Facet Data from cache.", (Object)columnName);
                return this.cachedResults.get(cacheKey);
            }
            LOG.trace("columnName = {} facet Data not present in cache...", (Object)columnName);
            if (EAGER_FACET_CACHE_FILL) {
                this.fillFacetCache(numberOfFacets);
                if (this.cachedResults.containsKey(cacheKey)) {
                    LOG.trace("columnName = {} now found", (Object)cacheKey);
                    return this.cachedResults.get(cacheKey);
                }
                LOG.warn("Facet data for {} not found: read using query", (Object)cacheKey);
            }
            List<FulltextIndex.Facet> result = this.getFacetsUncached(numberOfFacets, columnName);
            this.cachedResults.put(cacheKey, result);
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<FulltextIndex.Facet> fillFacetCache(int numberOfFacets) throws IOException {
            List<FulltextIndex.Facet> result = null;
            LuceneIndexNode indexNode = this.index.acquireIndexNode(this.plan);
            try {
                IndexSearcher searcher = indexNode.getSearcher();
                Facets facets = FacetHelper.getFacets(searcher, this.query, this.plan, this.config);
                if (facets != null) {
                    List<String> allColumnNames = FacetHelper.getFacetColumnNamesFromPlan(this.plan);
                    for (String column : allColumnNames) {
                        result = this.getFacetsUncached(facets, numberOfFacets, column);
                        String cc = column + "/" + numberOfFacets;
                        this.cachedResults.put(cc, result);
                    }
                }
            }
            finally {
                indexNode.release();
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<FulltextIndex.Facet> getFacetsUncached(int numberOfFacets, String columnName) throws IOException {
            LuceneIndexNode indexNode = this.index.acquireIndexNode(this.plan);
            try {
                IndexSearcher searcher = indexNode.getSearcher();
                String facetFieldName = FulltextIndex.parseFacetField((String)columnName);
                Facets facets = FacetHelper.getFacets(searcher, this.query, this.plan, this.config);
                if (facets != null) {
                    try {
                        ArrayList<FulltextIndex.Facet> res = new ArrayList<FulltextIndex.Facet>();
                        FacetResult topChildren = facets.getTopChildren(numberOfFacets, facetFieldName, new String[0]);
                        if (topChildren != null) {
                            for (LabelAndValue lav : topChildren.labelValues) {
                                res.add(new FulltextIndex.Facet(lav.label, lav.value.intValue()));
                            }
                            List<FulltextIndex.Facet> list = Collections.unmodifiableList(res);
                            return list;
                        }
                    }
                    catch (IllegalArgumentException iae) {
                        LOG.debug(iae.getMessage(), iae);
                        LOG.warn("facets for {} not yet indexed: " + iae, (Object)facetFieldName);
                    }
                }
                List<FulltextIndex.Facet> list = null;
                return list;
            }
            finally {
                indexNode.release();
            }
        }

        private List<FulltextIndex.Facet> getFacetsUncached(Facets facets, int numberOfFacets, String columnName) throws IOException {
            String facetFieldName = FulltextIndex.parseFacetField((String)columnName);
            try {
                ArrayList<FulltextIndex.Facet> res = new ArrayList<FulltextIndex.Facet>();
                FacetResult topChildren = facets.getTopChildren(numberOfFacets, facetFieldName, new String[0]);
                if (topChildren == null) {
                    return null;
                }
                for (LabelAndValue lav : topChildren.labelValues) {
                    res.add(new FulltextIndex.Facet(lav.label, lav.value.intValue()));
                }
                return Collections.unmodifiableList(res);
            }
            catch (IllegalArgumentException iae) {
                LOG.debug(iae.getMessage(), iae);
                LOG.warn("facets for {} not yet indexed: {}", (Object)facetFieldName, (Object)iae);
                return null;
            }
        }
    }
}

