/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.util;

import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import javax.jcr.Credentials;
import javax.jcr.NamespaceException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.nodetype.NodeType;
import org.apache.jackrabbit.util.Text;
import org.apache.jackrabbit.vault.fs.api.ProgressTrackerListener;
import org.apache.jackrabbit.vault.fs.api.RepositoryAddress;
import org.apache.jackrabbit.vault.fs.api.WorkspaceFilter;
import org.apache.jackrabbit.vault.fs.io.AutoSave;
import org.apache.jackrabbit.vault.fs.spi.ProgressTracker;
import org.apache.jackrabbit.vault.util.CredentialsProvider;
import org.apache.jackrabbit.vault.util.RepositoryProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class RepositoryCopier {
    private static final Logger log = LoggerFactory.getLogger(RepositoryCopier.class);
    protected ProgressTrackerListener tracker;
    private transient int numNodes = 0;
    private transient int totalNodes = 0;
    private transient long totalSize = 0L;
    private transient long currentSize = 0L;
    private transient long start = 0L;
    private transient String lastKnownGood;
    private transient String currentPath;
    private transient String cqLastModified;
    private volatile boolean abort;
    private int batchSize = 1024;
    private long throttle = 0L;
    private transient String resumeFrom;
    private WorkspaceFilter srcFilter;
    private Map<String, String> prefixMapping = new HashMap<String, String>();
    private boolean onlyNewer;
    private boolean update;
    private boolean noOrdering;
    private CredentialsProvider credentialsProvider;

    public void setTracker(ProgressTrackerListener tracker) {
        this.tracker = tracker;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public long getThrottle() {
        return this.throttle;
    }

    public void setThrottle(long throttle) {
        this.throttle = throttle;
    }

    public void setSourceFilter(WorkspaceFilter srcFilter) {
        this.srcFilter = srcFilter;
    }

    public void setOnlyNewer(boolean onlyNewer) {
        this.onlyNewer = onlyNewer;
    }

    public void setUpdate(boolean update) {
        this.update = update;
    }

    public boolean isNoOrdering() {
        return this.noOrdering;
    }

    public void setNoOrdering(boolean noOrdering) {
        this.noOrdering = noOrdering;
    }

    public boolean isOnlyNewer() {
        return this.onlyNewer;
    }

    public boolean isUpdate() {
        return this.update;
    }

    public WorkspaceFilter getSrcFilter() {
        return this.srcFilter;
    }

    public String getResumeFrom() {
        return this.resumeFrom;
    }

    public void setResumeFrom(String resumeFrom) {
        this.resumeFrom = resumeFrom;
    }

    public String getLastKnownGood() {
        return this.lastKnownGood;
    }

    public String getCurrentPath() {
        return this.currentPath;
    }

    public int getCurrentNumNodes() {
        return this.numNodes;
    }

    public int getTotalNodes() {
        return this.totalNodes;
    }

    public long getTotalSize() {
        return this.totalSize;
    }

    public long getCurrentSize() {
        return this.currentSize;
    }

    public void abort() {
        this.abort = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copy(RepositoryAddress src, RepositoryAddress dst, boolean recursive) throws RepositoryException {
        this.track("", "Copy %s to %s (%srecursive)", src, dst, recursive ? "" : "non-");
        Session srcSession = null;
        Session dstSession = null;
        try {
            Repository dstRepo;
            Repository srcRepo;
            RepositoryProvider repProvider = new RepositoryProvider();
            try {
                srcRepo = repProvider.getRepository(src);
            }
            catch (RepositoryException e) {
                throw new RepositoryException("Error while retrieving source repository " + src, e);
            }
            try {
                dstRepo = repProvider.getRepository(dst);
            }
            catch (RepositoryException e) {
                throw new RepositoryException("Error while retrieving destination repository " + dst, e);
            }
            try {
                Credentials srcCreds = src.getCredentials();
                if (srcCreds == null && this.credentialsProvider != null) {
                    srcCreds = this.credentialsProvider.getCredentials(src);
                }
                srcSession = srcRepo.login(srcCreds, src.getWorkspace());
            }
            catch (RepositoryException e) {
                throw new RepositoryException("Could not log into source repository " + src, e);
            }
            try {
                Credentials dstCreds = dst.getCredentials();
                if (dstCreds == null && this.credentialsProvider != null) {
                    dstCreds = this.credentialsProvider.getCredentials(dst);
                }
                dstSession = dstRepo.login(dstCreds, dst.getWorkspace());
            }
            catch (RepositoryException e) {
                throw new RepositoryException("Could not log into destination repository " + dst, e);
            }
            this.copy(srcSession, src.getPath(), dstSession, dst.getPath(), recursive);
        }
        finally {
            if (srcSession != null) {
                srcSession.logout();
            }
            if (dstSession != null) {
                dstSession.logout();
            }
        }
    }

    public void copy(Session srcSession, String srcPath, Session dstSession, String dstPath, boolean recursive) throws RepositoryException {
        Node dstRoot;
        Node srcRoot;
        if (srcSession == null || dstSession == null) {
            throw new IllegalArgumentException("no src or dst session provided");
        }
        String dstParent = Text.getRelativeParent(dstPath, 1);
        String dstName = this.checkNameSpace(Text.getName(dstPath), srcSession, dstSession);
        try {
            srcRoot = srcSession.getNode(srcPath);
        }
        catch (RepositoryException e) {
            throw new RepositoryException("Error while retrieving source node " + srcPath, e);
        }
        try {
            dstRoot = dstSession.getNode(dstParent);
        }
        catch (RepositoryException e) {
            throw new RepositoryException("Error while retrieving destination parent node " + dstParent, e);
        }
        try {
            this.cqLastModified = srcSession.getNamespacePrefix("http://www.day.com/jcr/cq/1.0") + ":lastModified";
        }
        catch (RepositoryException e) {
            log.debug("Haven't found cq namespace", e);
        }
        this.numNodes = 0;
        this.totalNodes = 0;
        this.currentSize = 0L;
        this.totalSize = 0L;
        this.start = System.currentTimeMillis();
        AutoSave autoSave = new AutoSave();
        autoSave.setThreshold(this.getBatchSize());
        autoSave.setTracker(new ProgressTracker(this.tracker));
        this.copy(autoSave, srcRoot, dstRoot, dstName, recursive);
        if (this.numNodes > 0) {
            this.track("", "Saving %d nodes...", this.numNodes);
            autoSave.save(dstSession, false);
            this.track("", "Done.", new Object[0]);
        }
        long end = System.currentTimeMillis();
        this.track("", "Copy completed. %d nodes in %dms. %d bytes", this.totalNodes, end - this.start, this.totalSize);
    }

    private void copy(AutoSave autoSave, Node src, Node dstParent, String dstName, boolean recursive) throws RepositoryException {
        Node dst;
        String path;
        if (this.abort) {
            return;
        }
        this.currentPath = path = src.getPath();
        String dstPath = dstParent.getPath() + "/" + dstName;
        if (this.srcFilter != null && !this.srcFilter.contains(path)) {
            this.track(path, "------ I", new Object[0]);
            return;
        }
        boolean skip = false;
        if (this.resumeFrom != null) {
            if (path.equals(this.resumeFrom)) {
                this.resumeFrom = null;
            } else {
                skip = true;
            }
        }
        boolean useSysView = src.getDefinition().isProtected();
        boolean isNew = false;
        boolean overwrite = this.update;
        if (dstParent.hasNode(dstName)) {
            dst = dstParent.getNode(dstName);
            if (skip) {
                this.track(path, "------ S", new Object[0]);
            } else if (overwrite) {
                if (this.onlyNewer && dstName.equals("jcr:content")) {
                    if (this.isNewer(src, dst)) {
                        this.track(dstPath, "%06d U", ++this.totalNodes);
                    } else {
                        overwrite = false;
                        recursive = false;
                        this.track(dstPath, "%06d -", ++this.totalNodes);
                    }
                } else {
                    this.track(dstPath, "%06d U", ++this.totalNodes);
                }
                if (useSysView) {
                    dst = this.sysCopy(src, dstParent, dstName);
                }
            } else {
                this.track(dstPath, "%06d -", ++this.totalNodes);
            }
        } else {
            try {
                if (skip) {
                    this.track(path, "------ S", new Object[0]);
                    dst = null;
                } else {
                    dst = useSysView ? this.sysCopy(src, dstParent, dstName) : dstParent.addNode(dstName, src.getPrimaryNodeType().getName());
                }
                this.track(dstPath, "%06d A", ++this.totalNodes);
                isNew = true;
            }
            catch (RepositoryException e) {
                if (log.isDebugEnabled()) {
                    log.debug("Error while adding node {} (ignored)", (Object)dstPath, (Object)e);
                } else {
                    log.warn("Error while adding node {} (ignored): {}", (Object)dstPath, (Object)e.getMessage());
                }
                return;
            }
        }
        if (useSysView) {
            if (!skip) {
                this.trackTree(dst, isNew);
            }
        } else {
            HashSet<String> names = new HashSet<String>();
            if (!skip && (overwrite || isNew)) {
                PropertyIterator iter;
                if (!isNew) {
                    for (NodeType nt : dst.getMixinNodeTypes()) {
                        names.add(nt.getName());
                    }
                    for (NodeType nt : src.getMixinNodeTypes()) {
                        String mixName = this.checkNameSpace(nt.getName(), src.getSession(), dst.getSession());
                        if (names.remove(mixName)) continue;
                        dst.addMixin(nt.getName());
                    }
                    for (String mix : names) {
                        dst.removeMixin(mix);
                    }
                } else {
                    for (NodeType nt : src.getMixinNodeTypes()) {
                        dst.addMixin(this.checkNameSpace(nt.getName(), src.getSession(), dst.getSession()));
                    }
                }
                names.clear();
                if (!isNew) {
                    iter = dst.getProperties();
                    while (iter.hasNext()) {
                        names.add(this.checkNameSpace(iter.nextProperty().getName(), src.getSession(), dst.getSession()));
                    }
                }
                iter = src.getProperties();
                while (iter.hasNext()) {
                    Property p = iter.nextProperty();
                    String pName = this.checkNameSpace(p.getName(), src.getSession(), dst.getSession());
                    names.remove(pName);
                    if (p.getDefinition().isProtected()) continue;
                    if (dst.hasProperty(pName)) {
                        dst.getProperty(pName).remove();
                    }
                    if (p.getDefinition().isMultiple()) {
                        Value[] vs = p.getValues();
                        dst.setProperty(pName, vs);
                        for (long s : p.getLengths()) {
                            this.totalSize += s;
                            this.currentSize += s;
                        }
                        continue;
                    }
                    Value v = p.getValue();
                    dst.setProperty(pName, v);
                    long s = p.getLength();
                    this.totalSize += s;
                    this.currentSize += s;
                }
                for (String pName : names) {
                    try {
                        Property dstP = dst.getProperty(pName);
                        if (dstP.getDefinition().isProtected()) continue;
                        dstP.remove();
                    }
                    catch (RepositoryException dstP) {}
                }
            }
            if (recursive && dst != null) {
                Object child;
                NodeIterator niter;
                names.clear();
                if (overwrite && !isNew) {
                    niter = dst.getNodes();
                    while (niter.hasNext()) {
                        names.add(this.checkNameSpace(niter.nextNode().getName(), src.getSession(), dst.getSession()));
                    }
                }
                niter = src.getNodes();
                while (niter.hasNext()) {
                    child = niter.nextNode();
                    String cName = this.checkNameSpace(child.getName(), src.getSession(), dst.getSession());
                    names.remove(cName);
                    this.copy(autoSave, (Node)child, dst, cName, true);
                }
                if (this.resumeFrom == null) {
                    if (overwrite && !isNew && !this.noOrdering && src.getPrimaryNodeType().hasOrderableChildNodes()) {
                        niter = src.getNodes();
                        while (niter.hasNext()) {
                            child = niter.nextNode();
                            String name = child.getName();
                            if (!dst.hasNode(name)) continue;
                            dst.orderBefore(name, null);
                        }
                    }
                    for (String name : names) {
                        try {
                            Node cNode = dst.getNode(name);
                            this.track(cNode.getPath(), "%06d D", ++this.totalNodes);
                            cNode.remove();
                        }
                        catch (RepositoryException cNode) {}
                    }
                }
            }
        }
        if (!skip) {
            ++this.numNodes;
            autoSave.modified(1);
        }
        if (autoSave.needsSave()) {
            this.track("", "Intermediate saving %d nodes (%d kB)...", this.numNodes, this.currentSize / 1000L);
            long now = System.currentTimeMillis();
            autoSave.save(dst.getSession(), true);
            long end = System.currentTimeMillis();
            this.track("", "Done in %d ms. Total time: %d, total nodes %d, %d kB", end - now, end - this.start, this.totalNodes, this.totalSize / 1000L);
            this.lastKnownGood = this.currentPath;
            this.numNodes = 0;
            this.currentSize = 0L;
            if (this.throttle > 0L) {
                this.track("", "Throttling enabled. Waiting %d second%s...", this.throttle, this.throttle == 1L ? "" : "s");
                try {
                    Thread.sleep(this.throttle * 1000L);
                }
                catch (InterruptedException e) {
                    log.warn("Interrupted while waiting", e);
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    private Node sysCopy(Node src, Node dstParent, String dstName) throws RepositoryException {
        try {
            ContentHandler handler = dstParent.getSession().getImportContentHandler(dstParent.getPath(), 0);
            src.getSession().exportSystemView(src.getPath(), handler, true, false);
            return dstParent.getNode(dstName);
        }
        catch (SAXException e) {
            throw new RepositoryException("Unable to perform sysview copy", e);
        }
    }

    private void trackTree(Node node, boolean isNew) throws RepositoryException {
        NodeIterator iter = node.getNodes();
        while (iter.hasNext()) {
            Node child = iter.nextNode();
            if (isNew) {
                this.track(child.getPath(), "%06d A", ++this.totalNodes);
            } else {
                this.track(child.getPath(), "%06d U", ++this.totalNodes);
            }
            this.trackTree(child, isNew);
        }
    }

    private boolean isNewer(Node src, Node dst) {
        try {
            Calendar srcDate = null;
            Calendar dstDate = null;
            if (this.cqLastModified != null && src.hasProperty(this.cqLastModified) && dst.hasProperty(this.cqLastModified)) {
                srcDate = src.getProperty(this.cqLastModified).getDate();
                dstDate = dst.getProperty(this.cqLastModified).getDate();
            } else if (src.hasProperty("jcr:lastModified") && dst.hasProperty("jcr:lastModified")) {
                srcDate = src.getProperty("jcr:lastModified").getDate();
                dstDate = dst.getProperty("jcr:lastModified").getDate();
            }
            return srcDate == null || dstDate == null || srcDate.after(dstDate);
        }
        catch (RepositoryException e) {
            log.error("Unable to compare dates: {}", (Object)e.toString());
            return true;
        }
    }

    private String checkNameSpace(String name, Session srcSession, Session dstSession) {
        block9: {
            try {
                int idx = name.indexOf(58);
                if (idx <= 0) break block9;
                String prefix = name.substring(0, idx);
                String mapped = this.prefixMapping.get(prefix);
                if (mapped == null) {
                    String uri = srcSession.getNamespaceURI(prefix);
                    try {
                        mapped = dstSession.getNamespacePrefix(uri);
                    }
                    catch (NamespaceException e) {
                        mapped = prefix;
                        int i = 0;
                        while (i >= 0) {
                            try {
                                dstSession.getWorkspace().getNamespaceRegistry().registerNamespace(mapped, uri);
                                i = -1;
                            }
                            catch (NamespaceException e1) {
                                mapped = prefix + i++;
                            }
                        }
                    }
                    this.prefixMapping.put(prefix, mapped);
                }
                if (mapped.equals(prefix)) {
                    return name;
                }
                return mapped + name.substring(idx);
            }
            catch (RepositoryException e) {
                log.error("Error processing namespace for {}: {}", (Object)name, (Object)e.toString());
            }
        }
        return name;
    }

    private void track(String path, String fmt, Object ... args) {
        if (this.tracker != null) {
            this.tracker.onMessage(ProgressTrackerListener.Mode.TEXT, String.format(Locale.ENGLISH, fmt, args), path);
        }
    }

    public void setCredentialsProvider(CredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
    }

    public CredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.abort ? 1231 : 1237);
        result = 31 * result + this.batchSize;
        result = 31 * result + (this.noOrdering ? 1231 : 1237);
        result = 31 * result + (this.onlyNewer ? 1231 : 1237);
        result = 31 * result + (this.prefixMapping == null ? 0 : this.prefixMapping.hashCode());
        result = 31 * result + (this.resumeFrom == null ? 0 : this.resumeFrom.hashCode());
        result = 31 * result + (this.srcFilter == null ? 0 : this.srcFilter.hashCode());
        result = 31 * result + (int)(this.throttle ^ this.throttle >>> 32);
        result = 31 * result + (this.tracker == null ? 0 : this.tracker.hashCode());
        result = 31 * result + (this.update ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RepositoryCopier other = (RepositoryCopier)obj;
        if (this.abort != other.abort) {
            return false;
        }
        if (this.batchSize != other.batchSize) {
            return false;
        }
        if (this.noOrdering != other.noOrdering) {
            return false;
        }
        if (this.onlyNewer != other.onlyNewer) {
            return false;
        }
        if (this.prefixMapping == null ? other.prefixMapping != null : !this.prefixMapping.equals(other.prefixMapping)) {
            return false;
        }
        if (this.resumeFrom == null ? other.resumeFrom != null : !this.resumeFrom.equals(other.resumeFrom)) {
            return false;
        }
        if (this.srcFilter == null ? other.srcFilter != null : !this.srcFilter.equals(other.srcFilter)) {
            return false;
        }
        if (this.throttle != other.throttle) {
            return false;
        }
        if (this.tracker == null ? other.tracker != null : !this.tracker.equals(other.tracker)) {
            return false;
        }
        return this.update == other.update;
    }
}

