/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.core;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.SlingIOException;
import org.apache.sling.api.SlingServletException;
import org.apache.sling.api.request.RequestDispatcherOptions;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.scripting.InvalidServiceFilterSyntaxException;
import org.apache.sling.api.scripting.SlingScript;
import org.apache.sling.api.scripting.SlingScriptHelper;
import org.apache.sling.api.wrappers.SlingHttpServletRequestWrapper;
import org.apache.sling.api.wrappers.SlingHttpServletResponseWrapper;
import org.apache.sling.scripting.core.impl.helper.OnDemandReaderRequest;
import org.apache.sling.scripting.core.impl.helper.OnDemandWriterResponse;
import org.jetbrains.annotations.NotNull;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.slf4j.LoggerFactory;

public class ScriptHelper
implements SlingScriptHelper {
    private final SlingScript script;
    private final SlingHttpServletRequest request;
    private final SlingHttpServletResponse response;
    protected final BundleContext bundleContext;
    protected List<ServiceReference<?>> references;
    protected Map<String, Object> services;

    public ScriptHelper(BundleContext ctx, SlingScript script) {
        if (ctx == null) {
            throw new IllegalArgumentException("Bundle context must not be null.");
        }
        this.request = null;
        this.response = null;
        this.script = script;
        this.bundleContext = ctx;
    }

    public ScriptHelper(BundleContext ctx, SlingScript script, SlingHttpServletRequest request, SlingHttpServletResponse response) {
        if (ctx == null) {
            throw new IllegalArgumentException("Bundle context must not be null.");
        }
        this.script = script;
        this.request = this.wrapIfNeeded(request);
        this.response = this.wrapIfNeeded(response);
        this.bundleContext = ctx;
    }

    @Override
    public SlingScript getScript() {
        return this.script;
    }

    @Override
    public SlingHttpServletRequest getRequest() {
        return this.request;
    }

    @Override
    public SlingHttpServletResponse getResponse() {
        return this.response;
    }

    @Override
    public void include(String path) {
        this.include(path, (RequestDispatcherOptions)null);
    }

    @Override
    public void include(String path, String options) {
        this.include(path, new RequestDispatcherOptions(options));
    }

    @Override
    public void include(String path, RequestDispatcherOptions options) {
        RequestDispatcher dispatcher = this.getRequest().getRequestDispatcher(path, options);
        if (dispatcher != null) {
            try {
                dispatcher.include(this.getRequest(), this.getResponse());
            }
            catch (IOException ioe) {
                throw new SlingIOException(ioe);
            }
            catch (ServletException se) {
                throw new SlingServletException(se);
            }
        }
    }

    @Override
    public void forward(String path) {
        this.forward(path, (RequestDispatcherOptions)null);
    }

    @Override
    public void forward(String path, String options) {
        this.forward(path, new RequestDispatcherOptions(options));
    }

    @Override
    public void forward(String path, RequestDispatcherOptions options) {
        RequestDispatcher dispatcher = this.getRequest().getRequestDispatcher(path, options);
        if (dispatcher != null) {
            try {
                dispatcher.forward(this.getRequest(), this.getResponse());
            }
            catch (IOException ioe) {
                throw new SlingIOException(ioe);
            }
            catch (ServletException se) {
                throw new SlingServletException(se);
            }
        }
    }

    @Override
    @Deprecated
    public void dispose() {
        LoggerFactory.getLogger(this.getClass()).error("ScriptHelper#dispose has been called. This method is deprecated and should never be called by clients!");
    }

    public <T> T getService(Class<T> type) {
        ServiceReference ref;
        Object service;
        Object object = service = this.services == null ? null : this.services.get(type.getName());
        if (service == null && (ref = this.bundleContext.getServiceReference(type)) != null && (service = this.bundleContext.getService(ref)) != null) {
            if (this.services == null) {
                this.services = new HashMap<String, Object>();
            }
            if (this.references == null) {
                this.references = new ArrayList();
            }
            this.references.add(ref);
            this.services.put(type.getName(), service);
        }
        return (T)service;
    }

    public <T> T[] getServices(Class<T> serviceType, String filter) throws InvalidServiceFilterSyntaxException {
        try {
            Collection refsCollection = this.bundleContext.getServiceReferences(serviceType, filter);
            Object[] result = null;
            if (refsCollection != null) {
                ArrayList refsList = new ArrayList(refsCollection);
                Collections.sort(refsList);
                Collections.reverse(refsList);
                ArrayList<Object> objects = new ArrayList<Object>();
                for (ServiceReference reference : refsList) {
                    Object service = this.bundleContext.getService(reference);
                    if (service == null) continue;
                    if (this.references == null) {
                        this.references = new ArrayList();
                    }
                    this.references.add(reference);
                    objects.add(service);
                }
                if (!objects.isEmpty()) {
                    Object[] srv = (Object[])Array.newInstance(serviceType, objects.size());
                    result = objects.toArray(srv);
                }
            }
            return result;
        }
        catch (InvalidSyntaxException ise) {
            throw new InvalidServiceFilterSyntaxException(filter, "Invalid filter syntax", ise);
        }
    }

    public void cleanup() {
        if (this.references != null) {
            for (ServiceReference<?> ref : this.references) {
                this.bundleContext.ungetService(ref);
            }
            this.references.clear();
        }
        if (this.services != null) {
            this.services.clear();
        }
    }

    @Override
    public void forward(Resource resource) {
        this.forward(resource, (RequestDispatcherOptions)null);
    }

    @Override
    public void forward(Resource resource, String options) {
        this.forward(resource, new RequestDispatcherOptions(options));
    }

    @Override
    public void forward(Resource resource, RequestDispatcherOptions options) {
        RequestDispatcher dispatcher = this.getRequest().getRequestDispatcher(resource, options);
        if (dispatcher != null) {
            try {
                dispatcher.forward(this.getRequest(), this.getResponse());
            }
            catch (IOException ioe) {
                throw new SlingIOException(ioe);
            }
            catch (ServletException se) {
                throw new SlingServletException(se);
            }
        }
    }

    @Override
    public void include(Resource resource) {
        this.include(resource, (RequestDispatcherOptions)null);
    }

    @Override
    public void include(Resource resource, String options) {
        this.include(resource, new RequestDispatcherOptions(options));
    }

    @Override
    public void include(Resource resource, RequestDispatcherOptions options) {
        RequestDispatcher dispatcher = this.getRequest().getRequestDispatcher(resource, options);
        if (dispatcher != null) {
            try {
                dispatcher.include(this.getRequest(), this.getResponse());
            }
            catch (IOException ioe) {
                throw new SlingIOException(ioe);
            }
            catch (ServletException se) {
                throw new SlingServletException(se);
            }
        }
    }

    private SlingHttpServletRequest wrapIfNeeded(@NotNull SlingHttpServletRequest request) {
        SlingHttpServletRequest initialRequest = request;
        while (request instanceof SlingHttpServletRequestWrapper) {
            if (request instanceof OnDemandReaderRequest) {
                return initialRequest;
            }
            request = ((SlingHttpServletRequestWrapper)request).getSlingRequest();
        }
        return new OnDemandReaderRequest(initialRequest);
    }

    private SlingHttpServletResponse wrapIfNeeded(@NotNull SlingHttpServletResponse response) {
        SlingHttpServletResponse initialResponse = response;
        while (response instanceof SlingHttpServletResponseWrapper) {
            if (response instanceof OnDemandWriterResponse) {
                return initialResponse;
            }
            response = ((SlingHttpServletResponseWrapper)response).getSlingResponse();
        }
        return new OnDemandWriterResponse(initialResponse);
    }
}

