/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.pdf;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.List;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.io.MemoryUsageSetting;
import org.apache.pdfbox.pdfparser.XrefTrailerResolver;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.preflight.Format;
import org.apache.pdfbox.preflight.PreflightConfiguration;
import org.apache.pdfbox.preflight.PreflightContext;
import org.apache.pdfbox.preflight.PreflightDocument;
import org.apache.pdfbox.preflight.ValidationResult;
import org.apache.pdfbox.preflight.exception.SyntaxValidationException;
import org.apache.pdfbox.preflight.parser.PreflightParser;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.PDF;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.pdf.PDFParser;
import org.apache.tika.utils.ExceptionUtils;

@Deprecated
public class PDFPreflightParser
extends PDFParser {
    private static final PDFPreflightParserConfig DEFAULT = new PDFPreflightParserConfig();

    @Override
    protected PDDocument getPDDocument(InputStream inputStream, String password, MemoryUsageSetting memoryUsageSetting, Metadata metadata, ParseContext parseContext) throws IOException {
        try (TikaInputStream tis = TikaInputStream.get(inputStream);){
            PDDocument pDDocument = this.getPDDocument(tis.getPath(), password, memoryUsageSetting, metadata, parseContext);
            return pDDocument;
        }
    }

    @Override
    protected PDDocument getPDDocument(Path path, String password, MemoryUsageSetting memoryUsageSetting, Metadata metadata, ParseContext context) throws IOException {
        PDFPreflightParserConfig pppConfig = context.get(PDFPreflightParserConfig.class, DEFAULT);
        PreflightConfiguration configuration = new PreflightConfiguration();
        configuration.setMaxErrors(pppConfig.getMaxErrors());
        PreflightParser preflightParser = new PreflightParser(path.toFile());
        preflightParser.setLenient(pppConfig.isLenient);
        try {
            preflightParser.parse(pppConfig.getFormat(), configuration);
        }
        catch (SyntaxValidationException e) {
            return this.handleSyntaxException(path, password, memoryUsageSetting, metadata, e);
        }
        PreflightDocument preflightDocument = preflightParser.getPreflightDocument();
        preflightDocument.validate();
        this.extractPreflight(preflightDocument, metadata);
        return preflightParser.getPreflightDocument();
    }

    private void extractPreflight(PreflightDocument preflightDocument, Metadata metadata) {
        COSDictionary linearized;
        ValidationResult result = preflightDocument.getResult();
        metadata.set(PDF.PREFLIGHT_SPECIFICATION, preflightDocument.getSpecification().toString());
        metadata.set(PDF.PREFLIGHT_IS_VALID, Boolean.toString(result.isValid()));
        List errors = result.getErrorsList();
        for (ValidationResult.ValidationError err : errors) {
            metadata.add(PDF.PREFLIGHT_VALIDATION_ERRORS, err.getErrorCode() + " : " + err.getDetails());
        }
        PreflightContext preflightContext = preflightDocument.getContext();
        XrefTrailerResolver resolver = preflightContext.getXrefTrailerResolver();
        int trailerCount = resolver.getTrailerCount();
        metadata.set(PDF.PREFLIGHT_TRAILER_COUNT, trailerCount);
        metadata.set(PDF.PREFLIGHT_XREF_TYPE, resolver.getXrefType().toString());
        if (preflightContext.getIccProfileWrapper() != null && preflightContext.getIccProfileWrapper().getProfile() != null) {
            metadata.set(PDF.PREFLIGHT_ICC_PROFILE, preflightContext.getIccProfileWrapper().getProfile().toString());
        }
        if ((linearized = PDFPreflightParser.getLinearizedDictionary((PDDocument)preflightDocument)) != null) {
            metadata.set(PDF.PREFLIGHT_IS_LINEARIZED, "true");
            if (trailerCount > 2) {
                metadata.set(PDF.PREFLIGHT_INCREMENTAL_UPDATES, "true");
            } else {
                metadata.set(PDF.PREFLIGHT_INCREMENTAL_UPDATES, "false");
            }
        } else {
            metadata.set(PDF.PREFLIGHT_IS_LINEARIZED, "false");
            if (trailerCount > 1) {
                metadata.set(PDF.PREFLIGHT_INCREMENTAL_UPDATES, "true");
            } else {
                metadata.set(PDF.PREFLIGHT_INCREMENTAL_UPDATES, "false");
            }
        }
    }

    protected static COSDictionary getLinearizedDictionary(PDDocument document) {
        COSDocument cDoc = document.getDocument();
        List lObj = cDoc.getObjects();
        for (Object object : lObj) {
            COSBase curObj = ((COSObject)object).getObject();
            if (!(curObj instanceof COSDictionary) || !((COSDictionary)curObj).keySet().contains(COSName.getPDFName((String)"Linearized"))) continue;
            return (COSDictionary)curObj;
        }
        return null;
    }

    private PDDocument handleSyntaxException(Path path, String password, MemoryUsageSetting memoryUsageSetting, Metadata metadata, SyntaxValidationException e) throws IOException {
        metadata.add(PDF.PREFLIGHT_PARSE_EXCEPTION, ExceptionUtils.getStackTrace(e));
        return PDDocument.load((File)path.toFile(), (String)password, (MemoryUsageSetting)memoryUsageSetting);
    }

    private static class PDFPreflightParserConfig {
        private int maxErrors = 100;
        private boolean isLenient = true;
        private Format format = Format.PDF_A1B;

        private PDFPreflightParserConfig() {
        }

        public int getMaxErrors() {
            return this.maxErrors;
        }

        public boolean isLenient() {
            return this.isLenient;
        }

        public Format getFormat() {
            return this.format;
        }
    }
}

