/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.msm.ui.models.alllivecopies;

import com.adobe.cq.msm.ui.models.alllivecopies.LiveCopiesCell;
import com.adobe.cq.msm.ui.models.alllivecopies.LiveCopiesRow;
import com.adobe.cq.msm.ui.models.alllivecopies.LiveCopyTable;
import com.adobe.cq.msm.ui.util.MSMUtil;
import com.adobe.cq.msm.ui.util.StatusDetails;
import com.adobe.granite.toggle.api.ToggleRouter;
import com.adobe.granite.ui.components.Config;
import com.adobe.granite.ui.components.ExpressionHelper;
import com.adobe.granite.ui.components.ExpressionResolver;
import com.adobe.granite.xss.XSSAPI;
import com.day.cq.wcm.msm.api.BlueprintManager;
import com.day.cq.wcm.msm.api.LiveRelationshipManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import javax.jcr.RangeIterator;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.commons.json.io.JSONStringer;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;
import org.apache.sling.models.annotations.injectorspecific.ScriptVariable;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={SlingHttpServletRequest.class}, adapters={LiveCopyTable.class}, resourceType={"wcm/msm/gui/components/alllivecopies"})
public class LiveCopiesTable
implements LiveCopyTable {
    private static final Logger log = LoggerFactory.getLogger(LiveCopiesTable.class);
    public static final String CT_SITES_29075 = "CT_SITES-29075";
    public static final String FT_LC_OVERVIEW_COL_PAGINATION = "FT_SITES-33611";
    @Self
    protected SlingHttpServletRequest request;
    private Resource resource;
    protected Resource rootResource;
    private ResourceResolver resourceResolver;
    protected LiveRelationshipManager relationMgr;
    protected BlueprintManager bpm;
    private Map<String, String> tableAttrbsMap;
    private boolean tableExists;
    private Map<String, String> liveCopiesMap;
    protected Pattern excludePattern;
    @ScriptVariable
    protected XSSAPI xssAPI;
    @OSGiService
    private ExpressionResolver expressionResolver;
    private List<Resource> childResources = new LinkedList<Resource>();
    protected String rootPath;
    private List<LiveCopiesRow> rows;
    private ToggleRouter toggleRouter;
    private boolean isColumnPaginationEnabled;
    private int columnStartIndex = 0;
    private int columnEndIndex = 5;
    private static final int COLUMN_INCREMENT = 5;

    @PostConstruct
    public void postConstruct() throws Exception {
        this.resource = this.request.getResource();
        this.resourceResolver = this.request.getResourceResolver();
        this.relationMgr = this.resourceResolver.adaptTo(LiveRelationshipManager.class);
        this.bpm = this.resourceResolver.adaptTo(BlueprintManager.class);
        ExpressionHelper exp = new ExpressionHelper(this.expressionResolver, this.request);
        this.rootPath = StringUtils.trimToNull(this.request.getRequestPathInfo().getSuffix());
        this.rootResource = this.resourceResolver.getResource(this.rootPath);
        this.setToggleRouter();
        if (this.rootResource == null) {
            this.tableExists = false;
            return;
        }
        Config cfg = new Config(this.resource);
        String filter = cfg.get("exclude", "");
        this.excludePattern = Pattern.compile(filter);
        this.tableExists = true;
        String src = StringUtils.trimToNull(exp.getString(cfg.get("src", String.class)));
        String layoutName = "foundation-layout-table";
        String selectionCount = cfg.get("selectionCount", "multiple");
        this.tableAttrbsMap = new HashMap<String, String>();
        this.tableAttrbsMap.put("data-foundation-collection-id", this.rootPath);
        this.tableAttrbsMap.put("data-foundation-collection-src", src);
        this.tableAttrbsMap.put("data-foundation-selections-mode", selectionCount);
        this.tableAttrbsMap.put("data-foundation-mode-group", cfg.get("modeGroup", String.class));
        this.tableAttrbsMap.put("data-foundation-layout-table-hasmore", "false");
        String layoutJson = new JSONStringer().object().key("name").value(layoutName).key("sortMode").value(cfg.get("sortMode", String.class)).key("layoutId").value(this.resource.getName()).endObject().toString();
        this.tableAttrbsMap.put("class", cfg.get("granite:rel", "cq-wcm-msm-all-live-copies") + " foundation-layout-util-maximized-alt foundation-collection foundation-layout-table coral-Table-wrapper coral-Table-wrapper--sticky " + layoutName);
        this.tableAttrbsMap.put("data-foundation-layout", layoutJson);
        if ("multiple".equals(selectionCount)) {
            this.tableAttrbsMap.put("multiple", selectionCount);
            this.tableAttrbsMap.put("selectionMode", cfg.get("selectionMode", "none"));
        }
        this.tableAttrbsMap.put("selectable", "selectable");
        RangeIterator rootRelations = this.relationMgr.getLiveRelationships(this.rootResource, null, null);
        this.liveCopiesMap = MSMUtil.getFilteredNames((RangeIterator)rootRelations);
        boolean bl = this.isColumnPaginationEnabled = this.toggleRouter != null && this.toggleRouter.isEnabled(FT_LC_OVERVIEW_COL_PAGINATION);
        if (this.isColumnPaginationEnabled) {
            if (this.request.getParameter("colStartIndex") != null) {
                try {
                    this.columnStartIndex = Integer.parseInt(this.request.getParameter("colStartIndex"));
                }
                catch (NumberFormatException e) {
                    this.columnStartIndex = 0;
                }
            }
            if (this.request.getParameter("colEndIndex") != null) {
                try {
                    this.columnEndIndex = Integer.parseInt(this.request.getParameter("colEndIndex"));
                }
                catch (NumberFormatException e) {
                    this.columnEndIndex = 5;
                }
            }
        }
        Iterator<Resource> resourceIterator = this.rootResource.listChildren();
        int startIndex = 0;
        int endIndex = 10;
        if (this.request.getParameter("startIndex") != null) {
            startIndex = Integer.parseInt(this.request.getParameter("startIndex"));
        }
        if (this.request.getParameter("endIndex") != null) {
            endIndex = Integer.parseInt(this.request.getParameter("endIndex"));
        }
        for (int index = 0; resourceIterator.hasNext() && index < endIndex; ++index) {
            if (index >= startIndex) {
                this.childResources.add(resourceIterator.next());
                continue;
            }
            resourceIterator.next();
        }
    }

    @Override
    public List<LiveCopiesRow> getRows() {
        if (this.toggleRouter != null && this.toggleRouter.isEnabled(CT_SITES_29075) && this.rows != null) {
            return this.rows;
        }
        boolean startIndex = false;
        this.rows = new LinkedList<LiveCopiesRow>();
        try {
            for (Resource resource : this.getChildResources()) {
                if (!this.isResourceAcceptable(resource) || !MSMUtil.isPage((Resource)resource) && !resource.isResourceType("sling:Folder") && !resource.isResourceType("sling:OrderedFolder")) continue;
                String relSourcePath = MSMUtil.getRelativeSourcePath((Resource)this.rootResource, (Resource)resource);
                String relPath = "";
                if (!resource.getPath().startsWith(this.rootPath + "/")) continue;
                relPath = resource.getPath().substring(this.rootPath.length() + 1);
                String rowTitle = MSMUtil.getTitle((ResourceResolver)this.resourceResolver, (Resource)resource);
                String rowPath = resource.getPath();
                String thumbnailPath = this.xssAPI.getValidHref(this.request.getContextPath() + MSMUtil.getThumbnailUrl((ResourceResolver)this.resourceResolver, (Resource)resource, (int)48, (int)48));
                ArrayList<LiveCopiesCell> cellInfo = new ArrayList<LiveCopiesCell>();
                boolean isBlueprint = false;
                Map<String, String> columnsToShow = this.liveCopiesMap;
                if (this.isColumnPaginationEnabled) {
                    columnsToShow = this.getPaginatedColumns();
                }
                for (String liveCopyPath : columnsToShow.keySet()) {
                    if (StringUtils.isEmpty(liveCopyPath)) continue;
                    String currliveCopyPath = String.format("%s/%s", liveCopyPath, relPath);
                    String statusMesg = MSMUtil.getStatus((LiveRelationshipManager)this.relationMgr, (Resource)resource, (String)currliveCopyPath);
                    StatusDetails statusDetails = (StatusDetails)MSMUtil.STATUS_DETAIL_MAP.get(statusMesg);
                    Map cellAttrbs = MSMUtil.getLiveCopyCellAttributes((XSSAPI)this.xssAPI, (String)currliveCopyPath, (String)resource.getPath(), (String)statusMesg);
                    if (!isBlueprint && !"msm-status-target-does-not-exist".equals(statusMesg)) {
                        isBlueprint = true;
                    }
                    LiveCopiesCell allLiveCopiesCell = new LiveCopiesCell(statusDetails.getIconName(), statusDetails.getIconClass(), statusDetails.getStatusMessage(), cellAttrbs);
                    cellInfo.add(allLiveCopiesCell);
                }
                if (!isBlueprint && this.liveCopiesMap.isEmpty()) {
                    isBlueprint = MSMUtil.isResourceBlueprint((BlueprintManager)this.bpm, (LiveRelationshipManager)this.relationMgr, (Resource)resource);
                }
                String rowActionRels = MSMUtil.getBlueprintActionRels((boolean)isBlueprint);
                this.rows.add(new LiveCopiesRow(true, rowPath, rowTitle, cellInfo, thumbnailPath, rowActionRels, relSourcePath));
            }
        }
        catch (Exception ex) {
            log.warn("Exception occurred while processing live copies table", ex);
        }
        return this.rows;
    }

    void setToggleRouter() {
        BundleContext bundleContext = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
        ServiceReference ref = bundleContext.getServiceReference(ToggleRouter.class);
        this.toggleRouter = (ToggleRouter)bundleContext.getService(ref);
    }

    private boolean isResourceAcceptable(Resource currResource) {
        if (this.excludePattern.matcher(currResource.getPath()).matches()) {
            return false;
        }
        if (MSMUtil.isPage((Resource)currResource)) {
            return true;
        }
        if (currResource.isResourceType("sling:Folder") || currResource.isResourceType("sling:OrderedFolder")) {
            String currPath = currResource.getPath();
            if (currPath.startsWith("/content/experience-fragments")) {
                return true;
            }
            if (currPath.startsWith("/content/campaigns")) {
                return false;
            }
        }
        return MSMUtil.isFolder((Resource)currResource);
    }

    protected List<Resource> getChildResources() {
        return this.childResources;
    }

    @Override
    public String getPath() {
        return this.resource.getPath();
    }

    @Override
    public Map<String, String> getColumns() {
        if (this.isColumnPaginationEnabled) {
            return this.getPaginatedColumns();
        }
        return this.liveCopiesMap;
    }

    @Override
    public Map<String, String> getTableAttrbs() {
        return this.tableAttrbsMap;
    }

    @Override
    public boolean tableExist() {
        return this.tableExists;
    }

    @Override
    public boolean hasChildren() {
        return !this.getRows().isEmpty();
    }

    @Override
    public int columnsSize() {
        return this.liveCopiesMap.size() + 2;
    }

    protected Map<String, String> getPaginatedColumns() {
        if (this.liveCopiesMap == null || this.liveCopiesMap.isEmpty()) {
            return this.liveCopiesMap != null ? this.liveCopiesMap : new HashMap<String, String>();
        }
        HashMap<String, String> paginatedColumns = new HashMap<String, String>();
        ArrayList<Map.Entry<String, String>> columnList = new ArrayList<Map.Entry<String, String>>(this.liveCopiesMap.entrySet());
        int endIndex = Math.min(this.columnEndIndex, columnList.size());
        if (this.columnStartIndex >= 0 && this.columnStartIndex < columnList.size() && endIndex > this.columnStartIndex) {
            for (int i = this.columnStartIndex; i < endIndex; ++i) {
                Map.Entry entry = (Map.Entry)columnList.get(i);
                paginatedColumns.put((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return paginatedColumns;
    }

    public int getColumnStartIndex() {
        return this.columnStartIndex;
    }

    public int getColumnEndIndex() {
        return this.columnEndIndex;
    }

    public int getColumnSize() {
        return this.liveCopiesMap != null ? this.liveCopiesMap.size() : 0;
    }

    public int getDecreaseColumnStartIndex() {
        return Math.max(this.columnStartIndex - 5, 0);
    }

    public int getIncreaseColumnEndIndex() {
        if (this.liveCopiesMap == null) {
            return this.columnEndIndex;
        }
        if (this.columnEndIndex + 5 >= this.liveCopiesMap.size()) {
            return this.liveCopiesMap.size();
        }
        return this.columnEndIndex + 5;
    }

    public boolean isColumnPaginationEnabled() {
        return this.isColumnPaginationEnabled;
    }
}

