/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa;

import com.adobe.xfa.AppModel;
import com.adobe.xfa.Chars;
import com.adobe.xfa.DOMSaveOptions;
import com.adobe.xfa.Element;
import com.adobe.xfa.Node;
import com.adobe.xfa.PacketScript;
import com.adobe.xfa.ScriptTable;
import java.io.IOException;
import java.io.OutputStream;

public final class Packet
extends Element
implements Element.DualDomNode {
    private Element mXmlPeer;

    public Packet(Element parent, Node prevSibling) {
        super(parent, prevSibling, null, "packet", "packet", null, 220, "packet");
        if (parent != null) {
            if (!(parent instanceof AppModel)) {
                throw new IllegalArgumentException("parent is not an AppModel.");
            }
            this.setDocument(parent.getOwnerDocument());
            this.setModel((AppModel)parent);
        }
    }

    public String getAttribute(String sAttrName) {
        int oAttr = this.findAttr(null, sAttrName.intern());
        if (oAttr != -1) {
            return this.getAttrVal(oAttr);
        }
        return "";
    }

    public String getContent() {
        for (Node oChild = this.getFirstXMLChild(); oChild != null; oChild = oChild.getNextXMLSibling()) {
            if (!(oChild instanceof Chars)) continue;
            Chars oText = (Chars)oChild;
            return oText.getText();
        }
        return "";
    }

    @Override
    public String getName() {
        return this.getLocalName();
    }

    @Override
    public ScriptTable getScriptTable() {
        return PacketScript.getScriptTable();
    }

    @Override
    public boolean isValidAttr(int eTag, boolean bReport, String value) {
        return true;
    }

    @Override
    public Node getFirstXFAChild() {
        return null;
    }

    @Override
    public void serialize(OutputStream outStream, DOMSaveOptions options, int level, Node prevSibling) throws IOException, IOException {
        this.getXmlPeer().serialize(outStream, options, level, prevSibling);
    }

    public void removeAttribute(String sAttrName) {
        String aAttrName = sAttrName.intern();
        super.removeAttr(null, aAttrName);
    }

    public void setAttribute(String sValue, String sAttrName) {
        this.setAttribute(null, sAttrName, sAttrName, sValue);
        this.makeNonDefault(false);
    }

    public void setContent(String sContent) {
        for (Node oChild = this.getFirstXMLChild(); oChild != null; oChild = oChild.getNextXMLSibling()) {
            this.removeChild(oChild);
        }
        this.getModel().createTextNode(this, null, sContent);
        this.makeNonDefault(false);
    }

    @Override
    protected boolean compareVersions(Node oRollbackElement, Node oContainer, Node.ChangeLogger oChangeLogger, Object oUserData) {
        return this.compareVersionsCanonically(oRollbackElement, oContainer, oChangeLogger, oUserData);
    }

    @Override
    public void setXmlPeer(Node peer) {
        this.mXmlPeer = (Element)peer;
    }

    @Override
    public Node getXmlPeer() {
        return this.mXmlPeer;
    }
}

